/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

import com.cognos.cclcorej.util.CCLResourceCounterSet;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.logging.LoggingRealm;
import com.cognos.pogo.logging.LoggingRealmFactory;
import com.cognos.pogo.pdk.MessageContext;

public class PogoIPFLog {
    static final LoggingRealm loggingRealm = LoggingRealmFactory.getInstance("DISP");
    private static LogTypedLogger alog = LogTypedLogger.getInstance((String)"Audit.dispatcher", LogAuditIndication.class);
    private static LogTypedLogger perfLog = LogTypedLogger.getInstance((String)"Perf.dispatcher", LogPerfIndication.class);
    private static LogTypedLogger traceLog = LogTypedLogger.getInstance((String)"Trace.dispatcher", LogTraceIndication.class);
    private static final String pkg = "DISP";
    private static PogoIPFLog instance = new PogoIPFLog();

    public static PogoIPFLog getInstance() {
        return instance;
    }

    public void logServiceChange(String servicePath, String operation) {
        if (alog.isEnabled(50000)) {
            LogAuditAccessIndication auditInd = loggingRealm.getAuditAccessIndication();
            auditInd.setLevel(50000);
            auditInd.setLogData(servicePath);
            auditInd.setOperation(operation);
            auditInd.setStatus("Success");
            alog.log((Object)auditInd);
        }
    }

    public void logRequest(String servicePath) {
        if (alog.isEnabled(50000)) {
            LogAuditIndication auditInd = loggingRealm.getAuditIndication();
            auditInd.setLevel(20000);
            auditInd.setLogData(servicePath);
            auditInd.setOperation("Request");
            alog.log((Object)auditInd);
        }
    }

    public void logStartupError(String error) {
        if (alog.isEnabled(50000)) {
            LogAuditIndication auditInd = loggingRealm.getAuditIndication();
            auditInd.setLevel(20000);
            auditInd.setLogData(error);
            auditInd.setOperation("StartService");
            alog.log((Object)auditInd);
        }
    }

    public void logTraceRequest(String servicePath) {
        if (traceLog.isEnabled(30000)) {
            LogTraceIndication traceInd = loggingRealm.getTraceIndication();
            traceInd.setLevel(30000);
            traceInd.setAction((byte)11);
            traceInd.setObject(servicePath);
            traceLog.log((Object)traceInd);
        }
    }

    public void logRequestTime(MessageContext mc, long time) {
        if (perfLog.isEnabled(30000)) {
            CCLResourceCounterSet lcs = new CCLResourceCounterSet(pkg, null);
            LogPerfIndication perfInd = loggingRealm.getPerfIndication(lcs);
            perfInd.setLevel(30000);
            perfInd.setStepID(mc.getStrProperty("request.soapaction"));
            lcs.updateResource((byte)2, time);
            perfLog.log((Object)perfInd);
        }
    }

    public void logSuccessStatus(String message) {
        this.logSuccessStatus(message, null);
    }

    public void logSuccessStatus(String message, Object[] parameters) {
        if (alog.isEnabled(50000)) {
            this.logStatus("StartService", message, parameters, "Success");
        }
    }

    public void logFailureStatus(String message) {
        this.logFailureStatus(message, null);
    }

    public void logFailureStatus(String message, Object[] parameters) {
        if (alog.isEnabled(50000)) {
            this.logStatus("StartService", message, parameters, "Failure");
        }
    }

    public void logShutdownStatus(String message) {
        this.logShutdownStatus(message, null);
    }

    public void logShutdownStatus(String message, Object[] parameters) {
        if (alog.isEnabled(50000)) {
            this.logStatus("StopService", message, parameters, "Success");
        }
    }

    private void logStatus(String operation, String message, Object[] parameters, String status) {
        LogAuditAccessIndication auditInd = loggingRealm.getAuditAccessIndication();
        auditInd.setOperation(operation);
        DispatcherStrings ds = DispatcherStrings.getInstance();
        String logData = parameters != null ? ds.getString(message, parameters) : ds.getString(message);
        auditInd.setErrorMessage(logData);
        auditInd.setStatus(status);
        alog.log((Object)auditInd);
    }

    protected void setDummyIPFLoggers(LogTypedLogger aLog, LogTypedLogger pLog, LogTypedLogger tLog) {
        alog = aLog;
        perfLog = pLog;
        traceLog = tLog;
    }
}

