/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

import com.cognos.pogo.util.StackTrace;
import java.util.ArrayList;
import java.util.List;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.log.Priority;

public class PogoLogger {
    protected static final String DEFAULT_LOGGER_NAME = PogoLogger.class.getName();
    protected static StackTrace stackTrace = new StackTrace();
    private final String name;
    private Logger log;

    public static PogoLogger getLogger() {
        StackTraceElement caller = stackTrace.getCaller();
        String callerName = caller != null ? caller.getClassName() : DEFAULT_LOGGER_NAME;
        return new PogoLogger(callerName);
    }

    public static PogoLogger getLoggerFor(Class<? extends Object> ownerClass) {
        return PogoLogger.getLoggerFor(ownerClass.getName());
    }

    public static PogoLogger getLoggerFor(String name) {
        return new PogoLogger(name);
    }

    protected PogoLogger(String name) {
        this.name = name;
        this.log = Hierarchy.getDefaultHierarchy().getLoggerFor(name);
        this.warnIfDefaultLoggerNameIsUsed(name);
    }

    private void warnIfDefaultLoggerNameIsUsed(String name) {
        if (name.equals(DEFAULT_LOGGER_NAME)) {
            this.warn("Unable to retrieve class name from stack trace. Using default logger name: ", DEFAULT_LOGGER_NAME);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public static String getString(Object[] args) {
        StringBuilder sb = new StringBuilder();
        for (Object arg : args) {
            sb.append(arg);
        }
        return sb.toString();
    }

    protected void logDebug(String msg) {
        this.log.debug(msg);
    }

    public void debug(Object ... args) {
        if (this.isDebugEnabled()) {
            this.logDebug(PogoLogger.getString(args));
        }
    }

    public void info(Object ... args) {
        if (this.isInfoEnabled()) {
            this.logInfo(PogoLogger.getString(args));
        }
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    protected void logInfo(String msg) {
        this.log.info(msg);
    }

    public void warn(Object ... args) {
        if (this.isWarnEnabled()) {
            this.logWarn(PogoLogger.getString(args));
        }
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    protected void logWarn(String msg) {
        this.log.warn(msg);
    }

    public void error(Object ... args) {
        if (this.isErrorEnabled()) {
            this.logError(PogoLogger.getString(args));
        }
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    protected void logError(String msg) {
        this.log.error(msg);
    }

    public void fatalError(Object ... args) {
        if (this.isFatalErrorEnabled()) {
            this.logFatalError(PogoLogger.getString(args));
        }
    }

    public boolean isFatalErrorEnabled() {
        return this.log.isFatalErrorEnabled();
    }

    protected void logFatalError(String msg) {
        this.log.fatalError(msg);
    }

    public Logger getNativeLogger() {
        return this.log;
    }

    public void enter() {
        if (this.isDebugEnabled()) {
            this.logEnteringMessage(stackTrace.getCaller());
        }
    }

    private void logEnteringMessage(StackTraceElement caller) {
        if (caller != null) {
            this.debug("Entering ", caller.getClassName(), Character.valueOf('.'), caller.getMethodName(), Character.valueOf('('), caller.getFileName(), Character.valueOf(':'), caller.getLineNumber(), Character.valueOf(')'));
        }
    }

    public void debug(String msg, Throwable e) {
        this.log.debug(msg, e);
    }

    public void info(String msg, Throwable e) {
        this.log.info(msg, e);
    }

    public void warn(String msg, Throwable e) {
        this.log.warn(msg, e);
    }

    public void error(String msg, Throwable e) {
        this.log.error(msg, e);
    }

    public void fatalError(String msg, Throwable e) {
        this.log.fatalError(msg, e);
    }

    public void setPriority(Priority priority) {
        this.log.setPriority(priority);
    }

    public static void setStackTraceForTesting(StackTrace newStackTrace) {
        stackTrace = newStackTrace;
    }

    public void logStackTrace() {
        if (this.isDebugEnabled()) {
            this.debug(this.getStackTraceFromCaller());
        }
    }

    public String getStackTrace() {
        return this.getStackTraceFromCaller();
    }

    private String getStackTraceFromCaller() {
        StackTraceElement caller = stackTrace.getCaller();
        return this.getStackTraceStartingAt(caller);
    }

    private String getStackTraceStartingAt(StackTraceElement caller) {
        ArrayList<StackTraceElement> traceElements = new ArrayList<StackTraceElement>();
        boolean foundCaller = false;
        for (StackTraceElement currentElement : stackTrace.getStackTrace()) {
            if (!foundCaller && !(foundCaller = currentElement.equals(caller))) continue;
            traceElements.add(currentElement);
        }
        return this.toString(traceElements);
    }

    private String toString(List<StackTraceElement> stackTraceElements) {
        StringBuilder stackTrace = new StringBuilder().append("Current stack trace for thread [").append(Thread.currentThread().getName()).append("]:\n");
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            stackTrace.append("   ").append(stackTraceElement).append('\n');
        }
        return stackTrace.toString();
    }

    public String getClassName(Object object) {
        return object != null ? object.getClass().getSimpleName() : "";
    }
}

