/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.reportservice.ProcessManager;
import com.cognos.pogo.util.PogoLogger;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ProcessExecutionMode {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String DEFAULT_WORKING_DIR = "../bin";
    private final Map<String, String> initParamMap;
    private ICCLConfiguration cclConfiguration;

    public ProcessExecutionMode(Map<String, String> initParamMap, ICCLConfiguration cclConfiguration) {
        this.initParamMap = initParamMap;
        this.cclConfiguration = cclConfiguration;
    }

    public ProcessExecutionMode(Map<String, String> initParamsMap) {
        this(initParamsMap, ProcessExecutionMode.createCCLConfiguration());
    }

    private static ICCLConfiguration createCCLConfiguration() {
        return CCLConfigurationFactory.createConfiguration();
    }

    public String getProcessName() {
        String processName = this.getInitParameter("exe_name");
        if (StringUtils.isEmpty((String)processName)) {
            processName = this.getProcessNameBasedOnExecutionMode();
        }
        log.debug("Process name: ", processName);
        return processName;
    }

    public void prepareWorkingDir(ProcessManager aProcessManager) {
        String workingDir = this.getWorkingDir();
        String effectiveWorkingDir = this.cclConfiguration.resolveEffectivePath(workingDir);
        log.debug("Effective working dir: ", effectiveWorkingDir);
        aProcessManager.setWorkingDirectory(effectiveWorkingDir);
    }

    public void prepareEnvironment(ProcessManager aProcessManager) {
        String environmentReplacement = this.getEnvironmentReplacement();
        if (environmentReplacement != null) {
            aProcessManager.setEnvironmentReplacement(environmentReplacement);
        }
    }

    private String getExecutionMode() {
        String startupConfigParameter = this.getInitParameter("startup_config_parameter");
        String executionMode = this.getConfigValue(startupConfigParameter);
        if (StringUtils.isEmpty((String)executionMode)) {
            executionMode = this.getInitParameter("startup_config_default");
        }
        log.debug("Using ", startupConfigParameter, "=", executionMode);
        return executionMode;
    }

    private String getProcessNameBasedOnExecutionMode() {
        String executionMode = this.getExecutionMode();
        String path = this.getInitParameter(executionMode + "_path");
        String exe = this.getInitParameter(executionMode + "_exe");
        return path + exe;
    }

    private String getWorkingDir() {
        String workingDir = this.getInitParameter("working_dir");
        if (StringUtils.isEmpty((String)workingDir)) {
            workingDir = this.getWorkingDirBasedOnExecutionMode();
        }
        log.debug("Working dir: ", workingDir);
        return workingDir;
    }

    private String getWorkingDirBasedOnExecutionMode() {
        String executionMode = this.getExecutionMode();
        String workingDir = this.getInitParameter(executionMode + "_path");
        if (StringUtils.isEmpty((String)workingDir)) {
            workingDir = DEFAULT_WORKING_DIR;
        }
        return workingDir;
    }

    private String getEnvironmentReplacement() {
        String executionMode = this.getExecutionMode();
        return this.getInitParameter(executionMode + "_environment_replacement");
    }

    private String getInitParameter(String name) {
        String value = this.initParamMap.get(name);
        log.debug("Init Parameter: ", name, "=", value);
        return value;
    }

    private String getConfigValue(String configName) {
        try {
            return StringUtils.isNotEmpty((String)configName) ? this.cclConfiguration.getValue(configName, false) : null;
        }
        catch (Throwable e) {
            log.warn("Error reading CCL Config value: " + configName, e);
            return null;
        }
    }

    public void setCclConfiguration(ICCLConfiguration cclConfiguration) {
        this.cclConfiguration = cclConfiguration;
    }
}

