/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class Version {
    private static String versionStr;
    private static int version;
    private static String currentVersion;

    private static void loadVersion() {
        Properties props = new Properties();
        try {
            InputStream in = Class.forName("com.cognos.pogo.util.Version").getResourceAsStream("/com/cognos/pogo/Version.properties");
            props.load(in);
            in.close();
            versionStr = props.getProperty("Version");
        }
        catch (Exception e) {
            versionStr = Version.defaultVersion();
        }
        Version.parseVersion();
    }

    private static void parseVersion() {
        try {
            String major = versionStr;
            currentVersion = versionStr;
            int period1 = versionStr.indexOf(46);
            int period2 = versionStr.indexOf(46, period1 + 1);
            int period3 = versionStr.indexOf(46, period2 + 1);
            if (period3 != -1) {
                major = versionStr.substring(period2 + 1, period3);
                currentVersion = versionStr.substring(0, period3);
            }
            version = Integer.parseInt(major);
        }
        catch (NumberFormatException e) {
            version = 0;
        }
    }

    private static String defaultVersion() {
        return "0";
    }

    public static int getVersion() {
        if (versionStr == null) {
            Version.loadVersion();
        }
        return version;
    }

    public static String getVersionStr() {
        return versionStr;
    }

    public static void setVersionStr(String string) {
        versionStr = string;
        Version.parseVersion();
    }

    public static boolean isCurrent(String edition) {
        if (StringUtils.isEmpty((String)edition)) {
            return false;
        }
        if (!edition.matches("^[0-9].*")) {
            return true;
        }
        if (!currentVersion.matches("^[0-9].*")) {
            return true;
        }
        return edition.startsWith(currentVersion);
    }
}

