/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util.browser;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public enum UserAgentType {
    msie{

        @Override
        public String getEncodedFilename(String filename) {
            return "filename=" + this.getQuotedUtf8(filename);
        }
    }
    ,
    msie9,
    firefox{

        @Override
        protected String getUtf8String(String filename) {
            String encoded = UserAgentType.getUtf8Encoded(filename);
            return encoded.replace("+", "%20");
        }
    }
    ,
    safari{

        @Override
        public String getEncodedFilename(String filename) {
            return "filename=\"" + filename + "\"";
        }
    }
    ,
    chrome,
    opera,
    android,
    konqueror,
    other;

    private static final String MSIE = "MSIE";

    public static UserAgentType fromUserAgent(String userAgent) {
        if (userAgent == null) {
            return msie;
        }
        if (userAgent.contains("Opera")) {
            return opera;
        }
        if (userAgent.contains(MSIE)) {
            return UserAgentType.decodeMsieVersion(userAgent);
        }
        if (userAgent.matches(".*[Ff]irefox.*")) {
            return firefox;
        }
        if (userAgent.contains("Chrome")) {
            return chrome;
        }
        if (userAgent.contains("Safari") || userAgent.contains("AppleWebKit")) {
            if (userAgent.contains("Android")) {
                return android;
            }
            return safari;
        }
        if (userAgent.contains("Konqueror")) {
            return konqueror;
        }
        return other;
    }

    private static UserAgentType decodeMsieVersion(String userAgent) {
        int start = userAgent.indexOf(MSIE);
        int end = userAgent.indexOf(".", start);
        Integer version = Integer.valueOf(userAgent.substring(start + MSIE.length() + 1, end));
        if (version < 9) {
            return msie;
        }
        return msie9;
    }

    public String getEncodedFilename(String filename) {
        return "filename*=" + this.getRfc2231Encoding(filename);
    }

    protected String getRfc2231Encoding(String filename) {
        return "UTF-8''" + this.getUtf8String(filename);
    }

    protected String getQuotedUtf8(String filename) {
        return "\"" + this.getUtf8String(filename) + "\"";
    }

    protected String getUtf8String(String filename) {
        String encoded = UserAgentType.getUtf8Encoded(filename);
        return encoded.replace('+', ' ');
    }

    private static String getUtf8Encoded(String filename) {
        try {
            return URLEncoder.encode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return filename;
        }
    }
}

