/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util.capability;

import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.common.Envelope;
import com.cognos.pogo.pdk.common.UserCapabilityCache;
import com.cognos.pogo.pdk.common.UserCapabilityCacheException;
import com.cognos.pogo.util.CAMUtils;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.StringUtils;

public class UserCapabilitiesCacheDecodeHandler
extends BasicHandler {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String PARSER_ERROR_MESSAGE_CODE = "UserCapabilitiesCache.parseError";
    private final CAMUtils camUtils;

    public UserCapabilitiesCacheDecodeHandler() {
        this(new CAMUtils());
    }

    public UserCapabilitiesCacheDecodeHandler(CAMUtils camUtils) {
        super(log.getNativeLogger());
        this.camUtils = camUtils;
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        Envelope envelope = (Envelope)mc.getProperty("request.envelope");
        if (envelope != null) {
            this.tryToValidateCookie(mc, envelope);
        }
    }

    private void tryToValidateCookie(MessageContext mc, Envelope envelope) throws PogoException {
        try {
            if (!this.validateCookie(envelope)) {
                mc.setFault(new Fault(PARSER_ERROR_MESSAGE_CODE));
            }
        }
        catch (UserCapabilityCacheException e) {
            this.rethrowException(e);
        }
    }

    private boolean validateCookie(Envelope envelope) throws UserCapabilityCacheException {
        String cookie;
        UserCapabilityCache userCapabilityCache = envelope.getBiBusHeader().getUserCapabilityCache();
        if (userCapabilityCache.isEmpty() && StringUtils.isNotEmpty(cookie = envelope.getCookieValue("userCapabilities"))) {
            String passportID = envelope.getBiBusHeader().getCam().getCAMPassport().getId();
            return userCapabilityCache.validateCookie(cookie, passportID, this.camUtils);
        }
        return true;
    }

    private void rethrowException(UserCapabilityCacheException e) throws PogoException {
        log.warn("Error while validating the userCapabilities cookie", e);
        String parseErrorMessage = DispatcherStrings.getInstance().getString(PARSER_ERROR_MESSAGE_CODE);
        throw new PogoException(parseErrorMessage, e);
    }
}

