/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util.capability;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.pogo.util.DomUtils;
import com.cognos.pogo.util.PogoLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class UserCapabilityLoader {
    private static final String UNIT_TEST_PATH = "UNIT_TEST_PATH";
    private static PogoLogger logger = PogoLogger.getLogger();
    private static Element rootElementForTesting = null;
    private String path;
    private Element rootElement;

    public void loadFile() throws FileNotFoundException, DocumentException {
        this.rootElement = rootElementForTesting != null ? rootElementForTesting : this.getRootElementFromFile();
    }

    private Element getRootElementFromFile() throws FileNotFoundException, DocumentException {
        this.path = this.resolvePath("../configuration/CapabilityRules.xml");
        SAXReader reader = new SAXReader();
        logger.debug("reading capabilities from file ", this.path);
        Document document = reader.read((InputStream)new FileInputStream(this.path));
        return document.getRootElement();
    }

    public static void setRootElementForTesting(Document document) {
        rootElementForTesting = document.getRootElement();
    }

    private String resolvePath(String pathname) {
        if (this.inUnitTest()) {
            return this.testableResolvePath(pathname);
        }
        return CCLConfigurationFactory.getInstance().resolveEffectivePath(pathname);
    }

    private boolean inUnitTest() {
        return this.getUnitTestPath() != null;
    }

    private String testableResolvePath(String pathname) {
        logger.debug("Resolving path ", pathname, " from ", this.getUnitTestPath());
        try {
            return new File(this.getUnitTestPath(), pathname).getCanonicalPath();
        }
        catch (IOException e) {
            logger.debug("IOException resolving path");
            return pathname;
        }
    }

    private String getUnitTestPath() {
        return System.getProperty(UNIT_TEST_PATH);
    }

    Element getRootElementForTest() {
        return this.rootElement;
    }

    public String[] getCapabilities() {
        try {
            this.loadFile();
        }
        catch (Exception e) {
            logger.error("Unable to read capabilities from ", this.path);
            return null;
        }
        return this.getCapabilitiesFromFile();
    }

    private String[] getCapabilitiesFromFile() {
        TreeMap<Integer, String> capabilityMap = this.createCapabilityMapFromElements();
        String[] capabilities = this.convertMapToArray(capabilityMap);
        return capabilities;
    }

    private TreeMap<Integer, String> createCapabilityMapFromElements() {
        TreeMap<Integer, String> capabilityMap = new TreeMap<Integer, String>();
        List<Element> cookies = this.getCapabilityCookies();
        for (Element cookie : cookies) {
            this.addCapabilityToMap(capabilityMap, cookie);
        }
        return capabilityMap;
    }

    private List<Element> getCapabilityCookies() {
        return DomUtils.selectNodesFromElement(this.rootElement, "capabilityCookie");
    }

    private void addCapabilityToMap(TreeMap<Integer, String> capabilityMap, Element cookieElement) {
        String capability = cookieElement.element("capability").getTextTrim();
        String bitIndexStr = cookieElement.element("bitIndex").getTextTrim();
        Integer bitIndex = Integer.decode(bitIndexStr);
        capabilityMap.put(bitIndex, capability);
    }

    private String[] convertMapToArray(TreeMap<Integer, String> capabilityMap) {
        int lastKey = capabilityMap.lastKey();
        String[] capabilities = new String[lastKey + 1];
        for (Map.Entry<Integer, String> entry : capabilityMap.entrySet()) {
            capabilities[entry.getKey().intValue()] = this.stripNamespace(entry.getValue());
        }
        return capabilities;
    }

    private String stripNamespace(String value) {
        return value.substring(value.indexOf(":") + 1);
    }
}

