/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util.threads;

import com.cognos.pogo.pdk.performance.events.ThreadEvent;
import com.cognos.pogo.util.PogoLogger;
import java.util.TimerTask;

public abstract class SafeTimerTask
extends TimerTask {
    private static PogoLogger log = PogoLogger.getLogger();
    private String timerTaskName;

    public SafeTimerTask() {
    }

    public SafeTimerTask(String timerTaskName) {
        this.timerTaskName = timerTaskName;
    }

    protected SafeTimerTask(PogoLogger log) {
        SafeTimerTask.log = log;
    }

    @Override
    public final void run() {
        ThreadEvent perfEvent = new ThreadEvent(this.timerTaskName);
        try {
            this.safeRun();
        }
        catch (Exception e) {
            this.logWarning(e);
        }
        finally {
            perfEvent.completed();
            this.notifyRun();
        }
    }

    private void logWarning(Exception e) {
        log.warn("TimerTask Thread " + Thread.currentThread().getName() + " has died by throwing the following (uncaught) exception: ", e);
    }

    protected abstract void safeRun();

    protected void notifyRun() {
    }
}

