/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches;

public final class ByteArrayUtil {
    public static void putShort(byte[] bytes, int offset, short value) {
        for (int i = 0; i < 2; ++i) {
            bytes[offset + i] = (byte)(value >>> 8 * i & 0xFF);
        }
    }

    public static void putInt(byte[] bytes, int offset, int value) {
        for (int i = 0; i < 4; ++i) {
            bytes[offset + i] = (byte)(value >>> 8 * i & 0xFF);
        }
    }

    public static void putLong(byte[] bytes, int offset, long value) {
        for (int i = 0; i < 8; ++i) {
            bytes[offset + i] = (byte)(value >>> 8 * i & 0xFFL);
        }
    }

    public static void putFloat(byte[] bytes, int offset, float value) {
        ByteArrayUtil.putInt(bytes, offset, Float.floatToRawIntBits(value));
    }

    public static void putDouble(byte[] bytes, int offset, double value) {
        ByteArrayUtil.putLong(bytes, offset, Double.doubleToLongBits(value));
    }
}

