/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hll;

import com.yahoo.sketches.hll.AbstractHllArray;
import com.yahoo.sketches.hll.AuxHashMap;
import com.yahoo.sketches.hll.HeapAuxHashMap;
import com.yahoo.sketches.hll.Hll4Array;
import com.yahoo.sketches.hll.Hll6Array;
import com.yahoo.sketches.hll.Hll8Array;
import com.yahoo.sketches.hll.HllUtil;
import com.yahoo.sketches.hll.PairIterator;

class Conversions {
    Conversions() {
    }

    static final Hll4Array convertToHll4(AbstractHllArray srcHllArr) {
        int lgConfigK = srcHllArr.getLgConfigK();
        Hll4Array hll4Array = new Hll4Array(lgConfigK);
        hll4Array.putOutOfOrderFlag(srcHllArr.isOutOfOrderFlag());
        int pair = Conversions.curMinAndNum(srcHllArr);
        int curMin = HllUtil.getValue(pair);
        int numAtCurMin = HllUtil.getLow26(pair);
        PairIterator itr = srcHllArr.getIterator();
        AuxHashMap auxHashMap = hll4Array.getAuxHashMap();
        while (itr.nextValid()) {
            int slotNo = itr.getIndex();
            int actualValue = itr.getValue();
            AbstractHllArray.hipAndKxQIncrementalUpdate(hll4Array, 0, actualValue);
            if (actualValue >= curMin + 15) {
                hll4Array.putSlot(slotNo, 15);
                if (auxHashMap == null) {
                    auxHashMap = new HeapAuxHashMap(HllUtil.LG_AUX_ARR_INTS[lgConfigK], lgConfigK);
                    hll4Array.putAuxHashMap(auxHashMap, false);
                }
                auxHashMap.mustAdd(slotNo, actualValue);
                continue;
            }
            hll4Array.putSlot(slotNo, actualValue - curMin);
        }
        hll4Array.putCurMin(curMin);
        hll4Array.putNumAtCurMin(numAtCurMin);
        hll4Array.putHipAccum(srcHllArr.getHipAccum());
        return hll4Array;
    }

    static final int curMinAndNum(AbstractHllArray hllArr) {
        int curMin = 64;
        int numAtCurMin = 0;
        PairIterator itr = hllArr.getIterator();
        while (itr.nextAll()) {
            int v = itr.getValue();
            if (v < curMin) {
                curMin = v;
                numAtCurMin = 1;
                continue;
            }
            if (v != curMin) continue;
            ++numAtCurMin;
        }
        return HllUtil.pair(numAtCurMin, curMin);
    }

    static final Hll6Array convertToHll6(AbstractHllArray srcHllArr) {
        int lgConfigK = srcHllArr.lgConfigK;
        Hll6Array hll6Array = new Hll6Array(lgConfigK);
        hll6Array.putOutOfOrderFlag(srcHllArr.isOutOfOrderFlag());
        int numZeros = 1 << lgConfigK;
        PairIterator itr = srcHllArr.getIterator();
        while (itr.nextAll()) {
            if (itr.getValue() == 0) continue;
            --numZeros;
            hll6Array.couponUpdate(itr.getPair());
        }
        hll6Array.putNumAtCurMin(numZeros);
        hll6Array.putHipAccum(srcHllArr.getHipAccum());
        return hll6Array;
    }

    static final Hll8Array convertToHll8(AbstractHllArray srcHllArr) {
        int lgConfigK = srcHllArr.lgConfigK;
        Hll8Array hll8Array = new Hll8Array(lgConfigK);
        hll8Array.putOutOfOrderFlag(srcHllArr.isOutOfOrderFlag());
        int numZeros = 1 << lgConfigK;
        PairIterator itr = srcHllArr.getIterator();
        while (itr.nextAll()) {
            if (itr.getValue() == 0) continue;
            --numZeros;
            hll8Array.couponUpdate(itr.getPair());
        }
        hll8Array.putNumAtCurMin(numZeros);
        hll8Array.putHipAccum(srcHllArr.getHipAccum());
        return hll8Array;
    }
}

