/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hll;

import com.yahoo.memory.Memory;
import com.yahoo.sketches.hll.AuxHashMap;
import com.yahoo.sketches.hll.HeapAuxHashMap;
import com.yahoo.sketches.hll.Hll4Update;
import com.yahoo.sketches.hll.HllArray;
import com.yahoo.sketches.hll.HllPairIterator;
import com.yahoo.sketches.hll.HllSketchImpl;
import com.yahoo.sketches.hll.HllUtil;
import com.yahoo.sketches.hll.PairIterator;
import com.yahoo.sketches.hll.PreambleUtil;
import com.yahoo.sketches.hll.TgtHllType;
import com.yahoo.sketches.hll.ToByteArrayImpl;

class Hll4Array
extends HllArray {
    Hll4Array(int lgConfigK) {
        super(lgConfigK, TgtHllType.HLL_4);
        this.hllByteArr = new byte[Hll4Array.hll4ArrBytes(lgConfigK)];
    }

    Hll4Array(Hll4Array that) {
        super(that);
    }

    static final Hll4Array heapify(Memory mem) {
        int lgConfigK = PreambleUtil.extractLgK(mem);
        Hll4Array hll4Array = new Hll4Array(lgConfigK);
        HllArray.extractCommonHll(mem, hll4Array);
        int auxStart = hll4Array.auxStart;
        int auxCount = PreambleUtil.extractAuxCount(mem);
        boolean compact = PreambleUtil.extractCompactFlag(mem);
        HeapAuxHashMap auxHashMap = null;
        if (auxCount > 0) {
            auxHashMap = HeapAuxHashMap.heapify(mem, auxStart, lgConfigK, auxCount, compact);
        }
        hll4Array.putAuxHashMap(auxHashMap, false);
        return hll4Array;
    }

    @Override
    Hll4Array copy() {
        return new Hll4Array(this);
    }

    @Override
    HllSketchImpl couponUpdate(int coupon) {
        int newValue = HllUtil.getValue(coupon);
        if (newValue <= this.getCurMin()) {
            return this;
        }
        int configKmask = (1 << this.getLgConfigK()) - 1;
        int slotNo = HllUtil.getLow26(coupon) & configKmask;
        Hll4Update.internalHll4Update(this, slotNo, newValue);
        return this;
    }

    @Override
    PairIterator getIterator() {
        return new HeapHll4Iterator(1 << this.lgConfigK);
    }

    @Override
    int getSlot(int slotNo) {
        int theByte = this.hllByteArr[slotNo >>> 1];
        if ((slotNo & 1) > 0) {
            theByte >>>= 4;
        }
        return theByte & 0xF;
    }

    @Override
    int getUpdatableSerializationBytes() {
        AuxHashMap auxHashMap = this.getAuxHashMap();
        int auxBytes = auxHashMap == null ? 4 << HllUtil.LG_AUX_ARR_INTS[this.lgConfigK] : 4 << auxHashMap.getLgAuxArrInts();
        return PreambleUtil.HLL_BYTE_ARR_START + this.getHllByteArrBytes() + auxBytes;
    }

    @Override
    void putSlot(int slotNo, int newValue) {
        int byteno = slotNo >>> 1;
        byte oldValue = this.hllByteArr[byteno];
        this.hllByteArr[byteno] = (slotNo & 1) == 0 ? (byte)(oldValue & 0xF0 | newValue & 0xF) : (byte)(oldValue & 0xF | newValue << 4 & 0xF0);
    }

    @Override
    byte[] toCompactByteArray() {
        return ToByteArrayImpl.toHllByteArray(this, true);
    }

    final class HeapHll4Iterator
    extends HllPairIterator {
        HeapHll4Iterator(int lengthPairs) {
            super(lengthPairs);
        }

        @Override
        int value() {
            int nib = Hll4Array.this.getSlot(this.index);
            if (nib == 15) {
                AuxHashMap auxHashMap = Hll4Array.this.getAuxHashMap();
                return auxHashMap.mustFindValueFor(this.index);
            }
            return nib + Hll4Array.this.getCurMin();
        }
    }
}

