/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hll;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.hll.HllArray;
import com.yahoo.sketches.hll.HllPairIterator;
import com.yahoo.sketches.hll.PairIterator;
import com.yahoo.sketches.hll.PreambleUtil;
import com.yahoo.sketches.hll.TgtHllType;

class Hll6Array
extends HllArray {
    final WritableMemory mem;

    Hll6Array(int lgConfigK) {
        super(lgConfigK, TgtHllType.HLL_6);
        this.hllByteArr = new byte[Hll6Array.hll6ArrBytes(lgConfigK)];
        this.mem = WritableMemory.wrap((byte[])this.hllByteArr);
    }

    Hll6Array(Hll6Array that) {
        super(that);
        this.mem = WritableMemory.wrap((byte[])this.hllByteArr);
    }

    static final Hll6Array heapify(Memory mem) {
        int lgConfigK = PreambleUtil.extractLgK(mem);
        Hll6Array hll6Array = new Hll6Array(lgConfigK);
        HllArray.extractCommonHll(mem, hll6Array);
        return hll6Array;
    }

    @Override
    Hll6Array copy() {
        return new Hll6Array(this);
    }

    @Override
    PairIterator getIterator() {
        return new HeapHll6Iterator(1 << this.lgConfigK);
    }

    @Override
    final int getSlot(int slotNo) {
        return Hll6Array.get6Bit((Memory)this.mem, 0, slotNo);
    }

    @Override
    final void putSlot(int slotNo, int value) {
        Hll6Array.put6Bit(this.mem, 0, slotNo, value);
    }

    static final void put6Bit(WritableMemory wmem, int offsetBytes, int slotNo, int newValue) {
        int startBit = slotNo * 6;
        int shift = startBit & 7;
        int byteIdx = (startBit >>> 3) + offsetBytes;
        int valShifted = (newValue & 0x3F) << shift;
        int curMasked = wmem.getShort((long)byteIdx) & ~(63 << shift);
        short insert = (short)(curMasked | valShifted);
        wmem.putShort((long)byteIdx, insert);
    }

    static final int get6Bit(Memory mem, int offsetBytes, int slotNo) {
        int startBit = slotNo * 6;
        int shift = startBit & 7;
        int byteIdx = (startBit >>> 3) + offsetBytes;
        return (byte)(mem.getShort((long)byteIdx) >>> shift & 0x3F);
    }

    final class HeapHll6Iterator
    extends HllPairIterator {
        int bitOffset;

        HeapHll6Iterator(int lengthPairs) {
            super(lengthPairs);
            this.bitOffset = -6;
        }

        @Override
        int value() {
            this.bitOffset += 6;
            short tmp = Hll6Array.this.mem.getShort((long)(this.bitOffset / 8));
            int shift = this.bitOffset % 8 & 7;
            return tmp >>> shift & 0x3F;
        }
    }
}

