/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.Sketch;
import java.util.Arrays;

public abstract class CompactSketch
extends Sketch {
    @Override
    public Family getFamily() {
        return Family.COMPACT;
    }

    @Override
    public boolean isCompact() {
        return true;
    }

    static final long[] compactCache(long[] srcCache, int curCount, long thetaLong, boolean dstOrdered) {
        if (curCount == 0) {
            return new long[0];
        }
        long[] cacheOut = new long[curCount];
        int len = srcCache.length;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            long v = srcCache[i];
            if (v <= 0L || v >= thetaLong) continue;
            cacheOut[j++] = v;
        }
        assert (curCount == j);
        if (dstOrdered && curCount > 1) {
            Arrays.sort(cacheOut);
        }
        return cacheOut;
    }

    static final long[] compactCachePart(long[] srcCache, int lgArrLongs, int curCount, long thetaLong, boolean dstOrdered) {
        if (curCount == 0) {
            return new long[0];
        }
        long[] cacheOut = new long[curCount];
        int len = 1 << lgArrLongs;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            long v = srcCache[i];
            if (v <= 0L || v >= thetaLong) continue;
            cacheOut[j++] = v;
        }
        assert (curCount == j);
        if (dstOrdered) {
            Arrays.sort(cacheOut);
        }
        return cacheOut;
    }

    static final Memory loadCompactMemory(long[] compactCache, short seedHash, int curCount, long thetaLong, WritableMemory dstMem, byte flags, int preLongs) {
        int outLongs = preLongs + curCount;
        int outBytes = outLongs << 3;
        int dstBytes = (int)dstMem.getCapacity();
        if (outBytes > dstBytes) {
            throw new SketchesArgumentException("Insufficient Memory: " + dstBytes + ", Need: " + outBytes);
        }
        byte famID = (byte)Family.COMPACT.getID();
        PreambleUtil.insertPreLongs(dstMem, preLongs);
        PreambleUtil.insertSerVer(dstMem, 3);
        PreambleUtil.insertFamilyID(dstMem, famID);
        PreambleUtil.insertFlags(dstMem, flags);
        PreambleUtil.insertSeedHash(dstMem, seedHash);
        if (preLongs == 1 && curCount == 1) {
            dstMem.putLong(8L, compactCache[0]);
            return dstMem;
        }
        if (preLongs > 1) {
            PreambleUtil.insertCurCount(dstMem, curCount);
            PreambleUtil.insertP(dstMem, 1.0f);
        }
        if (preLongs > 2) {
            PreambleUtil.insertThetaLong(dstMem, thetaLong);
        }
        if (compactCache != null && curCount > 0) {
            dstMem.putLongArray((long)(preLongs << 3), compactCache, 0, curCount);
        }
        return dstMem;
    }
}

