/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.PreambleUtil;

abstract class DirectCompactSketch
extends CompactSketch {
    final Memory mem_;
    final Object memObj_;
    final long memAdd_;

    DirectCompactSketch(Memory mem) {
        this.mem_ = mem;
        this.memObj_ = ((WritableMemory)mem).getArray();
        this.memAdd_ = mem.getCumulativeOffset(0L);
    }

    @Override
    public int getCurrentBytes(boolean compact) {
        int preLongs = this.getCurrentPreambleLongs(true);
        boolean empty = PreambleUtil.isEmpty(this.mem_);
        if (preLongs == 1) {
            return empty ? 8 : 16;
        }
        int curCount = PreambleUtil.extractCurCount(this.mem_);
        return preLongs + curCount << 3;
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        int preLongs = this.getCurrentPreambleLongs(true);
        boolean empty = PreambleUtil.isEmpty(this.mem_);
        if (preLongs == 1) {
            return empty ? 0 : 1;
        }
        int curCount = PreambleUtil.extractCurCount(this.mem_);
        return curCount;
    }

    @Override
    public boolean hasMemory() {
        return true;
    }

    @Override
    public boolean isDirect() {
        return this.mem_.isDirect();
    }

    @Override
    public boolean isEmpty() {
        return PreambleUtil.isEmpty(this.mem_);
    }

    @Override
    public boolean isSameResource(Memory that) {
        return this.mem_.isSameResource((Object)that);
    }

    @Override
    public byte[] toByteArray() {
        return DirectCompactSketch.compactMemoryToByteArray(this.mem_, this.getCurrentPreambleLongs(true), this.getRetainedEntries(true));
    }

    @Override
    long[] getCache() {
        int curCount = this.getRetainedEntries(true);
        if (curCount > 0) {
            long[] cache = new long[curCount];
            int preLongs = this.getCurrentPreambleLongs(true);
            this.mem_.getLongArray((long)(preLongs << 3), cache, 0, curCount);
            return cache;
        }
        return new long[0];
    }

    @Override
    int getCurrentPreambleLongs(boolean compact) {
        return PreambleUtil.extractPreLongs(this.mem_);
    }

    @Override
    Memory getMemory() {
        return this.mem_;
    }

    @Override
    short getSeedHash() {
        return (short)PreambleUtil.extractSeedHash(this.mem_);
    }

    @Override
    long getThetaLong() {
        int preLongs = PreambleUtil.extractPreLongs(this.mem_);
        return preLongs > 2 ? PreambleUtil.extractThetaLong(this.mem_) : Long.MAX_VALUE;
    }

    static byte[] compactMemoryToByteArray(Memory srcMem, int preLongs, int curCount) {
        int outBytes = curCount + preLongs << 3;
        byte[] byteArrOut = new byte[outBytes];
        srcMem.getByteArray(0L, byteArrOut, 0, outBytes);
        return byteArrOut;
    }
}

