/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.HashOperations;
import com.yahoo.sketches.ResizeFactor;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.theta.HeapUpdateSketch;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.UpdateReturnState;
import com.yahoo.sketches.theta.UpdateSketch;
import java.util.Arrays;

final class HeapAlphaSketch
extends HeapUpdateSketch {
    private static final int ALPHA_MIN_LG_NOM_LONGS = 9;
    private final double alpha_;
    private final long split1_;
    private int lgArrLongs_;
    private int hashTableThreshold_;
    private int curCount_ = 0;
    private long thetaLong_;
    private boolean empty_ = true;
    private long[] cache_;
    private boolean dirty_ = false;

    private HeapAlphaSketch(int lgNomLongs, long seed, float p, ResizeFactor rf, double alpha, long split1) {
        super(lgNomLongs, seed, p, rf);
        this.alpha_ = alpha;
        this.split1_ = split1;
    }

    static HeapAlphaSketch newHeapInstance(int lgNomLongs, long seed, float p, ResizeFactor rf) {
        int lgArrLongs;
        if (lgNomLongs < 9) {
            throw new SketchesArgumentException("This sketch requires a minimum nominal entries of 512");
        }
        double nomLongs = 1L << lgNomLongs;
        double alpha = nomLongs / (nomLongs + 1.0);
        long split1 = (long)((double)p * (alpha + 1.0) / 2.0 * 9.223372036854776E18);
        HeapAlphaSketch has = new HeapAlphaSketch(lgNomLongs, seed, p, rf, alpha, split1);
        has.lgArrLongs_ = lgArrLongs = Util.startingSubMultiple(lgNomLongs + 1, rf, 5);
        has.hashTableThreshold_ = HeapAlphaSketch.setHashTableThreshold(lgNomLongs, lgArrLongs);
        has.curCount_ = 0;
        has.thetaLong_ = (long)((double)p * 9.223372036854776E18);
        has.empty_ = true;
        has.cache_ = new long[1 << lgArrLongs];
        return has;
    }

    static HeapAlphaSketch heapifyInstance(Memory srcMem, long seed) {
        int preambleLongs = PreambleUtil.extractPreLongs(srcMem);
        int lgNomLongs = PreambleUtil.extractLgNomLongs(srcMem);
        int lgArrLongs = PreambleUtil.extractLgArrLongs(srcMem);
        HeapAlphaSketch.checkAlphaFamily(srcMem, preambleLongs, lgNomLongs);
        HeapAlphaSketch.checkMemIntegrity(srcMem, seed, preambleLongs, lgNomLongs, lgArrLongs);
        float p = PreambleUtil.extractP(srcMem);
        int lgRF = PreambleUtil.extractLgResizeFactor(srcMem);
        ResizeFactor myRF = ResizeFactor.getRF(lgRF);
        double nomLongs = 1L << lgNomLongs;
        double alpha = nomLongs / (nomLongs + 1.0);
        long split1 = (long)((double)p * (alpha + 1.0) / 2.0 * 9.223372036854776E18);
        if (myRF == ResizeFactor.X1 && lgArrLongs != Util.startingSubMultiple(lgNomLongs + 1, myRF, 5)) {
            throw new SketchesArgumentException("Possible corruption: ResizeFactor X1, but provided array too small for sketch size");
        }
        HeapAlphaSketch has = new HeapAlphaSketch(lgNomLongs, seed, p, myRF, alpha, split1);
        has.lgArrLongs_ = lgArrLongs;
        has.hashTableThreshold_ = HeapAlphaSketch.setHashTableThreshold(lgNomLongs, lgArrLongs);
        has.curCount_ = PreambleUtil.extractCurCount(srcMem);
        has.thetaLong_ = PreambleUtil.extractThetaLong(srcMem);
        has.empty_ = PreambleUtil.isEmpty(srcMem);
        has.cache_ = new long[1 << lgArrLongs];
        srcMem.getLongArray((long)(preambleLongs << 3), has.cache_, 0, 1 << lgArrLongs);
        return has;
    }

    @Override
    public double getEstimate() {
        if (this.isEstimationMode()) {
            int curCount = this.getRetainedEntries(true);
            double theta = this.getTheta();
            return this.thetaLong_ > this.split1_ ? (double)curCount / theta : (double)(1 << this.lgNomLongs_) / theta;
        }
        return this.curCount_;
    }

    @Override
    public double getLowerBound(int numStdDev) {
        double lb;
        if (numStdDev < 1 || numStdDev > 3) {
            throw new SketchesArgumentException("numStdDev can only be the values 1, 2 or 3.");
        }
        if (this.isEstimationMode()) {
            int validCount = this.getRetainedEntries(true);
            if (validCount > 0) {
                double est = this.getEstimate();
                double var = HeapAlphaSketch.getVariance(1 << this.lgNomLongs_, this.getP(), this.alpha_, this.getTheta(), validCount);
                lb = est - (double)numStdDev * Math.sqrt(var);
                lb = Math.max(lb, 0.0);
            } else {
                lb = 0.0;
            }
        } else {
            lb = this.curCount_;
        }
        return lb;
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        if (this.curCount_ > 0 && valid && this.isDirty()) {
            int curCount = HashOperations.countPart(this.getCache(), this.getLgArrLongs(), this.getThetaLong());
            return curCount;
        }
        return this.curCount_;
    }

    @Override
    public double getUpperBound(int numStdDev) {
        if (numStdDev < 1 || numStdDev > 3) {
            throw new SketchesArgumentException("numStdDev can only be the values 1, 2 or 3.");
        }
        if (this.isEstimationMode()) {
            double var = HeapAlphaSketch.getVariance(1 << this.lgNomLongs_, this.getP(), this.alpha_, this.getTheta(), this.getRetainedEntries(true));
            return this.getEstimate() + (double)numStdDev * Math.sqrt(var);
        }
        return this.curCount_;
    }

    @Override
    public boolean isEmpty() {
        return this.empty_;
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(Family.ALPHA.getMinPreLongs(), (byte)Family.ALPHA.getID());
    }

    @Override
    public Family getFamily() {
        return Family.ALPHA;
    }

    @Override
    public UpdateSketch rebuild() {
        if (this.isDirty()) {
            this.rebuildDirty();
        }
        return this;
    }

    @Override
    public final void reset() {
        int lgArrLongs = Util.startingSubMultiple(this.lgNomLongs_ + 1, this.getResizeFactor(), 5);
        if (lgArrLongs == this.lgArrLongs_) {
            int arrLongs = this.cache_.length;
            assert (1 << this.lgArrLongs_ == arrLongs);
            Arrays.fill(this.cache_, 0L);
        } else {
            this.cache_ = new long[1 << lgArrLongs];
            this.lgArrLongs_ = lgArrLongs;
        }
        this.hashTableThreshold_ = HeapAlphaSketch.setHashTableThreshold(this.lgNomLongs_, this.lgArrLongs_);
        this.empty_ = true;
        this.curCount_ = 0;
        this.thetaLong_ = (long)((double)this.getP() * 9.223372036854776E18);
        this.dirty_ = false;
    }

    @Override
    int getCurrentPreambleLongs(boolean compact) {
        if (!compact) {
            return Family.ALPHA.getMinPreLongs();
        }
        return HeapAlphaSketch.computeCompactPreLongs(this.thetaLong_, this.empty_, this.curCount_);
    }

    WritableMemory getMemory() {
        return null;
    }

    @Override
    long[] getCache() {
        return this.cache_;
    }

    @Override
    long getThetaLong() {
        return this.thetaLong_;
    }

    @Override
    boolean isDirty() {
        return this.dirty_;
    }

    @Override
    boolean isOutOfSpace(int numEntries) {
        return numEntries > this.hashTableThreshold_;
    }

    @Override
    int getLgArrLongs() {
        return this.lgArrLongs_;
    }

    @Override
    UpdateReturnState hashUpdate(long hash) {
        boolean r;
        HashOperations.checkHashCorruption(hash);
        this.empty_ = false;
        if (HashOperations.continueCondition(this.thetaLong_, hash)) {
            return UpdateReturnState.RejectedOverTheta;
        }
        if (this.dirty_) {
            return this.enhancedHashInsert(this.cache_, hash);
        }
        if (HashOperations.hashSearchOrInsert(this.cache_, this.lgArrLongs_, hash) >= 0) {
            return UpdateReturnState.RejectedDuplicate;
        }
        ++this.curCount_;
        boolean bl = r = this.thetaLong_ <= this.split1_;
        if (!r) {
            if (this.curCount_ > 1 << this.lgNomLongs_) {
                this.thetaLong_ = (long)((double)this.thetaLong_ * this.alpha_);
                this.dirty_ = true;
            } else if (this.isOutOfSpace(this.curCount_)) {
                this.resizeClean();
            }
        } else {
            assert (this.lgArrLongs_ > this.lgNomLongs_) : "lgArr: " + this.lgArrLongs_ + ", lgNom: " + this.lgNomLongs_;
            this.thetaLong_ = (long)((double)this.thetaLong_ * this.alpha_);
            this.dirty_ = true;
            if (this.isOutOfSpace(this.curCount_)) {
                this.rebuildDirty();
            }
        }
        return UpdateReturnState.InsertedCountIncremented;
    }

    final UpdateReturnState enhancedHashInsert(long[] hashTable, long hash) {
        int arrayMask = (1 << this.lgArrLongs_) - 1;
        int stride = 2 * (int)(hash >>> this.lgArrLongs_ & 0x7FL) + 1;
        int curProbe = (int)(hash & (long)arrayMask);
        long curTableHash = hashTable[curProbe];
        int loopIndex = curProbe;
        while (curTableHash != hash && curTableHash != 0L) {
            if (curTableHash >= this.thetaLong_) {
                int rememberPos = curProbe;
                curProbe = curProbe + stride & arrayMask;
                curTableHash = hashTable[curProbe];
                while (curTableHash != hash && curTableHash != 0L) {
                    curProbe = curProbe + stride & arrayMask;
                    curTableHash = hashTable[curProbe];
                }
                if (curTableHash == hash) {
                    return UpdateReturnState.RejectedDuplicate;
                }
                assert (curTableHash == 0L);
                hashTable[rememberPos] = hash;
                this.thetaLong_ = (long)((double)this.thetaLong_ * this.alpha_);
                this.dirty_ = true;
                return UpdateReturnState.InsertedCountNotIncremented;
            }
            assert (curTableHash < this.thetaLong_);
            curProbe = curProbe + stride & arrayMask;
            curTableHash = hashTable[curProbe];
            if (curProbe != loopIndex) continue;
            throw new SketchesArgumentException("No empty slot in table!");
        }
        if (curTableHash == hash) {
            return UpdateReturnState.RejectedDuplicate;
        }
        assert (curTableHash == 0L);
        hashTable[curProbe] = hash;
        this.thetaLong_ = (long)((double)this.thetaLong_ * this.alpha_);
        this.dirty_ = true;
        if (++this.curCount_ > this.hashTableThreshold_) {
            this.rebuildDirty();
        }
        return UpdateReturnState.InsertedCountIncremented;
    }

    private final void rebuildDirty() {
        int curCountBefore = this.curCount_;
        this.forceRebuildDirtyCache();
        if (curCountBefore == this.curCount_) {
            this.forceResizeCleanCache(1);
        }
    }

    private final void resizeClean() {
        int lgTgtLongs = this.lgNomLongs_ + 1;
        if (lgTgtLongs > this.lgArrLongs_) {
            ResizeFactor rf = this.getResizeFactor();
            int lgDeltaLongs = lgTgtLongs - this.lgArrLongs_;
            int lgResizeFactor = Math.max(Math.min(rf.lg(), lgDeltaLongs), 1);
            this.forceResizeCleanCache(lgResizeFactor);
        } else {
            this.forceResizeCleanCache(1);
        }
    }

    private final void forceResizeCleanCache(int lgResizeFactor) {
        assert (!this.dirty_);
        this.lgArrLongs_ += lgResizeFactor;
        long[] tgtArr = new long[1 << this.lgArrLongs_];
        int newCount = HashOperations.hashArrayInsert(this.cache_, tgtArr, this.lgArrLongs_, this.thetaLong_);
        assert (this.curCount_ == newCount);
        this.curCount_ = newCount;
        this.cache_ = tgtArr;
        this.hashTableThreshold_ = HeapAlphaSketch.setHashTableThreshold(this.lgNomLongs_, this.lgArrLongs_);
    }

    private final void forceRebuildDirtyCache() {
        long[] tgtArr = new long[1 << this.lgArrLongs_];
        this.curCount_ = HashOperations.hashArrayInsert(this.cache_, tgtArr, this.lgArrLongs_, this.thetaLong_);
        this.cache_ = tgtArr;
        this.dirty_ = false;
    }

    private static final double getVariance(double k, double p, double alpha, double theta, int count) {
        double result;
        double kPlus1 = k + 1.0;
        double y = 1.0 / p;
        double ySq = y * y;
        double ySqMinusY = ySq - y;
        int r = HeapAlphaSketch.getR(theta, alpha, p);
        if (r == 0) {
            result = (double)count * ySqMinusY;
        } else if (r == 1) {
            result = kPlus1 * ySqMinusY;
        } else {
            double b = 1.0 / alpha;
            double bSq = b * b;
            double x = p / theta;
            double xSq = x * x;
            double term1 = kPlus1 * ySqMinusY;
            double term2 = y / (1.0 - bSq);
            double term3 = y * bSq - y * xSq - b - bSq + x + x * b;
            result = term1 + term2 * term3;
        }
        double term4 = (1.0 - theta) / (theta * theta);
        return result + term4;
    }

    private static final int getR(double theta, double alpha, double p) {
        double split1 = p * (alpha + 1.0) / 2.0;
        if (theta > split1) {
            return 0;
        }
        if (theta > alpha * split1) {
            return 1;
        }
        return 2;
    }

    private static final int setHashTableThreshold(int lgNomLongs, int lgArrLongs) {
        double fraction = lgArrLongs <= lgNomLongs ? 0.5 : 0.9375;
        return (int)Math.floor(fraction * (double)(1 << lgArrLongs));
    }

    static void checkAlphaFamily(Memory mem, int preambleLongs, int lgNomLongs) {
        int familyID = PreambleUtil.extractFamilyID(mem);
        Family family = Family.idToFamily(familyID);
        if (family.equals((Object)Family.ALPHA)) {
            if (preambleLongs != Family.ALPHA.getMinPreLongs()) {
                throw new SketchesArgumentException("Possible corruption: Invalid PreambleLongs value for ALPHA: " + preambleLongs);
            }
        } else {
            throw new SketchesArgumentException("Possible corruption: Invalid Family: " + family.toString());
        }
        if (lgNomLongs < 9) {
            throw new SketchesArgumentException("Possible corruption: This sketch requires a minimum nominal entries of 512");
        }
    }
}

