/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.HashOperations;
import com.yahoo.sketches.QuickSelect;
import com.yahoo.sketches.ResizeFactor;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.theta.HeapUpdateSketch;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.UpdateReturnState;
import com.yahoo.sketches.theta.UpdateSketch;
import java.util.Arrays;

class HeapQuickSelectSketch
extends HeapUpdateSketch {
    private final Family MY_FAMILY;
    private final int preambleLongs_;
    private int lgArrLongs_;
    private int hashTableThreshold_;
    int curCount_;
    long thetaLong_;
    boolean empty_;
    private long[] cache_;

    private HeapQuickSelectSketch(int lgNomLongs, long seed, float p, ResizeFactor rf, int preambleLongs, Family family) {
        super(lgNomLongs, seed, p, rf);
        this.preambleLongs_ = preambleLongs;
        this.MY_FAMILY = family;
    }

    HeapQuickSelectSketch(int lgNomLongs, long seed, float p, ResizeFactor rf, boolean unionGadget) {
        super(lgNomLongs, seed, p, rf);
        if (unionGadget) {
            this.preambleLongs_ = Family.UNION.getMinPreLongs();
            this.MY_FAMILY = Family.UNION;
        } else {
            this.preambleLongs_ = Family.QUICKSELECT.getMinPreLongs();
            this.MY_FAMILY = Family.QUICKSELECT;
        }
        this.lgArrLongs_ = Util.startingSubMultiple(lgNomLongs + 1, rf, 5);
        this.hashTableThreshold_ = HeapQuickSelectSketch.setHashTableThreshold(lgNomLongs, this.lgArrLongs_);
        this.curCount_ = 0;
        this.thetaLong_ = (long)((double)p * 9.223372036854776E18);
        this.empty_ = true;
        this.cache_ = new long[1 << this.lgArrLongs_];
    }

    static HeapQuickSelectSketch heapifyInstance(Memory srcMem, long seed) {
        int preambleLongs = PreambleUtil.extractPreLongs(srcMem);
        int lgNomLongs = PreambleUtil.extractLgNomLongs(srcMem);
        int lgArrLongs = PreambleUtil.extractLgArrLongs(srcMem);
        HeapQuickSelectSketch.checkUnionQuickSelectFamily(srcMem, preambleLongs, lgNomLongs);
        HeapQuickSelectSketch.checkMemIntegrity(srcMem, seed, preambleLongs, lgNomLongs, lgArrLongs);
        float p = PreambleUtil.extractP(srcMem);
        int lgRF = PreambleUtil.extractLgResizeFactor(srcMem);
        ResizeFactor myRF = ResizeFactor.getRF(lgRF);
        int familyID = PreambleUtil.extractFamilyID(srcMem);
        Family family = Family.idToFamily(familyID);
        if (myRF == ResizeFactor.X1 && lgArrLongs != Util.startingSubMultiple(lgNomLongs + 1, myRF, 5)) {
            myRF = ResizeFactor.X2;
        }
        HeapQuickSelectSketch hqss = new HeapQuickSelectSketch(lgNomLongs, seed, p, myRF, preambleLongs, family);
        hqss.lgArrLongs_ = lgArrLongs;
        hqss.hashTableThreshold_ = HeapQuickSelectSketch.setHashTableThreshold(lgNomLongs, lgArrLongs);
        hqss.curCount_ = PreambleUtil.extractCurCount(srcMem);
        hqss.thetaLong_ = PreambleUtil.extractThetaLong(srcMem);
        hqss.empty_ = PreambleUtil.isEmpty(srcMem);
        hqss.cache_ = new long[1 << lgArrLongs];
        srcMem.getLongArray((long)(preambleLongs << 3), hqss.cache_, 0, 1 << lgArrLongs);
        return hqss;
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return this.curCount_;
    }

    @Override
    public boolean isEmpty() {
        return this.empty_;
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(this.preambleLongs_, (byte)this.MY_FAMILY.getID());
    }

    @Override
    public Family getFamily() {
        return this.MY_FAMILY;
    }

    @Override
    public UpdateSketch rebuild() {
        if (this.getRetainedEntries(true) > 1 << this.getLgNomLongs()) {
            this.quickSelectAndRebuild();
        }
        return this;
    }

    @Override
    public void reset() {
        ResizeFactor rf = this.getResizeFactor();
        int lgArrLongsSM = Util.startingSubMultiple(this.lgNomLongs_ + 1, rf, 5);
        if (lgArrLongsSM == this.lgArrLongs_) {
            int arrLongs = this.cache_.length;
            assert (1 << this.lgArrLongs_ == arrLongs);
            Arrays.fill(this.cache_, 0L);
        } else {
            this.cache_ = new long[1 << lgArrLongsSM];
            this.lgArrLongs_ = lgArrLongsSM;
        }
        this.hashTableThreshold_ = HeapQuickSelectSketch.setHashTableThreshold(this.lgNomLongs_, this.lgArrLongs_);
        this.empty_ = true;
        this.curCount_ = 0;
        this.thetaLong_ = (long)((double)this.getP() * 9.223372036854776E18);
    }

    @Override
    int getCurrentPreambleLongs(boolean compact) {
        if (!compact) {
            return this.preambleLongs_;
        }
        return HeapQuickSelectSketch.computeCompactPreLongs(this.thetaLong_, this.empty_, this.curCount_);
    }

    WritableMemory getMemory() {
        return null;
    }

    @Override
    long[] getCache() {
        return this.cache_;
    }

    @Override
    long getThetaLong() {
        return this.thetaLong_;
    }

    @Override
    boolean isDirty() {
        return false;
    }

    @Override
    boolean isOutOfSpace(int numEntries) {
        return numEntries > this.hashTableThreshold_;
    }

    @Override
    int getLgArrLongs() {
        return this.lgArrLongs_;
    }

    @Override
    UpdateReturnState hashUpdate(long hash) {
        HashOperations.checkHashCorruption(hash);
        this.empty_ = false;
        if (HashOperations.continueCondition(this.thetaLong_, hash)) {
            return UpdateReturnState.RejectedOverTheta;
        }
        if (HashOperations.hashSearchOrInsert(this.cache_, this.lgArrLongs_, hash) >= 0) {
            return UpdateReturnState.RejectedDuplicate;
        }
        ++this.curCount_;
        if (this.isOutOfSpace(this.curCount_)) {
            if (this.lgArrLongs_ <= this.lgNomLongs_) {
                this.resizeCache();
            } else {
                assert (this.lgArrLongs_ == this.lgNomLongs_ + 1) : "lgArr: " + this.lgArrLongs_ + ", lgNom: " + this.lgNomLongs_;
                this.quickSelectAndRebuild();
            }
        }
        return UpdateReturnState.InsertedCountIncremented;
    }

    private final void resizeCache() {
        ResizeFactor rf = this.getResizeFactor();
        int lgTgtLongs = this.lgNomLongs_ + 1;
        int lgDeltaLongs = lgTgtLongs - this.lgArrLongs_;
        int lgResizeFactor = Math.max(Math.min(rf.lg(), lgDeltaLongs), 1);
        this.lgArrLongs_ += lgResizeFactor;
        long[] tgtArr = new long[1 << this.lgArrLongs_];
        int newCount = HashOperations.hashArrayInsert(this.cache_, tgtArr, this.lgArrLongs_, this.thetaLong_);
        assert (newCount == this.curCount_);
        this.curCount_ = newCount;
        this.cache_ = tgtArr;
        this.hashTableThreshold_ = HeapQuickSelectSketch.setHashTableThreshold(this.lgNomLongs_, this.lgArrLongs_);
    }

    private final void quickSelectAndRebuild() {
        int arrLongs = 1 << this.lgArrLongs_;
        int pivot = (1 << this.lgNomLongs_) + 1;
        this.thetaLong_ = QuickSelect.selectExcludingZeros(this.cache_, this.curCount_, pivot);
        long[] tgtArr = new long[arrLongs];
        this.curCount_ = HashOperations.hashArrayInsert(this.cache_, tgtArr, this.lgArrLongs_, this.thetaLong_);
        this.cache_ = tgtArr;
    }

    static final int setHashTableThreshold(int lgNomLongs, int lgArrLongs) {
        double fraction = lgArrLongs <= lgNomLongs ? 0.5 : 0.9375;
        return (int)Math.floor(fraction * (double)(1 << lgArrLongs));
    }
}

