/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.HashOperations;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.theta.IntersectionImplR;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.Sketch;
import java.util.Arrays;

final class IntersectionImpl
extends IntersectionImplR {
    private IntersectionImpl(WritableMemory wmem, long seed, boolean newMem) {
        super(wmem, seed, newMem);
    }

    static IntersectionImpl initNewHeapInstance(long seed) {
        IntersectionImpl impl = new IntersectionImpl(null, seed, false);
        impl.lgArrLongs_ = 0;
        impl.curCount_ = -1;
        impl.thetaLong_ = Long.MAX_VALUE;
        impl.empty_ = false;
        impl.hashTable_ = null;
        return impl;
    }

    static IntersectionImpl initNewDirectInstance(long seed, WritableMemory dstMem) {
        IntersectionImpl impl = new IntersectionImpl(dstMem, seed, true);
        PreambleUtil.insertPreLongs(dstMem, 3);
        PreambleUtil.insertSerVer(dstMem, 3);
        PreambleUtil.insertFamilyID(dstMem, Family.INTERSECTION.getID());
        PreambleUtil.insertLgArrLongs(dstMem, 5);
        PreambleUtil.insertFlags(dstMem, 0);
        PreambleUtil.insertCurCount(dstMem, -1);
        PreambleUtil.insertP(dstMem, 1.0f);
        PreambleUtil.insertThetaLong(dstMem, Long.MAX_VALUE);
        impl.lgArrLongs_ = 5;
        impl.curCount_ = -1;
        impl.thetaLong_ = Long.MAX_VALUE;
        impl.empty_ = false;
        impl.maxLgArrLongs_ = IntersectionImpl.checkMaxLgArrLongs((Memory)dstMem);
        return impl;
    }

    static IntersectionImplR heapifyInstance(Memory srcMem, long seed) {
        boolean empty;
        IntersectionImpl impl = new IntersectionImpl(null, seed, false);
        int preLongsMem = srcMem.getByte(0L) & 0x3F;
        int serVer = srcMem.getByte(1L) & 0xFF;
        int famID = srcMem.getByte(2L) & 0xFF;
        int lgArrLongs = srcMem.getByte(4L) & 0xFF;
        int flags = srcMem.getByte(5L) & 0xFF;
        int curCount = srcMem.getInt(8L);
        long thetaLong = srcMem.getLong(16L);
        boolean bl = empty = (flags & 4) > 0;
        if (preLongsMem != 3) {
            throw new SketchesArgumentException("Memory PreambleLongs must equal 3: " + preLongsMem);
        }
        if (serVer != 3) {
            throw new SketchesArgumentException("Serialization Version must equal 3");
        }
        Family.INTERSECTION.checkFamilyID(famID);
        if (empty && curCount != 0) {
            throw new SketchesArgumentException("srcMem empty state inconsistent with curCount: " + empty + "," + curCount);
        }
        impl.lgArrLongs_ = lgArrLongs;
        impl.curCount_ = curCount;
        impl.thetaLong_ = thetaLong;
        impl.empty_ = empty;
        if (!empty && curCount > 0) {
            impl.hashTable_ = new long[1 << lgArrLongs];
            srcMem.getLongArray(24L, impl.hashTable_, 0, 1 << lgArrLongs);
        }
        return impl;
    }

    static IntersectionImpl wrapInstance(WritableMemory srcMem, long seed) {
        IntersectionImpl impl = new IntersectionImpl(srcMem, seed, false);
        return (IntersectionImpl)IntersectionImpl.internalWrapInstance((Memory)srcMem, impl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void update(Sketch sketchIn) {
        boolean firstCall;
        boolean bl = firstCall = this.curCount_ < 0;
        if (sketchIn == null) {
            this.empty_ = true;
            this.thetaLong_ = firstCall ? Long.MAX_VALUE : this.thetaLong_;
            this.curCount_ = 0;
            if (this.mem_ == null) return;
            PreambleUtil.setEmpty(this.mem_);
            PreambleUtil.insertThetaLong(this.mem_, this.thetaLong_);
            PreambleUtil.insertCurCount(this.mem_, 0);
            return;
        }
        Util.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
        this.thetaLong_ = Math.min(this.thetaLong_, sketchIn.getThetaLong());
        boolean bl2 = this.empty_ = this.empty_ || sketchIn.isEmpty();
        if (this.mem_ != null) {
            PreambleUtil.insertThetaLong(this.mem_, this.thetaLong_);
            if (this.empty_) {
                PreambleUtil.setEmpty(this.mem_);
            } else {
                PreambleUtil.clearEmpty(this.mem_);
            }
        }
        int sketchInEntries = sketchIn.getRetainedEntries(true);
        if (this.curCount_ == 0 || sketchInEntries == 0) {
            this.curCount_ = 0;
            if (this.mem_ != null) {
                PreambleUtil.insertCurCount(this.mem_, 0);
            }
            this.hashTable_ = null;
            return;
        } else if (firstCall) {
            this.curCount_ = sketchIn.getRetainedEntries(true);
            int requiredLgArrLongs = IntersectionImpl.computeMinLgArrLongsFromCount(this.curCount_);
            int priorLgArrLongs = this.lgArrLongs_;
            this.lgArrLongs_ = requiredLgArrLongs;
            if (this.mem_ != null) {
                PreambleUtil.insertCurCount(this.mem_, this.curCount_);
                PreambleUtil.insertLgArrLongs(this.mem_, this.lgArrLongs_);
                if (requiredLgArrLongs > this.maxLgArrLongs_) throw new SketchesArgumentException("Insufficient dstMem hash table space: " + (1 << requiredLgArrLongs) + " > " + (1 << priorLgArrLongs));
                this.mem_.clear(24L, (long)(8 << this.lgArrLongs_));
            } else {
                this.hashTable_ = new long[1 << this.lgArrLongs_];
            }
            this.moveDataToTgt(sketchIn.getCache(), this.curCount_);
            return;
        } else {
            this.performIntersect(sketchIn);
        }
    }

    void performIntersect(Sketch sketchIn) {
        long[] hashTable;
        assert (this.curCount_ > 0 && !this.empty_);
        long[] cacheIn = sketchIn.getCache();
        int arrLongsIn = cacheIn.length;
        if (this.mem_ != null) {
            int htLen = 1 << this.lgArrLongs_;
            hashTable = new long[htLen];
            this.mem_.getLongArray(24L, hashTable, 0, htLen);
        } else {
            hashTable = this.hashTable_;
        }
        long[] matchSet = new long[Math.min(this.curCount_, sketchIn.getRetainedEntries(true))];
        int matchSetCount = 0;
        if (sketchIn.isOrdered()) {
            long hashIn;
            for (int i = 0; i < arrLongsIn && (hashIn = cacheIn[i]) < this.thetaLong_; ++i) {
                int foundIdx = HashOperations.hashSearch(hashTable, this.lgArrLongs_, hashIn);
                if (foundIdx == -1) continue;
                matchSet[matchSetCount++] = hashIn;
            }
        } else {
            for (int i = 0; i < arrLongsIn; ++i) {
                int foundIdx;
                long hashIn = cacheIn[i];
                if (hashIn <= 0L || hashIn >= this.thetaLong_ || (foundIdx = HashOperations.hashSearch(hashTable, this.lgArrLongs_, hashIn)) == -1) continue;
                matchSet[matchSetCount++] = hashIn;
            }
        }
        this.curCount_ = matchSetCount;
        this.lgArrLongs_ = IntersectionImpl.computeMinLgArrLongsFromCount(matchSetCount);
        if (this.mem_ != null) {
            PreambleUtil.insertCurCount(this.mem_, matchSetCount);
            PreambleUtil.insertLgArrLongs(this.mem_, this.lgArrLongs_);
            this.mem_.clear(24L, (long)(8 << this.lgArrLongs_));
        } else {
            Arrays.fill(this.hashTable_, 0, 1 << this.lgArrLongs_, 0L);
        }
        if (this.curCount_ > 0) {
            this.moveDataToTgt(matchSet, matchSetCount);
        } else if (this.thetaLong_ == Long.MAX_VALUE) {
            this.empty_ = true;
        }
    }

    void moveDataToTgt(long[] arr, int count) {
        int arrLongsIn = arr.length;
        int tmpCnt = 0;
        if (this.mem_ != null) {
            int preBytes = 24;
            int lgArrLongs = this.lgArrLongs_;
            long thetaLong = this.thetaLong_;
            for (int i = 0; i < arrLongsIn; ++i) {
                long hashIn = arr[i];
                if (HashOperations.continueCondition(thetaLong, hashIn)) continue;
                HashOperations.fastHashInsertOnly(this.mem_, lgArrLongs, hashIn, 24);
                ++tmpCnt;
            }
        } else {
            for (int i = 0; i < arrLongsIn; ++i) {
                long hashIn = arr[i];
                if (HashOperations.continueCondition(this.thetaLong_, hashIn)) continue;
                HashOperations.hashInsertOnly(this.hashTable_, this.lgArrLongs_, hashIn);
                ++tmpCnt;
            }
        }
        assert (tmpCnt == count) : "Intersection Count Check: got: " + tmpCnt + ", expected: " + count;
    }
}

