/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.SketchesReadOnlyException;
import com.yahoo.sketches.SketchesStateException;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.Intersection;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.Sketch;

class IntersectionImplR
extends Intersection {
    protected final short seedHash_;
    protected final WritableMemory mem_;
    protected int lgArrLongs_;
    protected int curCount_;
    protected long thetaLong_;
    protected boolean empty_;
    protected long[] hashTable_ = null;
    protected int maxLgArrLongs_ = 0;

    IntersectionImplR(WritableMemory mem, long seed, boolean newMem) {
        this.mem_ = mem;
        if (mem != null) {
            if (newMem) {
                this.seedHash_ = IntersectionImplR.computeSeedHash(seed);
                this.mem_.putShort(6L, this.seedHash_);
            } else {
                this.seedHash_ = this.mem_.getShort(6L);
                Util.checkSeedHashes(this.seedHash_, IntersectionImplR.computeSeedHash(seed));
            }
        } else {
            this.seedHash_ = IntersectionImplR.computeSeedHash(seed);
        }
    }

    static IntersectionImplR wrapInstance(Memory srcMem, long seed) {
        IntersectionImplR impl = new IntersectionImplR((WritableMemory)srcMem, seed, false);
        return IntersectionImplR.internalWrapInstance(srcMem, impl);
    }

    static IntersectionImplR internalWrapInstance(Memory srcMem, IntersectionImplR impl) {
        boolean empty;
        int preLongsMem = srcMem.getByte(0L) & 0x3F;
        int serVer = srcMem.getByte(1L) & 0xFF;
        int famID = srcMem.getByte(2L) & 0xFF;
        int lgArrLongs = srcMem.getByte(4L) & 0xFF;
        int flags = srcMem.getByte(5L) & 0xFF;
        boolean bl = empty = (flags & 4) > 0;
        if (preLongsMem != 3) {
            throw new SketchesArgumentException("Memory PreambleLongs must equal 3: " + preLongsMem);
        }
        if (serVer != 3) {
            throw new SketchesArgumentException("Serialization Version must equal 3");
        }
        Family.INTERSECTION.checkFamilyID(famID);
        int curCount = srcMem.getInt(8L);
        long thetaLong = srcMem.getLong(16L);
        if (empty && curCount != 0) {
            throw new SketchesArgumentException("srcMem empty state inconsistent with curCount: " + empty + "," + curCount);
        }
        impl.lgArrLongs_ = lgArrLongs;
        impl.curCount_ = curCount;
        impl.thetaLong_ = thetaLong;
        impl.empty_ = empty;
        impl.maxLgArrLongs_ = IntersectionImplR.checkMaxLgArrLongs(srcMem);
        return impl;
    }

    @Override
    public CompactSketch getResult(boolean dstOrdered, WritableMemory dstMem) {
        long[] hashTable;
        if (this.curCount_ < 0) {
            throw new SketchesStateException("Calling getResult() with no intervening intersections is not a legal result.");
        }
        if (this.curCount_ == 0) {
            long[] compactCacheR = new long[]{};
            return IntersectionImplR.createCompactSketch(compactCacheR, this.empty_, this.seedHash_, this.curCount_, this.thetaLong_, dstOrdered, dstMem);
        }
        if (this.mem_ != null) {
            int htLen = 1 << this.lgArrLongs_;
            hashTable = new long[htLen];
            this.mem_.getLongArray(24L, hashTable, 0, htLen);
        } else {
            hashTable = this.hashTable_;
        }
        long[] compactCacheR = CompactSketch.compactCachePart(hashTable, this.lgArrLongs_, this.curCount_, this.thetaLong_, dstOrdered);
        return IntersectionImplR.createCompactSketch(compactCacheR, this.empty_, this.seedHash_, this.curCount_, this.thetaLong_, dstOrdered, dstMem);
    }

    @Override
    public CompactSketch getResult() {
        return this.getResult(true, null);
    }

    @Override
    int getRetainedEntries(boolean valid) {
        return this.curCount_;
    }

    @Override
    public boolean hasResult() {
        return this.mem_ != null ? this.mem_.getInt(8L) >= 0 : this.curCount_ >= 0;
    }

    @Override
    boolean isEmpty() {
        return this.empty_;
    }

    @Override
    public boolean isSameResource(Memory that) {
        return this.mem_ != null ? this.mem_.isSameResource((Object)that) : false;
    }

    @Override
    public void reset() {
        this.curCount_ = -1;
        this.thetaLong_ = Long.MAX_VALUE;
        this.empty_ = false;
        this.hashTable_ = null;
        if (this.mem_ != null) {
            PreambleUtil.insertLgArrLongs(this.mem_, this.lgArrLongs_);
            PreambleUtil.insertCurCount(this.mem_, -1);
            PreambleUtil.insertThetaLong(this.mem_, Long.MAX_VALUE);
            PreambleUtil.clearEmpty(this.mem_);
        }
    }

    @Override
    public byte[] toByteArray() {
        int preBytes = 24;
        int dataBytes = this.curCount_ > 0 ? 8 << this.lgArrLongs_ : 0;
        byte[] byteArrOut = new byte[24 + dataBytes];
        if (this.mem_ != null) {
            this.mem_.getByteArray(0L, byteArrOut, 0, 24 + dataBytes);
        } else {
            WritableMemory memOut = WritableMemory.wrap((byte[])byteArrOut);
            memOut.putByte(0L, (byte)3);
            memOut.putByte(1L, (byte)3);
            memOut.putByte(2L, (byte)Family.objectToFamily(this).getID());
            memOut.putByte(3L, (byte)0);
            memOut.putByte(4L, (byte)this.lgArrLongs_);
            if (this.empty_) {
                memOut.setBits(5L, (byte)4);
            } else {
                memOut.clearBits(5L, (byte)4);
            }
            memOut.putShort(6L, this.seedHash_);
            memOut.putInt(8L, this.curCount_);
            memOut.putFloat(12L, 1.0f);
            memOut.putLong(16L, this.thetaLong_);
            if (this.curCount_ > 0) {
                memOut.putLongArray(24L, this.hashTable_, 0, 1 << this.lgArrLongs_);
            }
        }
        return byteArrOut;
    }

    @Override
    public void update(Sketch sketchIn) {
        throw new SketchesReadOnlyException();
    }

    @Override
    long[] getCache() {
        if (this.mem_ == null) {
            return this.hashTable_ != null ? this.hashTable_ : new long[]{};
        }
        int arrLongs = 1 << this.lgArrLongs_;
        long[] outArr = new long[arrLongs];
        this.mem_.getLongArray(24L, outArr, 0, arrLongs);
        return outArr;
    }

    @Override
    short getSeedHash() {
        return this.seedHash_;
    }

    @Override
    long getThetaLong() {
        return this.thetaLong_;
    }

    static final int checkMaxLgArrLongs(Memory dstMem) {
        int preBytes = 24;
        long cap = dstMem.getCapacity();
        int maxLgArrLongs = Integer.numberOfTrailingZeros(Util.floorPowerOf2((int)(cap - 24L)) >>> 3);
        if (maxLgArrLongs < 5) {
            throw new SketchesArgumentException("dstMem not large enough for minimum sized hash table: " + cap);
        }
        return maxLgArrLongs;
    }
}

