/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.sketches.BinomialBoundsN;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.HashOperations;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.theta.DirectCompactOrderedSketch;
import com.yahoo.sketches.theta.DirectCompactUnorderedSketch;
import com.yahoo.sketches.theta.DirectQuickSelectSketchR;
import com.yahoo.sketches.theta.ForwardCompatibility;
import com.yahoo.sketches.theta.HeapAlphaSketch;
import com.yahoo.sketches.theta.HeapCompactOrderedSketch;
import com.yahoo.sketches.theta.HeapCompactUnorderedSketch;
import com.yahoo.sketches.theta.HeapQuickSelectSketch;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.UpdateSketch;

public abstract class Sketch {
    static final int DEFAULT_LG_RESIZE_FACTOR = 3;

    Sketch() {
    }

    public static Sketch heapify(Memory srcMem) {
        return Sketch.heapify(srcMem, 9001L);
    }

    public static Sketch heapify(Memory srcMem, long seed) {
        byte serVer = srcMem.getByte(1L);
        if (serVer == 3) {
            byte famID = srcMem.getByte(2L);
            boolean ordered = (srcMem.getByte(5L) & 0x10) != 0;
            return Sketch.constructHeapSketch(famID, ordered, srcMem, seed);
        }
        if (serVer == 1) {
            return ForwardCompatibility.heapify1to3(srcMem, seed);
        }
        if (serVer == 2) {
            return ForwardCompatibility.heapify2to3(srcMem, seed);
        }
        throw new SketchesArgumentException("Unknown Serialization Version: " + serVer);
    }

    public static Sketch wrap(Memory srcMem) {
        return Sketch.wrap(srcMem, 9001L);
    }

    public static Sketch wrap(Memory srcMem, long seed) {
        int preLongs = srcMem.getByte(0L) & 0x3F;
        int serVer = srcMem.getByte(1L) & 0xFF;
        int familyID = srcMem.getByte(2L) & 0xFF;
        Family family = Family.idToFamily(familyID);
        switch (family) {
            case QUICKSELECT: {
                if (serVer == 3 && preLongs == 3) {
                    return DirectQuickSelectSketchR.readOnlyWrap(srcMem, seed);
                }
                throw new SketchesArgumentException("Corrupted: " + (Object)((Object)family) + " family image: must have SerVer = 3 and preLongs = 3");
            }
            case COMPACT: {
                boolean ordered;
                if (serVer == 1) {
                    return ForwardCompatibility.heapify1to3(srcMem, seed);
                }
                if (serVer == 2) {
                    return ForwardCompatibility.heapify2to3(srcMem, seed);
                }
                byte flags = srcMem.getByte(5L);
                boolean compact = (flags & 8) > 0;
                boolean bl = ordered = (flags & 0x10) > 0;
                if (compact) {
                    return ordered ? DirectCompactOrderedSketch.wrapInstance(srcMem, seed) : DirectCompactUnorderedSketch.wrapInstance(srcMem, seed);
                }
                throw new SketchesArgumentException("Corrupted: " + (Object)((Object)family) + " family image must have compact flag set");
            }
        }
        throw new SketchesArgumentException("Sketch cannot wrap family: " + (Object)((Object)family) + " as a Sketch");
    }

    public int getCountLessThanTheta(double theta) {
        long thetaLong = (long)(9.223372036854776E18 * theta);
        return HashOperations.count(this.getCache(), thetaLong);
    }

    public abstract int getCurrentBytes(boolean var1);

    public double getEstimate() {
        return Sketch.estimate(this.getThetaLong(), this.getRetainedEntries(true), this.isEmpty());
    }

    public abstract Family getFamily();

    public double getLowerBound(int numStdDev) {
        return this.isEstimationMode() ? Sketch.lowerBound(this.getRetainedEntries(true), this.getThetaLong(), numStdDev, this.isEmpty()) : (double)this.getRetainedEntries(true);
    }

    public static int getMaxCompactSketchBytes(int numberOfEntries) {
        return (numberOfEntries << 3) + (Family.COMPACT.getMaxPreLongs() << 3);
    }

    public static int getMaxUpdateSketchBytes(int nomEntries) {
        int nomEnt = Util.ceilingPowerOf2(nomEntries);
        return (nomEnt << 4) + (Family.QUICKSELECT.getMaxPreLongs() << 3);
    }

    public int getRetainedEntries() {
        return this.getRetainedEntries(true);
    }

    public abstract int getRetainedEntries(boolean var1);

    public static int getSerializationVersion(Memory mem) {
        return mem.getByte(1L);
    }

    public double getTheta() {
        return (double)this.getThetaLong() / 9.223372036854776E18;
    }

    public double getUpperBound(int numStdDev) {
        return this.isEstimationMode() ? Sketch.upperBound(this.getRetainedEntries(true), this.getThetaLong(), numStdDev, this.isEmpty()) : (double)this.getRetainedEntries(true);
    }

    public abstract boolean hasMemory();

    public abstract boolean isCompact();

    public abstract boolean isDirect();

    public abstract boolean isEmpty();

    public boolean isEstimationMode() {
        return Sketch.estMode(this.getThetaLong(), this.isEmpty());
    }

    public abstract boolean isOrdered();

    public boolean isSameResource(Memory that) {
        return false;
    }

    public abstract byte[] toByteArray();

    public String toString() {
        return this.toString(true, false, 8, true);
    }

    public String toString(boolean sketchSummary, boolean dataDetail, int width, boolean hexMode) {
        StringBuilder sb = new StringBuilder();
        long[] cache = this.getCache();
        int nomLongs = 0;
        int arrLongs = cache.length;
        long seed = 0L;
        float p = 0.0f;
        int rf = 0;
        boolean updateSketch = this instanceof UpdateSketch;
        long thetaLong = this.getThetaLong();
        int curCount = this.getRetainedEntries(true);
        if (updateSketch) {
            UpdateSketch uis = (UpdateSketch)this;
            nomLongs = 1 << uis.getLgNomLongs();
            seed = uis.getSeed();
            arrLongs = 1 << uis.getLgArrLongs();
            p = uis.getP();
            rf = uis.getResizeFactor().getValue();
        }
        if (dataDetail) {
            int w;
            int n = w = width > 0 ? width : 8;
            if (curCount > 0) {
                sb.append("### SKETCH DATA DETAIL");
                int j = 0;
                for (int i = 0; i < arrLongs; ++i) {
                    long h = cache[i];
                    if (h <= 0L || h >= thetaLong) continue;
                    if (j % w == 0) {
                        sb.append(Util.LS).append(String.format("   %6d", j + 1));
                    }
                    if (hexMode) {
                        sb.append(" " + Util.zeroPad(Long.toHexString(h), 16) + ",");
                    } else {
                        sb.append(String.format(" %20d,", h));
                    }
                    ++j;
                }
                sb.append(Util.LS).append("### END DATA DETAIL").append(Util.LS + Util.LS);
            }
        }
        if (sketchSummary) {
            double thetaDbl = (double)thetaLong / 9.223372036854776E18;
            String thetaHex = Util.zeroPad(Long.toHexString(thetaLong), 16);
            String thisSimpleName = this.getClass().getSimpleName();
            int seedHash = this.getSeedHash() & 0xFFFF;
            sb.append(Util.LS);
            sb.append("### ").append(thisSimpleName).append(" SUMMARY: ").append(Util.LS);
            if (updateSketch) {
                sb.append("   Nominal Entries (k)     : ").append(nomLongs).append(Util.LS);
            }
            sb.append("   Estimate                : ").append(this.getEstimate()).append(Util.LS);
            sb.append("   Upper Bound, 95% conf   : ").append(this.getUpperBound(2)).append(Util.LS);
            sb.append("   Lower Bound, 95% conf   : ").append(this.getLowerBound(2)).append(Util.LS);
            if (updateSketch) {
                sb.append("   p                       : ").append(p).append(Util.LS);
            }
            sb.append("   Theta (double)          : ").append(thetaDbl).append(Util.LS);
            sb.append("   Theta (long)            : ").append(thetaLong).append(Util.LS);
            sb.append("   Theta (long) hex        : ").append(thetaHex).append(Util.LS);
            sb.append("   EstMode?                : ").append(this.isEstimationMode()).append(Util.LS);
            sb.append("   Empty?                  : ").append(this.isEmpty()).append(Util.LS);
            if (updateSketch) {
                sb.append("   Resize Factor           : ").append(rf).append(Util.LS);
            }
            sb.append("   Array Size Entries      : ").append(arrLongs).append(Util.LS);
            sb.append("   Retained Entries        : ").append(curCount).append(Util.LS);
            if (updateSketch) {
                sb.append("   Update Seed             : ").append(Long.toHexString(seed)).append(" | ").append(Long.toString(seed)).append(Util.LS);
            }
            sb.append("   Seed Hash               : ").append(Integer.toHexString(seedHash)).append(Util.LS);
            sb.append("### END SKETCH SUMMARY").append(Util.LS);
        }
        return sb.toString();
    }

    abstract long[] getCache();

    int getCurrentDataLongs(boolean compact) {
        return this.isCompact() || compact ? this.getRetainedEntries(true) : 1 << ((UpdateSketch)this).getLgArrLongs();
    }

    abstract int getCurrentPreambleLongs(boolean var1);

    static final int computeCompactPreLongs(long thetaLong, boolean empty, int curCount) {
        return thetaLong < Long.MAX_VALUE ? 3 : (empty ? 1 : (curCount > 1 ? 2 : 1));
    }

    abstract Memory getMemory();

    abstract short getSeedHash();

    abstract long getThetaLong();

    static final boolean isValidSketchID(int id) {
        return id == Family.ALPHA.getID() || id == Family.QUICKSELECT.getID() || id == Family.COMPACT.getID();
    }

    static final void checkSketchAndMemoryFlags(Sketch sketch) {
        Memory mem = sketch.getMemory();
        if (mem == null) {
            return;
        }
        int flags = PreambleUtil.extractFlags(mem);
        if ((flags & 8) > 0 ^ sketch.isCompact()) {
            throw new SketchesArgumentException("Possible corruption: Memory Compact Flag inconsistent with Sketch");
        }
        if ((flags & 0x10) > 0 ^ sketch.isOrdered()) {
            throw new SketchesArgumentException("Possible corruption: Memory Ordered Flag inconsistent with Sketch");
        }
    }

    static final double estimate(long thetaLong, int curCount, boolean empty) {
        if (Sketch.estMode(thetaLong, empty)) {
            double theta = (double)thetaLong / 9.223372036854776E18;
            return (double)curCount / theta;
        }
        return curCount;
    }

    static final double lowerBound(int curCount, long thetaLong, int numStdDev, boolean empty) {
        double theta = (double)thetaLong / 9.223372036854776E18;
        return BinomialBoundsN.getLowerBound(curCount, theta, numStdDev, empty);
    }

    static final double upperBound(int curCount, long thetaLong, int numStdDev, boolean empty) {
        double theta = (double)thetaLong / 9.223372036854776E18;
        return BinomialBoundsN.getUpperBound(curCount, theta, numStdDev, empty);
    }

    private static final boolean estMode(long thetaLong, boolean empty) {
        return thetaLong < Long.MAX_VALUE && !empty;
    }

    private static final Sketch constructHeapSketch(byte famID, boolean ordered, Memory srcMem, long seed) {
        boolean compact = (srcMem.getByte(5L) & 8) != 0;
        Family family = Family.idToFamily(famID);
        switch (family) {
            case ALPHA: {
                if (compact) {
                    throw new SketchesArgumentException("Possibly Corrupted " + (Object)((Object)family) + " image: cannot be compact");
                }
                return HeapAlphaSketch.heapifyInstance(srcMem, seed);
            }
            case QUICKSELECT: {
                return HeapQuickSelectSketch.heapifyInstance(srcMem, seed);
            }
            case COMPACT: {
                if (!compact) {
                    throw new SketchesArgumentException("Possibly Corrupted " + (Object)((Object)family) + " image: must be compact");
                }
                return ordered ? HeapCompactOrderedSketch.heapifyInstance(srcMem, seed) : HeapCompactUnorderedSketch.heapifyInstance(srcMem, seed);
            }
        }
        throw new SketchesArgumentException("Sketch cannot heapify family: " + (Object)((Object)family) + " as a Sketch");
    }
}

