/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.DefaultMemoryRequestServer;
import com.yahoo.memory.MemoryRequestServer;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.ResizeFactor;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.theta.DirectQuickSelectSketch;
import com.yahoo.sketches.theta.HeapAlphaSketch;
import com.yahoo.sketches.theta.HeapQuickSelectSketch;
import com.yahoo.sketches.theta.UpdateSketch;

public class UpdateSketchBuilder {
    private int bLgNomLongs = Integer.numberOfTrailingZeros(4096);
    private long bSeed = 9001L;
    private ResizeFactor bRF = ResizeFactor.X8;
    private Family bFam = Family.QUICKSELECT;
    private float bP = 1.0f;
    private MemoryRequestServer bMemReqSvr = new DefaultMemoryRequestServer();

    public UpdateSketchBuilder setNominalEntries(int nomEntries) {
        this.bLgNomLongs = Integer.numberOfTrailingZeros(Util.ceilingPowerOf2(nomEntries));
        if (this.bLgNomLongs > 26 || this.bLgNomLongs < 4) {
            throw new SketchesArgumentException("Nominal Entries must be >= 16 and <= 67108864: " + nomEntries);
        }
        return this;
    }

    public int getLgNominalEntries() {
        return this.bLgNomLongs;
    }

    public UpdateSketchBuilder setSeed(long seed) {
        this.bSeed = seed;
        return this;
    }

    public long getSeed() {
        return this.bSeed;
    }

    public UpdateSketchBuilder setP(float p) {
        if ((double)p <= 0.0 || (double)p > 1.0) {
            throw new SketchesArgumentException("p must be > 0 and <= 1.0: " + p);
        }
        this.bP = p;
        return this;
    }

    public float getP() {
        return this.bP;
    }

    public UpdateSketchBuilder setResizeFactor(ResizeFactor rf) {
        this.bRF = rf;
        return this;
    }

    public ResizeFactor getResizeFactor() {
        return this.bRF;
    }

    public UpdateSketchBuilder setFamily(Family family) {
        this.bFam = family;
        return this;
    }

    public Family getFamily() {
        return this.bFam;
    }

    public UpdateSketchBuilder setMemoryRequestServer(MemoryRequestServer memReqSvr) {
        this.bMemReqSvr = memReqSvr;
        return this;
    }

    public MemoryRequestServer getMemoryRequestServer() {
        return this.bMemReqSvr;
    }

    public UpdateSketch build() {
        return this.build(null);
    }

    public UpdateSketch build(WritableMemory dstMem) {
        UpdateSketch sketch = null;
        switch (this.bFam) {
            case ALPHA: {
                if (dstMem == null) {
                    sketch = HeapAlphaSketch.newHeapInstance(this.bLgNomLongs, this.bSeed, this.bP, this.bRF);
                    break;
                }
                throw new SketchesArgumentException("AlphaSketch cannot be made Direct to Memory.");
            }
            case QUICKSELECT: {
                if (dstMem == null) {
                    sketch = new HeapQuickSelectSketch(this.bLgNomLongs, this.bSeed, this.bP, this.bRF, false);
                    break;
                }
                sketch = new DirectQuickSelectSketch(this.bLgNomLongs, this.bSeed, this.bP, this.bRF, this.bMemReqSvr, dstMem, false);
                break;
            }
            default: {
                throw new SketchesArgumentException("Given Family cannot be built as a Theta Sketch: " + this.bFam.toString());
            }
        }
        return sketch;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateSketchBuilder configuration:").append(Util.LS);
        sb.append("LgK:").append('\t').append(this.bLgNomLongs).append(Util.LS);
        sb.append("K:").append('\t').append(1 << this.bLgNomLongs).append(Util.LS);
        sb.append("Seed:").append('\t').append(this.bSeed).append(Util.LS);
        sb.append("p:").append('\t').append(this.bP).append(Util.LS);
        sb.append("ResizeFactor:").append('\t').append((Object)this.bRF).append(Util.LS);
        sb.append("Family:").append('\t').append((Object)this.bFam).append(Util.LS);
        String mrsStr = this.bMemReqSvr.getClass().getSimpleName();
        sb.append("MemoryRequestServer:").append('\t').append(mrsStr).append(Util.LS);
        return sb.toString();
    }
}

