/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.tuple;

import com.yahoo.memory.Memory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.tuple.DeserializeResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

final class SerializerDeserializer {
    static final int TYPE_BYTE_OFFSET = 3;
    private static final Map<String, Method> deserializeMethodCache = new HashMap<String, Method>();

    SerializerDeserializer() {
    }

    static void validateFamily(byte familyId, byte preambleLongs) {
        Family family = Family.idToFamily(familyId);
        if (family.equals((Object)Family.TUPLE)) {
            if (preambleLongs != Family.TUPLE.getMinPreLongs()) {
                throw new SketchesArgumentException("Possible corruption: Invalid PreambleLongs value for family TUPLE: " + preambleLongs);
            }
        } else {
            throw new SketchesArgumentException("Possible corruption: Invalid Family: " + family.toString());
        }
    }

    static void validateType(byte sketchTypeByte, SketchType expectedType) {
        SketchType sketchType = SerializerDeserializer.getSketchType(sketchTypeByte);
        if (!sketchType.equals((Object)expectedType)) {
            throw new SketchesArgumentException("Sketch Type mismatch. Expected " + expectedType.name() + ", got " + sketchType.name());
        }
    }

    static SketchType getSketchType(Memory mem) {
        byte sketchTypeByte = mem.getByte(3L);
        return SerializerDeserializer.getSketchType(sketchTypeByte);
    }

    private static SketchType getSketchType(byte sketchTypeByte) {
        if (sketchTypeByte < 0 || sketchTypeByte >= SketchType.values().length) {
            throw new SketchesArgumentException("Invalid Sketch Type " + sketchTypeByte);
        }
        return SketchType.values()[sketchTypeByte];
    }

    static <T> DeserializeResult<T> deserializeFromMemory(Memory mem, int offset) {
        byte classNameLength = mem.getByte((long)offset);
        byte[] classNameBuffer = new byte[classNameLength];
        mem.getByteArray((long)(offset + 1), classNameBuffer, 0, (int)classNameLength);
        String className = new String(classNameBuffer, StandardCharsets.UTF_8);
        DeserializeResult<T> result = SerializerDeserializer.deserializeFromMemory(mem, offset + classNameLength + 1, className);
        return new DeserializeResult<T>(result.getObject(), result.getSize() + classNameLength + 1);
    }

    static <T> DeserializeResult<T> deserializeFromMemory(Memory mem, int offset, String className) {
        try {
            Method method = deserializeMethodCache.get(className);
            if (method == null) {
                method = Class.forName(className).getMethod("fromMemory", Memory.class);
                deserializeMethodCache.put(className, method);
            }
            return (DeserializeResult)method.invoke(null, mem.region((long)offset, mem.getCapacity() - (long)offset));
        }
        catch (SketchesArgumentException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new SketchesArgumentException("Failed to deserialize class " + className + " " + e);
        }
    }

    static enum SketchType {
        QuickSelectSketch,
        CompactSketch,
        ArrayOfDoublesQuickSelectSketch,
        ArrayOfDoublesCompactSketch,
        ArrayOfDoublesUnion;

    }
}

