/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cdms.ds.siebel.sdb.impl;

import com.cognos.cdms.ds.logger.Logger;
import com.cognos.cdms.ds.siebel.beans.SiebelQueryBean;
import com.cognos.cdms.ds.siebel.sdb.SDBLoggerModule;
import com.cognos.cdms.ds.siebel.sdb.SDBResultSet;
import com.siebel.data.SiebelBusComp;
import com.siebel.data.SiebelBusObject;
import com.siebel.data.SiebelException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDBResultSetImpl
implements SDBResultSet {
    private static final Logger logger = SDBLoggerModule.getLoggerFactory().getLogger(SDBResultSetImpl.class);
    private SiebelBusComp mBusComp = null;
    private SiebelQueryBean mQueryBean = null;

    SDBResultSetImpl(SiebelBusComp busComp, SiebelQueryBean queryBean) {
        this.mBusComp = busComp;
        this.mQueryBean = queryBean;
    }

    @Override
    public List<String> getColumns() {
        return this.mQueryBean.getFields();
    }

    @Override
    public void close() {
        block2: {
            try {
                SiebelBusObject busObj = this.mBusComp.busObject();
                this.mBusComp.release();
                busObj.release();
            }
            catch (SiebelException e) {
                if (!logger.isDebug()) break block2;
                logger.debug("Close result set failed ", e);
            }
        }
    }

    @Override
    public boolean first() {
        try {
            return this.mBusComp.firstRecord();
        }
        catch (SiebelException e) {
            if (logger.isDebug()) {
                logger.debug("first() operation on result set failed", e);
            }
            return false;
        }
    }

    @Override
    public String getString(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        if (this.mQueryBean.isLiteralField(fieldName)) {
            if (fieldName.startsWith("'") && fieldName.endsWith("'")) {
                return fieldName.substring(1, fieldName.length() - 1);
            }
            return fieldName;
        }
        if (this.mQueryBean.isNegateFunction(fieldName)) {
            return fieldName.replaceAll("[^0-9|\\.|-]", "");
        }
        try {
            return this.mBusComp.getFieldValue(fieldName);
        }
        catch (SiebelException e) {
            if (logger.isDebug()) {
                logger.debug("Unable to fetch value for field name = " + fieldName, e);
            }
            return null;
        }
    }

    @Override
    public boolean next() {
        try {
            return this.mBusComp.nextRecord();
        }
        catch (SiebelException e) {
            if (logger.isDebug()) {
                logger.debug("next() operation on result set failed", e);
            }
            return false;
        }
    }
}

