/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cdms.ds.siebel.sdb.impl;

import com.cognos.cdms.ds.logger.Logger;
import com.cognos.cdms.ds.siebel.sdb.SDBException;
import com.cognos.cdms.ds.siebel.sdb.SDBLoggerModule;
import com.cognos.cdms.ds.siebel.sdb.impl.SDBFactory;
import com.cognos.cdms.ds.siebel.sdb.impl.SDBSession;
import com.siebel.data.SiebelDataBean;
import com.siebel.data.SiebelException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class SDBSessionPool {
    private static SDBSessionPool mInstance = new SDBSessionPool();
    private Map<String, Set<String>> sessionsMap = new HashMap<String, Set<String>>();
    private ReentrantReadWriteLock sessionKeyMapLock = new ReentrantReadWriteLock();
    private HashMap<String, ReentrantLock> sessionKeyLocks = new HashMap();
    private static final Logger logger;
    private ReentrantLock mLoginLock = new ReentrantLock();

    private SDBSessionPool() {
    }

    public static SDBSessionPool getInstance() {
        return mInstance;
    }

    private String getSessionKey(String connectStr, String userName, String codePage) {
        return connectStr + "::" + userName + "::" + codePage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantLock getSessionKeyLock(String sessionKey) {
        ReentrantReadWriteLock.ReadLock readLock = this.sessionKeyMapLock.readLock();
        try {
            readLock.lockInterruptibly();
            ReentrantLock lock = this.sessionKeyLocks.get(sessionKey);
            if (lock != null) {
                ReentrantLock reentrantLock = lock;
                return reentrantLock;
            }
            if (logger.isDebug()) {
                logger.debug("Lock for session key = " + sessionKey + " not found.");
            }
        }
        catch (InterruptedException ie) {
            if (logger.isDebug()) {
                logger.debug("Interrupted while trying to get read  a session key map lock");
            }
        }
        finally {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.sessionKeyMapLock.writeLock();
        try {
            writeLock.lockInterruptibly();
            ReentrantLock lock = this.sessionKeyLocks.get(sessionKey);
            if (lock == null) {
                if (logger.isDebug()) {
                    logger.debug("Creating the lock for session key = " + sessionKey);
                }
                lock = new ReentrantLock();
                this.sessionKeyLocks.put(sessionKey, lock);
            }
            ReentrantLock reentrantLock = lock;
            return reentrantLock;
        }
        catch (InterruptedException ie) {
            if (logger.isDebug()) {
                logger.debug("Interrupted while trying to get write  a session key map lock");
            }
            ReentrantLock reentrantLock = null;
            return reentrantLock;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String retrieveSession(String connectStr, String userName, String password, String codePage) {
        String sessionKey = this.getSessionKey(connectStr, userName, codePage);
        ReentrantLock sessionKeyLock = this.getSessionKeyLock(sessionKey);
        if (sessionKeyLock == null) {
            return null;
        }
        try {
            Iterator<String> iter;
            sessionKeyLock.lockInterruptibly();
            Set<String> sessionIds = this.sessionsMap.get(sessionKey);
            if (sessionIds != null && (iter = sessionIds.iterator()).hasNext()) {
                String sessionId = iter.next();
                sessionIds.remove(sessionId);
                if (logger.isDebug()) {
                    logger.debug("Found the session : [ connect string = " + connectStr + " ], [ userName = " + userName + " ], [ codePage = " + codePage + " ]");
                }
                String string = sessionId;
                return string;
            }
        }
        catch (InterruptedException ie) {
            if (logger.isDebug()) {
                logger.debug("Interrupted while trying to get  a session key lock");
            }
        }
        finally {
            sessionKeyLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeSession(String connectStr, String userName, String password, String codePage, String sessionId) {
        String sessionKey = this.getSessionKey(connectStr, userName, codePage);
        ReentrantLock sessionkeyLock = this.getSessionKeyLock(sessionKey);
        if (sessionkeyLock == null) {
            if (logger.isDebug()) {
                logger.log("Cannot pool session due to unavailability of lock");
            }
            this.releaseSession(sessionId);
            return;
        }
        try {
            sessionkeyLock.lock();
            Set<String> sessionIds = this.sessionsMap.get(sessionKey);
            if (sessionIds == null) {
                sessionIds = new LinkedHashSet<String>();
                this.sessionsMap.put(sessionKey, sessionIds);
            }
            if (logger.isDebug()) {
                logger.debug("Storing the session id : [ connect string = " + connectStr + " ], [ userName = " + userName + " ], [ codePage = " + codePage + " ]");
            }
            sessionIds.add(sessionId);
        }
        finally {
            sessionkeyLock.unlock();
        }
    }

    public SDBSession attach(String connectStr, String sessionId) throws SDBException {
        SiebelDataBean dataBean = SDBFactory.getInstance().makeSiebelDataBean();
        if (sessionId != null) {
            try {
                dataBean.attach(sessionId);
                return new SDBSession(connectStr, null, null, null, dataBean);
            }
            catch (SiebelException se) {
                if (logger.isDebug()) {
                    logger.debug("Unable to attach to session[session id = " + sessionId + "]");
                }
                throw new SDBException(0, connectStr, se);
            }
        }
        return null;
    }

    public SDBSession checkOut(String connectStr, String userName, String password, String codePage) throws SDBException {
        boolean loggedIn;
        String sessionId = this.retrieveSession(connectStr, userName, password, codePage);
        SiebelDataBean dataBean = SDBFactory.getInstance().makeSiebelDataBean();
        if (sessionId != null) {
            boolean attached = false;
            try {
                attached = dataBean.attach(sessionId);
            }
            catch (SiebelException se) {
                if (logger.isDebug()) {
                    logger.debug("Unable to attach to session[session id = " + sessionId + "]");
                }
                attached = false;
            }
            if (attached) {
                return new SDBSession(connectStr, userName, password, codePage, dataBean);
            }
        }
        if (!(loggedIn = this.login(dataBean, connectStr, userName, password, codePage))) {
            throw new SDBException(0, connectStr);
        }
        return new SDBSession(connectStr, userName, password, codePage, dataBean);
    }

    private boolean login(SiebelDataBean dataBean, String connectStr, String userName, String password, String codePage) throws SDBException {
        String systemFileEncoding = System.getProperty("file.encoding");
        try {
            this.mLoginLock.lock();
            System.setProperty("file.encoding", codePage);
            boolean bl = dataBean.login(connectStr, userName, password);
            return bl;
        }
        catch (SiebelException se) {
            if (logger.isDebug()) {
                logger.debug("Unable to login for connect String = " + connectStr + ", codePage = " + codePage + ",user name = " + userName);
            }
            throw new SDBException(0, connectStr, se);
        }
        finally {
            System.setProperty("file.encoding", systemFileEncoding);
            this.mLoginLock.unlock();
        }
    }

    public boolean checkIn(SDBSession session) {
        block5: {
            String sessionId = null;
            SiebelDataBean dataBean = null;
            try {
                dataBean = session.getDataBean();
                sessionId = dataBean.detach();
                this.storeSession(session.getConnectStr(), session.getUserName(), session.getPassword(), session.getCodePage(), sessionId);
            }
            catch (SiebelException se) {
                boolean loggedOff;
                block6: {
                    if (logger.isDebug()) {
                        logger.debug("Unable to detach session.");
                    }
                    if (sessionId != null) break block5;
                    loggedOff = false;
                    try {
                        loggedOff = dataBean.logoff();
                    }
                    catch (SiebelException e) {
                        if (!logger.isDebug()) break block6;
                        logger.debug("Unable to log off.");
                    }
                }
                return loggedOff;
            }
        }
        return true;
    }

    private void releaseAllSessions() {
        if (logger.isDebug()) {
            logger.debug("Releasing pooled sessions");
        }
        Set<Map.Entry<String, Set<String>>> sessionMapEntrySet = this.sessionsMap.entrySet();
        for (Map.Entry<String, Set<String>> entry : sessionMapEntrySet) {
            Set<String> sessionIds = entry.getValue();
            for (String sessionId : sessionIds) {
                this.releaseSession(sessionId);
            }
        }
    }

    private void releaseSession(String sessionId) {
        block3: {
            SiebelDataBean dataBean = SDBFactory.getInstance().makeSiebelDataBean();
            try {
                boolean success = dataBean.attach(sessionId);
                if (success) {
                    dataBean.logoff();
                }
            }
            catch (SiebelException se) {
                if (!logger.isDebug()) break block3;
                logger.debug("Exception when releasing session", se);
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                mInstance.releaseAllSessions();
            }
        });
        logger = SDBLoggerModule.getLoggerFactory().getLogger(SDBSessionPool.class);
    }
}

