/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.common.exceptions;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.qs.common.exceptions.ExceptionUtils;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.OrderedJSONObject;

public class DataSourceExceptionQS
extends QueryServiceException {
    private static final long serialVersionUID = 523123518393664818L;
    protected static final String DS_DATASOURCE_NAME = "dataSourceName";
    protected static final String DS_CONNECTIONS = "connections";
    protected static final String DS_DATASOURCE_CONNECTION_NAME = "dataSourceConnectionName";
    public static final String DS_SIGNONS = "signons";
    public static final String CODE = "code";
    public static final String MESSAGE = "message";
    public static final String ERRORS = "errors";
    public static final String SUBCODE = "subcode";
    public static final String PARAMETERS = "parameters";
    public static final String NAME = "name";
    private final JSONObject mJsonParameters = new OrderedJSONObject();
    private final Map<String, String> mErrorParameters = new HashMap<String, String>();

    public DataSourceExceptionQS(Throwable cause, IMessageKey.Param0 messageKey, int statusCode) {
        super(cause, statusCode, messageKey);
    }

    protected void addParameter(String name, String value) {
        ExceptionUtils.putJSONObjectProperty(this.mJsonParameters, name, value);
    }

    protected void addErrorParameter(String name, String value) {
        this.mErrorParameters.put(name, value);
    }

    protected void addArrayParameter(String name, List<String> values) {
        if (values != null && !values.isEmpty()) {
            JSONArray jValues = new JSONArray();
            for (String value : values) {
                JSONObject jValue = new JSONObject();
                ExceptionUtils.putJSONObjectProperty(jValue, NAME, value);
                jValues.add((Object)jValue);
            }
            ExceptionUtils.putJSONObjectProperty(this.mJsonParameters, name, jValues);
        }
    }

    @Override
    public JSONObject buildError(Locale locale) {
        OrderedJSONObject jsonErrors = new OrderedJSONObject();
        JSONArray jsonErrorArray = new JSONArray();
        ExceptionUtils.putJSONObjectProperty((JSONObject)jsonErrors, ERRORS, jsonErrorArray);
        OrderedJSONObject error = new OrderedJSONObject();
        String errorCode = this.getMessageKey().getErrorCode();
        ExceptionUtils.putJSONObjectProperty((JSONObject)error, CODE, errorCode);
        String msg = this.getLocalizedMessage(locale);
        if (msg != null && msg.length() > errorCode.length() + 1) {
            ExceptionUtils.putJSONObjectProperty((JSONObject)error, MESSAGE, msg.substring(errorCode.length() + 1));
        }
        for (Map.Entry<String, String> eparam : this.mErrorParameters.entrySet()) {
            ExceptionUtils.putJSONObjectProperty((JSONObject)error, eparam.getKey(), eparam.getValue());
        }
        JSONArray jsonParametersArray = new JSONArray();
        ExceptionUtils.putJSONObjectProperty((JSONObject)error, PARAMETERS, jsonParametersArray);
        jsonParametersArray.add((Object)this.mJsonParameters);
        jsonErrorArray.add((Object)error);
        return jsonErrors;
    }
}

