/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.common.exceptions;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.ibm.bi.common.exceptions.cqe.catalogs.CQEError;
import com.ibm.bi.qs.common.exceptions.DataSourceExceptionQS;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;

public class LogonFailureExceptionQS
extends DataSourceExceptionQS {
    private static final long serialVersionUID = -930932761001170545L;
    private final transient IDataSourceConnection mTestConnection;

    public LogonFailureExceptionQS(LogonFailureException logonFailureException) {
        super(logonFailureException.getCause(), CQEError.DS_DataSourceLogonFailure, 403);
        this.mTestConnection = null;
        this.init(logonFailureException);
    }

    public LogonFailureExceptionQS(LogonFailureException logonFailureException, IDataSourceConnection testConnection) {
        super(logonFailureException.getCause(), CQEError.DS_DataSourceLogonFailure, 403);
        this.mTestConnection = testConnection;
        this.init(logonFailureException);
    }

    private void init(LogonFailureException logonFailureException) {
        IDataSource dataSource = logonFailureException.getDataSource();
        IDataSourceConnection connection = null;
        if (this.mTestConnection != null) {
            connection = this.mTestConnection;
        } else if (dataSource != null) {
            connection = dataSource.getDataSourceConnection();
        }
        if (null == dataSource || null == connection) {
            XQERuntimeException xqeError = new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)logonFailureException);
            throw QueryServiceException.wrap((Throwable)xqeError);
        }
        this.addErrorParameter("subcode", logonFailureException.getSubCode().getFaultSubCode());
        this.addParameter("dataSourceName", dataSource.getCMDataSourceName());
        this.addParameter("dataSourceConnectionName", connection.getName());
    }
}

