/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.common.exceptions;

import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterCapabilities;
import com.cognos.xqe.query.parameters.Parameters;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.ExceptionUtils;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import java.util.Locale;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.OrderedJSONObject;

public class MissingParameterValueException
extends QueryServiceException {
    private static final String NAMEKEY_NAME = "name";
    private static final String VALUE_NAME = "value";
    private static final String DATATYPE_NAME = "dataType";
    private static final String MODEL_FILTER_ITEM_NAME = "modelFilterItem";
    private static final String MODEL_FILTER_ITEM_PATH = "modelPath";
    private static final String MODEL_FILTER_ITEM_MODULE_PATH = "modulePath";
    private final Parameters parameters;
    private Object usedParameters;
    private static final long serialVersionUID = 2690004870862053373L;
    private static final String CAPABILITIES_NAME = "capabilities";
    private static final String OPTIONAL_NAME = "optional";
    private static final String DISCRETE_VALUE_NAME = "discreteValue";
    private static final String MULTIVALUED_NAME = "multivalued";
    private static final String CAPTION = "caption";
    private static final String PARAMETER_NAME = "parameterName";
    private static final String PROMPT_TYPE = "promptType";
    private static final String UNBOUNDED_RANGE = "unboundedRange";
    private static final String BOUNDED_RANGE = "boundRange";

    public MissingParameterValueException(Throwable cause, Parameters params, Object usedParameters) {
        super(cause, 412, QueryServiceMessageKeys.REST_MISSING_PARAMETERS_IN_QUERY);
        this.parameters = params;
        this.usedParameters = usedParameters;
    }

    @Override
    public JSONObject buildError(Locale locale) {
        OrderedJSONObject errors = new OrderedJSONObject();
        JSONArray errorsArray = new JSONArray();
        ExceptionUtils.putJSONObjectProperty((JSONObject)errors, "errors", errorsArray);
        OrderedJSONObject error = new OrderedJSONObject();
        UnresolvedParameterException xqeException = (UnresolvedParameterException)this.getCause();
        String errorCode = xqeException.getFaultCode();
        ExceptionUtils.putJSONObjectProperty((JSONObject)error, "code", errorCode);
        String msg = this.getLocalizedMessage(locale);
        if (msg != null && msg.length() > errorCode.length() + 1) {
            ExceptionUtils.putJSONObjectProperty((JSONObject)error, "message", msg.substring(errorCode.length() + 1));
        }
        JSONArray parametersArray = new JSONArray();
        ExceptionUtils.putJSONObjectProperty((JSONObject)error, "parameters", parametersArray);
        for (String paramName : this.parameters.keySet()) {
            OrderedJSONObject parameterJson = new OrderedJSONObject();
            Parameter paramObject = this.parameters.getParameter(paramName);
            ExceptionUtils.putJSONObjectProperty((JSONObject)parameterJson, NAMEKEY_NAME, paramObject.getName());
            OrderedJSONObject parameterJsonDef = new OrderedJSONObject();
            ExceptionUtils.putJSONObjectProperty((JSONObject)parameterJsonDef, DATATYPE_NAME, paramObject.getDataTypeName());
            ExceptionUtils.putJSONObjectProperty((JSONObject)parameterJsonDef, MODEL_FILTER_ITEM_NAME, paramObject.getModelItem());
            ExceptionUtils.putJSONObjectProperty((JSONObject)parameterJsonDef, MODEL_FILTER_ITEM_PATH, paramObject.getModelPath());
            ExceptionUtils.putJSONObjectProperty((JSONObject)parameterJsonDef, MODEL_FILTER_ITEM_MODULE_PATH, paramObject.getModulePath());
            ExceptionUtils.putJSONObjectProperty((JSONObject)parameterJsonDef, CAPTION, paramObject.getCaption());
            ExceptionUtils.putJSONObjectProperty((JSONObject)parameterJsonDef, PARAMETER_NAME, paramObject.getParameterName());
            ExceptionUtils.putJSONObjectProperty((JSONObject)parameterJsonDef, PROMPT_TYPE, paramObject.getPromptType());
            OrderedJSONObject capabilitiesJson = new OrderedJSONObject();
            ParameterCapabilities capabilities = paramObject.getCapabilities();
            ExceptionUtils.putJSONObjectProperty((JSONObject)capabilitiesJson, OPTIONAL_NAME, capabilities.isOptional());
            ExceptionUtils.putJSONObjectProperty((JSONObject)capabilitiesJson, DISCRETE_VALUE_NAME, capabilities.isDiscreteValue());
            ExceptionUtils.putJSONObjectProperty((JSONObject)capabilitiesJson, MULTIVALUED_NAME, capabilities.isMultivalued());
            ExceptionUtils.putJSONObjectProperty((JSONObject)capabilitiesJson, UNBOUNDED_RANGE, capabilities.isUnboundRange());
            ExceptionUtils.putJSONObjectProperty((JSONObject)capabilitiesJson, BOUNDED_RANGE, capabilities.isBoundRange());
            ExceptionUtils.putJSONObjectProperty((JSONObject)parameterJsonDef, CAPABILITIES_NAME, capabilitiesJson);
            ExceptionUtils.putJSONObjectProperty((JSONObject)parameterJson, VALUE_NAME, parameterJsonDef);
            parametersArray.add((Object)parameterJson);
        }
        errorsArray.add((Object)error);
        if (this.usedParameters != null) {
            OrderedJSONObject meta = new OrderedJSONObject();
            ExceptionUtils.putJSONObjectProperty((JSONObject)meta, "usedParams", this.usedParameters);
            ExceptionUtils.putJSONObjectProperty((JSONObject)errors, "meta", meta);
        }
        return errors;
    }
}

