/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.common.exceptions;

import com.ibm.bi.common.exceptions.cqe.catalogs.CQEError;
import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.qs.common.exceptions.ExceptionUtils;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.OrderedJSONObject;

public class ParameterException
extends QueryServiceException {
    private static final long serialVersionUID = -8182027726975230490L;
    private final Map<String, Object> parameters;

    public ParameterException(Throwable cause, int statusCode, IMessageKey.Param0 messageKey, Map<String, Object> parameters) {
        super(cause, statusCode, messageKey);
        this.parameters = parameters;
    }

    public Object getParameter(String key) {
        return this.parameters.get(key);
    }

    @Override
    public JSONObject buildError(Locale locale) {
        OrderedJSONObject errors = new OrderedJSONObject();
        JSONArray errorsArray = new JSONArray();
        ExceptionUtils.putJSONObjectProperty((JSONObject)errors, "errors", errorsArray);
        OrderedJSONObject error = new OrderedJSONObject();
        String errorCode = CQEError.DS_DataSourceLogonFailure.getErrorCode();
        ExceptionUtils.putJSONObjectProperty((JSONObject)error, "code", errorCode);
        String msg = this.getLocalizedMessage(locale);
        if (null != msg && msg.length() > errorCode.length() + 1) {
            ExceptionUtils.putJSONObjectProperty((JSONObject)error, "message", msg.substring(errorCode.length() + 1));
        }
        JSONArray parametersArray = new JSONArray();
        ExceptionUtils.putJSONObjectProperty((JSONObject)error, "parameters", parametersArray);
        OrderedJSONObject parameter = new OrderedJSONObject();
        ExceptionUtils.putJSONObjectProperty((JSONObject)parameter, "dataSourceName", this.getParameter("dataSourceName"));
        ExceptionUtils.putJSONObjectProperty((JSONObject)parameter, "dataSourceConnectionName", this.getParameter("dataSourceConnectionName"));
        parametersArray.add((Object)parameter);
        errorsArray.add((Object)error);
        return errors;
    }
}

