/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.common.exceptions;

import com.cognos.xqe.data.model.AmbiguousConnectionException;
import com.cognos.xqe.data.model.AmbiguousSignonException;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.LocaleConverter;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.platform.commons.messages.CommonsRuntimeException;
import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.commons.messages.Message;
import com.ibm.bi.platform.commons.messages.MessageUtil;
import com.ibm.bi.qs.common.QueryServiceLogger;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.AmbiguousConnectionExceptionQS;
import com.ibm.bi.qs.common.exceptions.AmbiguousSignonExceptionQS;
import com.ibm.bi.qs.common.exceptions.ExceptionUtils;
import com.ibm.bi.qs.common.exceptions.LogonFailureExceptionQS;
import com.ibm.bi.qs.common.services.UserProfileService;
import com.ibm.bi.qs.common.util.DAASUtils;
import com.ibm.bi.qs.service.ServletRequestContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.OrderedJSONObject;

public class QueryServiceException
extends CommonsRuntimeException {
    private static final long serialVersionUID = 4273286844411398201L;
    protected static final String ERRORS_NAME = "errors";
    protected static final String CODE_NAME = "code";
    protected static final String MESSAGE_NAME = "message";
    private static final String DETAILS_NAME = "details";
    public static final String DATA_SOURCE_NAME = "dataSourceName";
    public static final String DATA_SOURCE_CONNECTION_NAME = "dataSourceConnectionName";
    protected static final String PARAMETERS_NAME = "parameters";
    public static final int INTERNAL_SERVER_ERROR = 500;
    public static final int SERVICE_UNAVAILABLE = 503;
    public static final int BAD_REQUEST = 400;
    public static final int RESOURCE_NOT_FOUND = 404;
    public static final int FORBIDDEN_REQUEST = 403;
    public static final int PRECONDITION_FAILED = 412;
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("(DSS-\\w+\\d+)\\s+-\\s+(.*)");
    private static final String CAN_RECEIVE_DETAILED_ERRORS = "canReceiveDetailedErrors";
    private final int statusCode;
    private boolean mCanReceiveDetailedErrors = true;
    private Locale locale = null;

    public QueryServiceException(IMessageKey.Param0 messageKey) {
        this(500, messageKey);
    }

    public QueryServiceException(int statusCode, IMessageKey.Param0 messageKey) {
        super(new Message(messageKey));
        this.statusCode = statusCode;
    }

    public QueryServiceException(Throwable cause, IMessageKey.Param0 messageKey) {
        this(cause, 500, messageKey);
    }

    public QueryServiceException(Throwable cause, int statusCode, IMessageKey.Param0 messageKey) {
        super(cause, new Message(messageKey));
        this.statusCode = statusCode;
    }

    public QueryServiceException(IMessageKey.Param1 messageKey, String param1) {
        this(500, messageKey, param1);
    }

    public QueryServiceException(int statusCode, IMessageKey.Param1 messageKey, String param1) {
        super(new Message(messageKey, (Object)param1));
        this.statusCode = statusCode;
    }

    public QueryServiceException(Throwable cause, IMessageKey.Param1 messageKey, String param1) {
        this(cause, 500, messageKey, param1);
    }

    public QueryServiceException(Throwable cause, int statusCode, IMessageKey.Param1 messageKey, String param1) {
        super(cause, new Message(messageKey, (Object)param1));
        this.statusCode = statusCode;
    }

    public QueryServiceException(IMessageKey.Param2 messageKey, String param1, String param2) {
        this(500, messageKey, param1, param2);
    }

    public QueryServiceException(int statusCode, IMessageKey.Param2 messageKey, String param1, String param2) {
        super(new Message(messageKey, (Object)param1, (Object)param2));
        this.statusCode = statusCode;
    }

    public QueryServiceException(Throwable cause, IMessageKey.Param2 messageKey, String param1, String param2) {
        this(cause, 500, messageKey, param1, param2);
    }

    public QueryServiceException(Throwable cause, int statusCode, IMessageKey.Param2 error, String param1, String param2) {
        super(cause, new Message(error, (Object)param1, (Object)param2));
        this.statusCode = statusCode;
    }

    public Response buildResponse(ServletRequestContext servletRequestContext) {
        this.mCanReceiveDetailedErrors = false;
        HttpServletRequest request = servletRequestContext.getHttpServletRequest();
        if (request != null && !DAASUtils.isDAAS()) {
            UserProfileService userProfileService = new UserProfileService(request);
            try {
                JsonArray jUserCapabilities = userProfileService.getUserCapabilities();
                this.mCanReceiveDetailedErrors = jUserCapabilities.contains((Object)CAN_RECEIVE_DETAILED_ERRORS);
            }
            catch (QueryServiceException ex) {
                QueryServiceLogger.error((Object)ex, "Error getting user capabilities in the data set service.");
            }
        }
        return this.buildResponseInternal(servletRequestContext);
    }

    public Response buildResponseInternal(ServletRequestContext servletRequestContext) {
        return Response.serverError().entity((Object)this.buildError(servletRequestContext).toString()).status(this.statusCode).build();
    }

    public Response buildResponse(ServletRequestContext servletRequestContext, Map<String, String> headers) {
        this.mCanReceiveDetailedErrors = true;
        Response.ResponseBuilder responseBuilder = Response.serverError().entity((Object)this.buildError(servletRequestContext).toString()).status(this.statusCode);
        for (Map.Entry<String, String> header : headers.entrySet()) {
            responseBuilder = responseBuilder.header(header.getKey(), (Object)header.getValue());
        }
        return responseBuilder.build();
    }

    public JSONObject buildError(ServletRequestContext servletRequestContext) {
        Locale locale = this.strToLocale(servletRequestContext.getProductLocale());
        return this.buildError(locale);
    }

    public JSONObject buildError(Locale locale) {
        Throwable cause;
        OrderedJSONObject errors = new OrderedJSONObject();
        JSONArray errorsArray = new JSONArray();
        Object exception = this;
        if (this.getMessageKey() == QueryServiceMessageKeys.INTERNAL_ERROR) {
            exception = new QueryServiceException((Throwable)((Object)this), QueryServiceMessageKeys.REST_INTERNAL_ERROR);
        }
        if ((cause = ((Throwable)exception).getCause()) instanceof XQERuntimeException && this.getMessageKey() == QueryServiceMessageKeys.REST_INTERNAL_ERROR) {
            exception = cause;
        }
        while (exception != null) {
            OrderedJSONObject error = new OrderedJSONObject();
            String message = null;
            message = exception instanceof QueryServiceException ? exception.getLocalizedMessage(locale) : (exception instanceof XQERuntimeException ? ((XQERuntimeException)exception).getLocalizedMessage(locale) : ((Throwable)exception).getLocalizedMessage());
            if (message == null || message.length() == 0) {
                message = ((Throwable)exception).toString();
            }
            String[] splitErrorMessage = new String[]{"", message};
            if ((exception instanceof QueryServiceException || exception instanceof XQERuntimeException) && "".equals((splitErrorMessage = MessageUtil.splitErrorCodeAndMessage((String)message))[0])) {
                splitErrorMessage = QueryServiceException.splitErrorCodeAndMessage(message);
            }
            ExceptionUtils.putJSONObjectProperty((JSONObject)error, CODE_NAME, splitErrorMessage[0]);
            ExceptionUtils.putJSONObjectProperty((JSONObject)error, MESSAGE_NAME, splitErrorMessage[1]);
            if (this.mCanReceiveDetailedErrors) {
                ExceptionUtils.putJSONObjectProperty((JSONObject)error, DETAILS_NAME, QueryServiceException.getStackTraceString(locale, (Throwable)exception));
            }
            exception = ((Throwable)exception).getCause();
            errorsArray.add((Object)error);
        }
        ExceptionUtils.putJSONObjectProperty((JSONObject)errors, ERRORS_NAME, errorsArray);
        return errors;
    }

    public static String[] splitErrorCodeAndMessage(String message) {
        Matcher matcher;
        String[] splitMessage = new String[]{"", message};
        if (message != null && (matcher = MESSAGE_PATTERN.matcher(message)).matches()) {
            splitMessage[0] = matcher.group(1);
            splitMessage[1] = matcher.group(2);
        }
        return splitMessage;
    }

    public static String getStackTraceString(Locale locale, Throwable throwable) {
        String stackTrace;
        if (null != throwable) {
            if (throwable instanceof QueryServiceException) {
                ((QueryServiceException)((Object)throwable)).setLocale(locale);
            } else if (throwable instanceof XQERuntimeException) {
                ((XQERuntimeException)throwable).setLocale(locale);
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            stackTrace = stringWriter.toString();
            printWriter.close();
            try {
                stringWriter.close();
            }
            catch (IOException e) {
                QueryServiceLogger.error(e, "IO error getting stack trace in the data set service.");
            }
        } else {
            stackTrace = "";
        }
        return stackTrace;
    }

    public static QueryServiceException wrap(Throwable e) {
        if (e instanceof QueryServiceException) {
            return (QueryServiceException)((Object)e);
        }
        if (e instanceof AmbiguousConnectionException) {
            return new AmbiguousConnectionExceptionQS((AmbiguousConnectionException)e);
        }
        if (e instanceof AmbiguousSignonException) {
            return new AmbiguousSignonExceptionQS((AmbiguousSignonException)e);
        }
        if (e instanceof LogonFailureException) {
            return new LogonFailureExceptionQS((LogonFailureException)e);
        }
        return new QueryServiceException(e, QueryServiceMessageKeys.REST_INTERNAL_ERROR);
    }

    public static QueryServiceException getDataSourceException(XQERuntimeException ex) {
        if (ex instanceof AmbiguousConnectionException) {
            return new AmbiguousConnectionExceptionQS((AmbiguousConnectionException)ex);
        }
        if (ex instanceof AmbiguousSignonException) {
            return new AmbiguousSignonExceptionQS((AmbiguousSignonException)ex);
        }
        if (ex instanceof LogonFailureException) {
            return new LogonFailureExceptionQS((LogonFailureException)ex);
        }
        return null;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    private Locale strToLocale(String localeStr) {
        Locale locale = LocaleConverter.strToLocale((String)localeStr);
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        return locale;
    }

    public String getLocalizedMessage() {
        if (this.locale == null) {
            return super.getLocalizedMessage();
        }
        return super.getLocalizedMessage(this.locale);
    }

    private void setLocale(Locale locale) {
        this.locale = locale;
    }
}

