/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.common.service.local;

import javax.enterprise.inject.Produces;
import javax.inject.Named;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalConfigProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalConfigProvider.class);
    static final String PRELOADED_DATASETS_ENABLED = "gemini/dss/includePreloadedDatasets";
    private final Context namingContext;

    LocalConfigProvider() throws NamingException {
        this(new InitialContext());
    }

    LocalConfigProvider(Context namingContext) {
        this.namingContext = namingContext;
    }

    @Produces
    @Named(value="gemini/dss/includePreloadedDatasets")
    boolean arePreloadedDatasetsEnabled() {
        String propValue = this.getProperty(PRELOADED_DATASETS_ENABLED);
        return Boolean.valueOf(propValue);
    }

    private String getProperty(String propertyName) {
        String value = null;
        try {
            Object rawValue = this.namingContext.lookup(propertyName);
            if (rawValue != null) {
                value = String.valueOf(rawValue);
            }
        }
        catch (NamingException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            LOGGER.debug("Unable to find configuration value: '{}'", (Object)propertyName);
        }
        return value;
    }
}

