/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.common.services;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

public class UriBuilder {
    private static final String DEF_SERVICE_ROOT = "/bi/v1/";
    private static final String PARAM_BEGIN = "('";
    private static final String PUSH = "(";
    private static final String POP = ")";
    private static final String PARAM_END = "')";
    private static final String SLASH = "/";
    private static final String COMMA = ",";
    private static final String AMPERSAND = "&";
    private static final String QUESTION_MARK = "?";
    private static final char EQUAL_SIGN = '=';
    private static final String SEMICOLON = ";";
    private final String mServiceRoot;
    private final StringBuilder mBuffer;
    private final Map<String, Deque<Boolean>> mPipes;
    private Boolean mAddEntitySeparator = false;
    private Boolean mQueryOptions = false;
    private int mNestedOptions = 0;
    private Boolean mAddSeparator = false;

    protected UriBuilder() {
        this(DEF_SERVICE_ROOT);
    }

    protected UriBuilder(String serviceRoot) {
        this.mServiceRoot = serviceRoot;
        this.mBuffer = new StringBuilder(this.mServiceRoot);
        this.mPipes = new HashMap<String, Deque<Boolean>>();
        this.initPipes();
    }

    private void initPipes() {
        this.mPipes.forEach((k, v) -> {
            v.clear();
            v.push(false);
        });
    }

    public UriBuilder entity(String entity) {
        this.appendEntitySeparator();
        this.mBuffer.append(entity);
        return this;
    }

    public UriBuilder entityId(String entity, String id) {
        this.appendEntitySeparator();
        String decodedId = StringEscapeUtils.unescapeXml((String)id);
        this.mBuffer.append(entity).append(PARAM_BEGIN).append(decodedId).append(PARAM_END);
        return this;
    }

    public UriBuilder entityId(String entity, long id) {
        this.appendEntitySeparator();
        this.mBuffer.append(entity).append(PUSH).append(id).append(POP);
        return this;
    }

    public UriBuilder option(String option, String ... properties) {
        Deque<Boolean> pipe = this.getPipe(option);
        this.appendQueryOption(pipe.peekFirst());
        if (!pipe.peekFirst().booleanValue()) {
            this.mBuffer.append(option).append('=');
            pipe.removeFirst();
            pipe.addFirst(true);
        }
        this.mBuffer.append(String.join((CharSequence)COMMA, properties));
        return this;
    }

    public UriBuilder reset() {
        this.mQueryOptions = false;
        this.mAddEntitySeparator = false;
        this.mNestedOptions = 0;
        this.mAddSeparator = false;
        this.mPipes.clear();
        this.mBuffer.setLength(0);
        this.mBuffer.append(this.mServiceRoot);
        return this;
    }

    public String toString() {
        return this.mBuffer.toString();
    }

    private UriBuilder appendEntitySeparator() {
        if (this.mAddEntitySeparator.booleanValue()) {
            this.mBuffer.append(SLASH);
        } else {
            this.mAddEntitySeparator = true;
        }
        return this;
    }

    private UriBuilder appendQueryOption(boolean pipe) {
        if (this.mQueryOptions.booleanValue()) {
            if (this.mNestedOptions > 0) {
                if (this.mAddSeparator.booleanValue()) {
                    if (pipe) {
                        this.mBuffer.append(COMMA);
                    } else {
                        this.mBuffer.append(SEMICOLON);
                    }
                } else {
                    this.mAddSeparator = true;
                }
            } else if (pipe) {
                this.mBuffer.append(COMMA);
            } else {
                this.mBuffer.append(AMPERSAND);
            }
            return this;
        }
        this.mQueryOptions = true;
        this.mBuffer.append(QUESTION_MARK);
        return this;
    }

    private Deque<Boolean> getPipe(String option) {
        Deque<Boolean> pipe = this.mPipes.get(option);
        if (null == pipe) {
            pipe = new ArrayDeque<Boolean>();
            pipe.add(false);
        }
        return pipe;
    }
}

