/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.common.services;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.qs.common.QueryServiceLogger;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.common.services.UriBuilder;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;

public class UserProfileService {
    private final HttpServletRequest mRequest;

    public UserProfileService(HttpServletRequest request) {
        this.mRequest = request;
    }

    public JsonArray getUserCapabilities() {
        UriBuilder uriBuilder = new UriBuilder();
        uriBuilder.entity("users").entity("~").entity("capabilities");
        JsonObject juserCapabilities = this.executeGetRequest(uriBuilder.toString());
        if (juserCapabilities == null) {
            return new JsonArray();
        }
        return (JsonArray)juserCapabilities.get("userCapabilities");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject executeGetRequest(String uri) {
        JsonObject result = null;
        RESTClient client = null;
        try {
            client = RESTClientFactory.getInstance().getClient(this.mRequest);
            result = client.getResource(uri, "application/json");
            return result;
        }
        catch (Exception e) {
            throw QueryServiceException.wrap(e);
        }
        finally {
            if (client != null) {
                try {
                    try {
                        client.close();
                        client = null;
                    }
                    catch (IOException e) {
                        QueryServiceLogger.error(e, "IO Error getting user capabilities in the data set service.");
                        client = null;
                    }
                }
                catch (Throwable throwable) {
                    client = null;
                    throw throwable;
                }
            }
        }
    }
}

