/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.common.util;

import java.sql.Time;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

public final class DataFormatUtils {
    private static final DateFormat ISO8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat ISO8601_TIME_FORMAT = new SimpleDateFormat("HH:mm:ss'Z'");
    private static final DateFormat ISO8601_DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final DatatypeFactory DATATYPE_FACTORY;

    private DataFormatUtils() {
    }

    public static String toISO8601Date(Date date) {
        if (date instanceof java.sql.Date) {
            return ISO8601_DATE_FORMAT.format(date);
        }
        if (date instanceof Time) {
            return ISO8601_TIME_FORMAT.format(date);
        }
        return ISO8601_DATETIME_FORMAT.format(date);
    }

    public static Date fromISO8601Date(String dateString) {
        return DATATYPE_FACTORY.newXMLGregorianCalendar(dateString).toGregorianCalendar().getTime();
    }

    static {
        TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
        ISO8601_DATE_FORMAT.setTimeZone(utcTimeZone);
        ISO8601_TIME_FORMAT.setTimeZone(utcTimeZone);
        ISO8601_DATETIME_FORMAT.setTimeZone(utcTimeZone);
        try {
            DATATYPE_FACTORY = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

