/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.expressions.v5.bin;

import com.ibm.bi.platform.moser.expressions.v5.util.BinExpressionUtil;
import com.ibm.bi.platform.moser.expressions.v5.util.ExpressionUtil;
import com.ibm.bi.platform.moser.expressions.v5.util.FormatSymbols;
import java.util.ArrayList;
import java.util.List;

public class EqualDistributionBinsExpression {
    private static final String VARCHAR_20 = "varchar(20)";
    private final String expressionLocale;
    private final String identifier;
    private final String binIdentifier;
    private final int numberOfBins;
    private final String[] autoLabels;
    private final String[] customLabels;
    private final int maxDecimalPlaces;
    private final String decimal;
    private String minimum;
    private String maximum;
    private String width;
    private boolean isInteger = false;

    public EqualDistributionBinsExpression(String identifier, String binIdentifier, int numberOfBins, String[] autoLabels, String[] customLabels, int maxDecimalPlaces, String locale) {
        this.expressionLocale = locale;
        this.identifier = identifier;
        this.binIdentifier = binIdentifier;
        this.numberOfBins = numberOfBins;
        this.autoLabels = autoLabels;
        this.customLabels = customLabels;
        this.maxDecimalPlaces = maxDecimalPlaces;
        this.decimal = "decimal(15" + FormatSymbols.getListSeparator(this.expressionLocale) + " " + maxDecimalPlaces + ")";
        this.minimum = ExpressionUtil.minimumForReport(identifier);
        this.maximum = ExpressionUtil.maximumForReport(identifier);
        this.width = this.binWidthExpression();
    }

    public String binNumberExpression() {
        StringBuilder condition1 = new StringBuilder(this.identifier);
        condition1.append(" >= ");
        condition1.append(this.maximum);
        String elseExp = BinExpressionUtil.widthBucket(this.identifier, this.minimum, this.maximum, this.numberOfBins, this.expressionLocale);
        String expNoMinMaxCheck = ExpressionUtil.ifThenElse(condition1.toString(), ExpressionUtil.getLiteral(this.numberOfBins), elseExp);
        StringBuilder condition2 = new StringBuilder(this.minimum);
        condition2.append(" = ");
        condition2.append(this.maximum);
        return ExpressionUtil.ifThenElse(condition2.toString(), ExpressionUtil.getLiteral(-1), expNoMinMaxCheck);
    }

    public List<String> binLimits(double min, double max) {
        ArrayList<String> limits = new ArrayList<String>();
        for (Double value : this.rawBinLimits(min, max)) {
            limits.add(BinExpressionUtil.formatDouble(value, 10));
        }
        return limits;
    }

    private List<Double> rawBinLimits(double min, double max) {
        double increment = (max - min) / (double)this.numberOfBins;
        ArrayList<Double> limits = new ArrayList<Double>();
        for (int i = this.numberOfBins - 1; i > 0; --i) {
            limits.add(min + increment * (double)i);
        }
        return limits;
    }

    public List<String> binLabels(double min, double max) {
        Double value = null;
        ArrayList<String> labels = new ArrayList<String>();
        for (Double previousValue : this.rawBinLimits(min, max)) {
            labels.add(this.generateLimitBinLabel(previousValue, value));
            value = previousValue;
        }
        labels.add(this.generateLimitBinLabel(null, value));
        return labels;
    }

    private String generateLimitBinLabel(Double previousValue, Double value) {
        StringBuilder result = new StringBuilder();
        if (previousValue == null) {
            result.append(this.autoLabels[0]);
        } else {
            result.append(BinExpressionUtil.formatDouble(previousValue, this.maxDecimalPlaces));
        }
        result.append(" ");
        if (value == null) {
            result.append(this.autoLabels[1]);
        } else {
            if (previousValue != null) {
                result.append(this.autoLabels[3]);
                result.append(" ");
            }
            result.append(BinExpressionUtil.formatDouble(value, this.maxDecimalPlaces));
        }
        return result.toString();
    }

    public String binLabelExpression() {
        String[] expressions = this.numberOfBins <= 2 ? new String[4] : new String[5];
        expressions[0] = this.autoBinNoBucket();
        expressions[1] = this.autoBinFirstBucket();
        expressions[2] = this.autoBinLastBucket();
        if (this.numberOfBins <= 2) {
            expressions[3] = ExpressionUtil.elseExp(ExpressionUtil.getLiteral(this.getNullLabel()));
        } else {
            expressions[3] = ExpressionUtil.whenThen(ExpressionUtil.isNull(this.binIdentifier), ExpressionUtil.getLiteral(this.getNullLabel()));
            expressions[4] = this.autoBinMiddleBuckets();
        }
        return ExpressionUtil.assembleCase(expressions);
    }

    public String binWidthExpression() {
        StringBuilder result = new StringBuilder("( ");
        result.append(this.maximum);
        result.append(" - ");
        result.append(this.minimum);
        result.append(" ) / ");
        result.append(this.numberOfBins);
        return result.toString();
    }

    public void setIsInteger(boolean isInteger) {
        this.isInteger = isInteger;
    }

    private String autoBinFirstBucket() {
        StringBuilder condition = new StringBuilder(this.binIdentifier);
        condition.append(" = 0 or ");
        condition.append(this.binIdentifier);
        condition.append(" = 1");
        StringBuilder thenValue = new StringBuilder("'");
        if (this.customLabels != null && this.customLabels[1] != null) {
            thenValue.append(ExpressionUtil.escapeStringLiteral(this.customLabels[1]));
            thenValue.append("'");
        } else {
            thenValue.append(ExpressionUtil.escapeStringLiteral(this.autoLabels[0]));
            thenValue.append(" ' || ");
            StringBuilder firstBucketEnd = new StringBuilder(this.minimum);
            firstBucketEnd.append(" + ");
            firstBucketEnd.append(this.width);
            thenValue.append(this.castToDecimalThenVarchar(firstBucketEnd.toString()));
        }
        return ExpressionUtil.whenThen(condition.toString(), thenValue.toString());
    }

    private String castToDecimalThenVarchar(String value) {
        String result = value;
        if (this.isInteger) {
            result = ExpressionUtil.ceil(result);
        }
        return ExpressionUtil.cast(ExpressionUtil.cast(result, this.decimal, this.expressionLocale), VARCHAR_20, this.expressionLocale);
    }

    private String autoBinLastBucket() {
        StringBuilder condition = new StringBuilder(this.binIdentifier);
        condition.append(" >= ");
        condition.append(this.numberOfBins);
        StringBuilder thenValue = new StringBuilder();
        if (this.customLabels != null && this.customLabels[this.numberOfBins] != null) {
            thenValue.append(ExpressionUtil.getLiteral(ExpressionUtil.escapeStringLiteral(this.customLabels[this.numberOfBins])));
        } else {
            StringBuilder lastBucketEnd = new StringBuilder(this.minimum);
            lastBucketEnd.append(" + ");
            lastBucketEnd.append(this.numberOfBins - 1);
            lastBucketEnd.append(" * ");
            lastBucketEnd.append(this.width);
            thenValue.append(this.castToDecimalThenVarchar(lastBucketEnd.toString()));
            thenValue.append(" || ' ");
            thenValue.append(ExpressionUtil.escapeStringLiteral(this.autoLabels[1]));
            thenValue.append("'");
        }
        return ExpressionUtil.whenThen(condition.toString(), thenValue.toString());
    }

    private String getNullLabel() {
        if (this.customLabels != null && this.customLabels[0] != null) {
            return ExpressionUtil.escapeStringLiteral(this.customLabels[0]);
        }
        return ExpressionUtil.escapeStringLiteral(this.autoLabels[2]);
    }

    private String autoBinMiddleBuckets() {
        StringBuilder result = new StringBuilder();
        boolean allCustomLabels = false;
        boolean first = true;
        if (this.customLabels != null && this.customLabels.length > 3) {
            allCustomLabels = true;
            for (int i = 2; i < this.customLabels.length - 1; ++i) {
                if (this.customLabels[i] != null) {
                    if (first) {
                        first = false;
                    } else {
                        result.append("\r\n    ");
                    }
                    result.append(BinExpressionUtil.binLabelExpression(this.binIdentifier, i, this.customLabels[i]));
                    continue;
                }
                allCustomLabels = false;
            }
        }
        if (!allCustomLabels) {
            if (!first) {
                result.append("\r\n    ");
            }
            StringBuilder bucketStart = new StringBuilder(this.minimum);
            bucketStart.append(" + ( ");
            bucketStart.append(this.binIdentifier);
            bucketStart.append(" - 1 ) * ");
            bucketStart.append(this.width);
            StringBuilder bucketEnd = new StringBuilder(this.minimum);
            bucketEnd.append(" + ");
            bucketEnd.append(this.binIdentifier);
            bucketEnd.append(" * ");
            bucketEnd.append(this.width);
            StringBuilder elseExp = new StringBuilder(this.castToDecimalThenVarchar(bucketStart.toString()));
            elseExp.append(" || ' ");
            elseExp.append(ExpressionUtil.escapeStringLiteral(this.autoLabels[3]));
            elseExp.append(" ' || ");
            elseExp.append(this.castToDecimalThenVarchar(bucketEnd.toString()));
            result.append(ExpressionUtil.elseExp(elseExp.toString()));
        }
        return result.toString();
    }

    public void setForScope(List<String> aForScope, String aggregate) {
        this.maximum = ExpressionUtil.maximumForScope(this.identifier, aForScope, aggregate, this.expressionLocale);
        this.minimum = ExpressionUtil.minimumForScope(this.identifier, aForScope, aggregate, this.expressionLocale);
        this.width = this.binWidthExpression();
    }

    private String autoBinNoBucket() {
        StringBuilder condition = new StringBuilder(this.binIdentifier);
        condition.append(" = -1");
        StringBuilder thenValue = new StringBuilder(this.castToDecimalThenVarchar(this.minimum));
        return ExpressionUtil.whenThen(condition.toString(), thenValue.toString());
    }
}

