/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.expressions.v5.bin;

import com.ibm.bi.platform.moser.expressions.v5.bin.EqualDistributionBinsExpression;
import com.ibm.bi.platform.moser.expressions.v5.util.BinExpressionUtil;
import com.ibm.bi.platform.moser.expressions.v5.util.ExpressionUtil;
import com.ibm.bi.platform.moser.expressions.v5.util.FormatSymbols;
import java.util.ArrayList;
import java.util.List;

public class IntegerEqualDistributionBinExpression {
    private static final String VARCHAR_20 = "varchar(20)";
    private final String decimal15;
    private final String expressionLocale;
    private final String identifier;
    private final String binIdentifier;
    private final int numberOfBins;
    private final String[] autoLabels;
    private final String[] customLabels;
    private final String minimum;
    private final String maximum;
    private final String newMinimum;
    private final String newMaximum;
    private final EqualDistributionBinsExpression equalDistributionBinExpression;

    public IntegerEqualDistributionBinExpression(String identifier, String binIdentifier, int numberOfBins, String[] autoLabels, String[] customLabels, String locale) {
        this.expressionLocale = locale;
        this.decimal15 = "decimal(15" + FormatSymbols.getListSeparator(this.expressionLocale) + " 0)";
        this.identifier = identifier;
        this.binIdentifier = binIdentifier;
        this.numberOfBins = numberOfBins;
        this.autoLabels = autoLabels;
        this.customLabels = customLabels;
        this.minimum = ExpressionUtil.minimumForReport(identifier);
        this.maximum = ExpressionUtil.maximumForReport(identifier);
        this.newMinimum = this.newMinimum();
        this.newMaximum = this.newMaximum();
        this.equalDistributionBinExpression = new EqualDistributionBinsExpression(identifier, binIdentifier, numberOfBins, autoLabels, customLabels, 0, locale);
        this.equalDistributionBinExpression.setIsInteger(true);
    }

    public String binNumberExpression() {
        StringBuilder condition = new StringBuilder(this.maximum);
        condition.append(" - ");
        condition.append(this.minimum);
        condition.append(" < ");
        condition.append(this.numberOfBins);
        return ExpressionUtil.ifThenElse(condition.toString(), this.binNumberThen(), this.binNumberElse());
    }

    public List<String> binLimits(int min, int max) {
        ArrayList<String> limits = new ArrayList<String>();
        for (Double value : this.rawBinLimits(min, max)) {
            limits.add(BinExpressionUtil.formatDouble(value, 0));
        }
        return limits;
    }

    private List<Double> rawBinLimits(int min, int max) {
        int maxValue = max;
        int minValue = min;
        if (maxValue - minValue < this.numberOfBins) {
            minValue -= (int)Math.floor((double)(this.numberOfBins - max + min) / 2.0);
            maxValue += (int)Math.ceil((double)(this.numberOfBins - max + min) / 2.0);
        }
        double increment = (double)(maxValue - minValue) / (double)this.numberOfBins;
        ArrayList<Double> limits = new ArrayList<Double>();
        for (int i = this.numberOfBins - 1; i > 0; --i) {
            limits.add(Math.ceil((double)minValue + (double)i * increment));
        }
        return limits;
    }

    public List<String> binLabels(int min, int max) {
        Double value = null;
        ArrayList<String> labels = new ArrayList<String>();
        for (Double previousValue : this.rawBinLimits(min, max)) {
            labels.add(this.generateLimitBinLabel(previousValue, value));
            value = previousValue;
        }
        labels.add(this.generateLimitBinLabel(null, value));
        return labels;
    }

    private String generateLimitBinLabel(Double previousValue, Double value) {
        StringBuilder result = new StringBuilder();
        if (previousValue == null) {
            result.append(this.autoLabels[0]);
        } else {
            result.append(BinExpressionUtil.formatDouble(previousValue, 0));
        }
        result.append(" ");
        if (value == null) {
            result.append(this.autoLabels[1]);
        } else {
            if (previousValue != null) {
                result.append(this.autoLabels[3]);
                result.append(" ");
            }
            result.append(BinExpressionUtil.formatDouble(value, 0));
        }
        return result.toString();
    }

    private String binNumberThen() {
        StringBuilder condition = new StringBuilder(this.identifier);
        condition.append(" >= ");
        condition.append(this.newMaximum);
        String elseExp = BinExpressionUtil.widthBucket(this.identifier, this.newMinimum, this.newMaximum, this.numberOfBins, this.expressionLocale);
        return ExpressionUtil.nest(ExpressionUtil.ifThenElse(condition.toString(), ExpressionUtil.getLiteral(this.numberOfBins), elseExp));
    }

    private String binNumberElse() {
        return ExpressionUtil.nest(this.equalDistributionBinExpression.binNumberExpression());
    }

    public String binLabelExpression() {
        if (this.allCustomLabels()) {
            return this.equalDistributionBinExpression.binLabelExpression();
        }
        StringBuilder condition = new StringBuilder(this.maximum);
        condition.append(" - ");
        condition.append(this.minimum);
        condition.append(" < ");
        condition.append(this.numberOfBins);
        return ExpressionUtil.ifThenElse(condition.toString(), this.binLabelThen(), this.binLabelElse());
    }

    private boolean allCustomLabels() {
        if (this.customLabels == null) {
            return false;
        }
        for (int i = 1; i < this.customLabels.length; ++i) {
            if (this.customLabels[i] != null) continue;
            return false;
        }
        return true;
    }

    private String binLabelThen() {
        String[] expressions = this.numberOfBins <= 2 ? new String[3] : new String[4];
        expressions[0] = this.autoBinFirstBucket();
        expressions[1] = this.autoBinLastBucket();
        if (this.numberOfBins <= 2) {
            expressions[2] = ExpressionUtil.elseExp(ExpressionUtil.getLiteral(this.getNullLabel()));
        } else {
            expressions[2] = ExpressionUtil.whenThen(ExpressionUtil.isNull(this.binIdentifier), ExpressionUtil.getLiteral(this.getNullLabel()));
            expressions[3] = this.autoBinMiddleBuckets();
        }
        return ExpressionUtil.nest(ExpressionUtil.assembleCase(expressions));
    }

    private String binLabelElse() {
        return ExpressionUtil.nest(this.equalDistributionBinExpression.binLabelExpression());
    }

    private String newMinimum() {
        StringBuilder expression = new StringBuilder(this.minimum);
        expression.append(" - ");
        expression.append(ExpressionUtil.floor(this.spillOver()));
        return expression.toString();
    }

    private String newMaximum() {
        StringBuilder expression = new StringBuilder(this.maximum);
        expression.append(" + ");
        expression.append(ExpressionUtil.ceil(this.spillOver()));
        return expression.toString();
    }

    private String spillOver() {
        StringBuilder expression = new StringBuilder("( ");
        expression.append(this.numberOfBins);
        expression.append(" - ");
        expression.append(this.maximum);
        expression.append(" + ");
        expression.append(this.minimum);
        expression.append(" ) / 2");
        return expression.toString();
    }

    private String autoBinFirstBucket() {
        StringBuilder condition = new StringBuilder(this.binIdentifier);
        condition.append(" <= 1");
        StringBuilder thenValue = new StringBuilder("'");
        if (this.customLabels != null && this.customLabels[1] != null) {
            thenValue.append(ExpressionUtil.escapeStringLiteral(this.customLabels[1]));
            thenValue.append("'");
        } else {
            thenValue.append(ExpressionUtil.escapeStringLiteral(this.autoLabels[0]));
            thenValue.append(" ' || ");
            StringBuilder firstBucketEnd = new StringBuilder(this.newMinimum);
            firstBucketEnd.append(" + 1");
            thenValue.append(this.castToDecimalThenVarchar(firstBucketEnd.toString()));
        }
        return ExpressionUtil.whenThen(condition.toString(), thenValue.toString());
    }

    private String castToDecimalThenVarchar(String value) {
        return ExpressionUtil.cast(ExpressionUtil.cast(value, this.decimal15, this.expressionLocale), VARCHAR_20, this.expressionLocale);
    }

    private String autoBinLastBucket() {
        StringBuilder condition = new StringBuilder(this.binIdentifier);
        condition.append(" >= ");
        condition.append(this.numberOfBins);
        StringBuilder thenValue = new StringBuilder();
        if (this.customLabels != null && this.customLabels[this.numberOfBins] != null) {
            thenValue.append(ExpressionUtil.getLiteral(ExpressionUtil.escapeStringLiteral(this.customLabels[this.numberOfBins])));
        } else {
            StringBuilder lastBucketEnd = new StringBuilder(this.newMaximum);
            lastBucketEnd.append(" - 1");
            thenValue.append(this.castToDecimalThenVarchar(lastBucketEnd.toString()));
            thenValue.append(" || ' ");
            thenValue.append(ExpressionUtil.escapeStringLiteral(this.autoLabels[1]));
            thenValue.append("'");
        }
        return ExpressionUtil.whenThen(condition.toString(), thenValue.toString());
    }

    private String getNullLabel() {
        if (this.customLabels != null && this.customLabels[0] != null) {
            return ExpressionUtil.escapeStringLiteral(this.customLabels[0]);
        }
        return ExpressionUtil.escapeStringLiteral(this.autoLabels[2]);
    }

    private String autoBinMiddleBuckets() {
        StringBuilder result = new StringBuilder();
        boolean allCustomLabels = false;
        boolean first = true;
        if (this.customLabels != null && this.customLabels.length > 3) {
            allCustomLabels = true;
            for (int i = 2; i < this.customLabels.length - 1; ++i) {
                if (this.customLabels[i] != null) {
                    if (first) {
                        first = false;
                    } else {
                        result.append("\r\n    ");
                    }
                    result.append(BinExpressionUtil.binLabelExpression(this.binIdentifier, i, this.customLabels[i]));
                    continue;
                }
                allCustomLabels = false;
            }
        }
        if (!allCustomLabels) {
            if (!first) {
                result.append("\r\n    ");
            }
            StringBuilder bucketStart = new StringBuilder(this.binIdentifier);
            bucketStart.append(" + ");
            bucketStart.append(this.newMinimum);
            bucketStart.append(" - 1");
            StringBuilder bucketEnd = new StringBuilder(this.binIdentifier);
            bucketEnd.append(" + ");
            bucketEnd.append(this.newMinimum);
            StringBuilder elseExp = new StringBuilder(this.castToDecimalThenVarchar(bucketStart.toString()));
            elseExp.append(" || ' ");
            elseExp.append(ExpressionUtil.escapeStringLiteral(this.autoLabels[3]));
            elseExp.append(" ' || ");
            elseExp.append(this.castToDecimalThenVarchar(bucketEnd.toString()));
            result.append(ExpressionUtil.elseExp(elseExp.toString()));
        }
        return result.toString();
    }
}

