/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.expressions.v5.bin;

import com.ibm.bi.platform.moser.expressions.v5.util.BinExpressionUtil;
import com.ibm.bi.platform.moser.expressions.v5.util.ExpressionUtil;

public class ManualBinExpression {
    private final String expressionLocale;
    private final String identifier;
    private final String binIdentifier;
    private final String[][] bins;

    public ManualBinExpression(String identifier, String binIdentifier, String[][] bins, String locale) {
        this.expressionLocale = locale;
        this.identifier = identifier;
        this.binIdentifier = binIdentifier;
        this.bins = bins;
    }

    public String binNumberExpression() {
        String[] expressions = new String[this.bins.length];
        for (int i = 0; i < this.bins.length; ++i) {
            if (this.bins[i].length != 1) {
                String[] inValues = ManualBinExpression.getInValues(this.bins[i]);
                expressions[i] = ExpressionUtil.whenInThen(this.identifier, inValues, ExpressionUtil.getLiteral(i + 1), this.expressionLocale);
                continue;
            }
            expressions[i] = ExpressionUtil.elseExp(ExpressionUtil.getLiteral(i));
        }
        return ExpressionUtil.assembleCase(expressions);
    }

    public String binLabelExpression() {
        return BinExpressionUtil.binLabel(this.bins, this.binIdentifier);
    }

    private static String[] getInValues(String[] inValues) {
        String[] result = new String[inValues.length - 1];
        for (int i = 1; i < inValues.length; ++i) {
            result[i - 1] = inValues[i];
        }
        return result;
    }
}

