/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.expressions.v5.bin;

import com.ibm.bi.platform.moser.expressions.v5.util.BinExpressionUtil;
import com.ibm.bi.platform.moser.expressions.v5.util.ExpressionUtil;

public class PercentageBinExpression {
    private final String identifier;
    private final String binIdentifier;
    private final String[][] ranges;
    private final String percentage;
    private final String minimum;
    private final String maximum;

    public PercentageBinExpression(String identifier, String binIdentifier, String[][] ranges) {
        this.identifier = identifier;
        this.binIdentifier = binIdentifier;
        this.ranges = ranges;
        this.minimum = ExpressionUtil.minimumForReport(identifier);
        this.maximum = ExpressionUtil.maximumForReport(identifier);
        this.percentage = this.percentageExp();
    }

    public String binNumberExpression() {
        String[] expressions = new String[this.ranges.length];
        for (int i = 0; i < this.ranges.length; ++i) {
            expressions[i] = this.rangeNumberExpression(this.ranges[i][1], this.ranges[i][2], i + 1);
        }
        return ExpressionUtil.assembleCase(expressions);
    }

    public String binLabelExpression() {
        return BinExpressionUtil.binLabel(this.ranges, this.binIdentifier);
    }

    private String percentageExp() {
        StringBuilder result = new StringBuilder("( ");
        result.append(this.identifier);
        result.append(" - ");
        result.append(this.minimum);
        result.append(" ) / ( ");
        result.append(this.maximum);
        result.append(" - ");
        result.append(this.minimum);
        result.append(" )");
        return result.toString();
    }

    private String rangeNumberExpression(String from, String to, int binNumber) {
        StringBuilder condition = new StringBuilder(this.percentage);
        if (from != null) {
            condition.append(" >= ");
            condition.append(from);
            if (to != null) {
                condition.append(" and ");
                condition.append(this.percentage);
            }
        }
        if (to != null) {
            condition.append(" < ");
            condition.append(to);
        }
        return ExpressionUtil.whenThen(condition.toString(), ExpressionUtil.getLiteral(binNumber));
    }
}

