/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.expressions.v5.bin;

import com.ibm.bi.platform.moser.expressions.v5.util.BinExpressionUtil;
import com.ibm.bi.platform.moser.expressions.v5.util.ExpressionUtil;

public class PercentileBinExpression {
    private final String identifier;
    private final String binIdentifier;
    private final String[][] ranges;
    private final String percentile;

    public PercentileBinExpression(String identifier, String binIdentifier, String[][] ranges) {
        this.identifier = identifier;
        this.binIdentifier = binIdentifier;
        this.ranges = ranges;
        this.percentile = this.percentileExp();
    }

    public String binNumberExpression() {
        String[] expressions = new String[this.ranges.length];
        for (int i = 0; i < this.ranges.length; ++i) {
            expressions[i] = this.rangeNumberExpression(this.ranges[i][1], this.ranges[i][2], i + 1);
        }
        return ExpressionUtil.assembleCase(expressions);
    }

    public String binLabelExpression() {
        return BinExpressionUtil.binLabel(this.ranges, this.binIdentifier);
    }

    private String percentileExp() {
        StringBuilder result = new StringBuilder("percentile ( ");
        result.append(this.identifier);
        result.append(" for report )");
        return result.toString();
    }

    private String rangeNumberExpression(String from, String to, int binNumber) {
        StringBuilder condition = new StringBuilder(this.percentile);
        if (from != null) {
            condition.append(" >= ");
            condition.append(from);
            if (to != null) {
                condition.append(" and ");
                condition.append(this.percentile);
            }
        }
        if (to != null) {
            condition.append(" < ");
            condition.append(to);
        }
        return ExpressionUtil.whenThen(condition.toString(), ExpressionUtil.getLiteral(binNumber));
    }
}

