/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.expressions.v5.bin;

import com.ibm.bi.platform.moser.expressions.v5.util.BinExpressionUtil;
import com.ibm.bi.platform.moser.expressions.v5.util.ExpressionUtil;

public class StdDevBinExpression {
    private final String identifier;
    private final String binIdentifier;
    private final String[][] ranges;
    private final String mean;
    private final String stdDev;

    public StdDevBinExpression(String identifier, String binIdentifier, String[][] ranges) {
        this.identifier = identifier;
        this.binIdentifier = binIdentifier;
        this.ranges = ranges;
        this.mean = this.meanExp();
        this.stdDev = this.stdDevExp();
    }

    public String binNumberExpression() {
        String[] expressions = new String[this.ranges.length];
        for (int i = 0; i < this.ranges.length; ++i) {
            expressions[i] = this.rangeNumberExpression(this.ranges[i][1], this.ranges[i][2], i + 1);
        }
        return ExpressionUtil.assembleCase(expressions);
    }

    public String binLabelExpression() {
        return BinExpressionUtil.binLabel(this.ranges, this.binIdentifier);
    }

    private String stdDevExp() {
        StringBuilder result = new StringBuilder("standard-deviation ( ");
        result.append(this.identifier);
        result.append(" for report )");
        return result.toString();
    }

    private String meanExp() {
        StringBuilder result = new StringBuilder("mean ( ");
        result.append(this.identifier);
        result.append(" for report )");
        return result.toString();
    }

    private String rangeNumberExpression(String fromSigma, String toSigma, int binNumber) {
        StringBuilder condition = new StringBuilder(this.identifier);
        if (fromSigma != null) {
            condition.append(" >= ");
            condition.append(this.mean);
            condition.append(" + ");
            condition.append(fromSigma);
            condition.append(" * ");
            condition.append(this.stdDev);
            if (toSigma != null) {
                condition.append(" and ");
                condition.append(this.identifier);
            }
        }
        if (toSigma != null) {
            condition.append(" < ");
            condition.append(this.mean);
            condition.append(" + ");
            condition.append(toSigma);
            condition.append(" * ");
            condition.append(this.stdDev);
        }
        return ExpressionUtil.whenThen(condition.toString(), ExpressionUtil.getLiteral(binNumber));
    }
}

