/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.expressions.v5.binning;

import com.ibm.bi.platform.moser.common.generated.metadata.HighLevelDataType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.expressions.v5.util.BinExpressionUtil;
import com.ibm.bi.platform.moser.expressions.v5.util.ExpressionUtil;
import com.ibm.bi.platform.moser.expressions.v5.util.FormatSymbols;
import com.ibm.bi.platform.moser.expressions.v5.util.MacroUtil;
import java.util.ArrayList;
import java.util.List;

public class BinExpression {
    private final QuerySubject querySubject;
    private final QueryItem queryItem;
    private final String identifier;
    private int numberOfBins;
    private int maxDecimalPlaces;
    private final double minValue;
    private final double maxValue;
    private List<String> customLabels;
    private List<String> customRanges;
    private final List<String> defaultLabels;
    private boolean generateNullBin = false;
    private final String expressionLocale;
    private final String minForReport;
    private final String maxForReport;
    private String binWidth;
    private String integerCheck;
    private String spillOver;
    private String virtualMinValue;
    private String virtualMaxValue;

    public BinExpression(QuerySubject querySubject, QueryItem queryItem, int numberOfBins, int maxDecimalPlaces, double minValue, double maxValue, List<String> customLabels, List<String> customRange, List<String> defaultLabels, boolean generateNullBin, String expressionLocale) {
        this.querySubject = querySubject;
        this.queryItem = queryItem;
        this.identifier = querySubject == null ? queryItem.getIdentifier() : querySubject.getIdentifier() + "." + queryItem.getIdentifier();
        this.numberOfBins = numberOfBins;
        this.maxDecimalPlaces = maxDecimalPlaces;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.customLabels = customLabels;
        this.customRanges = customRange;
        this.defaultLabels = defaultLabels;
        this.generateNullBin = generateNullBin;
        this.expressionLocale = expressionLocale;
        this.minForReport = ExpressionUtil.minimumForReport(this.identifier);
        this.maxForReport = ExpressionUtil.maximumForReport(this.identifier);
        this.init();
    }

    private void init() {
        this.integerCheck = this.integerCheck();
        this.binWidth = this.binWidth();
        this.spillOver = this.spillOver();
        this.virtualMinValue = this.virtualMinValue();
        this.virtualMaxValue = this.virtualMaxValue();
    }

    private String integerCheck() {
        StringBuilder condition = new StringBuilder(this.maxForReport);
        condition.append(" - ");
        condition.append(this.minForReport);
        condition.append(" < ");
        condition.append(this.numberOfBins);
        return condition.toString();
    }

    private String binWidth() {
        StringBuilder result = new StringBuilder("( ");
        result.append(this.maxForReport);
        result.append(" - ");
        result.append(this.minForReport);
        result.append(" ) / ");
        result.append(this.numberOfBins);
        return result.toString();
    }

    private String virtualMinValue() {
        StringBuilder expression = new StringBuilder(this.minForReport);
        expression.append(" - ");
        expression.append(ExpressionUtil.floor(this.spillOver));
        return expression.toString();
    }

    private String virtualMaxValue() {
        StringBuilder expression = new StringBuilder(this.maxForReport);
        expression.append(" + ");
        expression.append(ExpressionUtil.ceil(this.spillOver));
        return expression.toString();
    }

    private String spillOver() {
        StringBuilder expression = new StringBuilder("( ");
        expression.append(this.numberOfBins);
        expression.append(" - ");
        expression.append(this.maxForReport);
        expression.append(" + ");
        expression.append(this.minForReport);
        expression.append(" ) / 2");
        return expression.toString();
    }

    public void updateNumberOfBins(int value) {
        this.numberOfBins = value;
        this.customLabels = null;
        this.customRanges = null;
        this.init();
    }

    public void updateMaxDecimalPlaces(int value) {
        this.maxDecimalPlaces = value;
    }

    public void updateCustomLabels(List<String> labels) {
        this.customLabels = labels;
    }

    public void updateCustomRanges(List<String> ranges) {
        this.customRanges = ranges;
    }

    public void updateGenerateNullBin(boolean value) {
        this.generateNullBin = value;
    }

    public String getBinNumberExpression() {
        if (this.isCustomRanges()) {
            return this.getBinNumberExpressionCustomRanges();
        }
        if (HighLevelDataType.INTEGER.equals((Object)this.queryItem.getHighlevelDatatype())) {
            return this.getBinNumberExpressionInteger();
        }
        return this.getBinNumberExpressionDecimal();
    }

    private boolean isCustomRanges() {
        if (this.customRanges == null) {
            return false;
        }
        for (String customRange : this.customRanges) {
            if (customRange == null) continue;
            return true;
        }
        return false;
    }

    public String getLabelExpression(String id) {
        if (this.isCustomRanges()) {
            return this.getLabelCustomRanges(id);
        }
        int numExtraCustomLabels = this.countExtraCustomLabels();
        ArrayList<String> expressions = new ArrayList<String>();
        expressions.add(this.whenThenBinLow(id));
        if (numExtraCustomLabels > 0) {
            this.whenThenCustomBins(id, expressions);
        }
        if (numExtraCustomLabels < this.numberOfBins - 2) {
            expressions.add(this.whenThenBinMiddle(id));
        }
        expressions.add(this.whenThenBinHigh(id));
        expressions.add(this.whenThenBinEdge(id));
        if (this.generateNullBin) {
            String nullLabel = this.customLabels != null && this.customLabels.get(0) != null ? this.customLabels.get(0) : null;
            nullLabel = nullLabel == null ? MacroUtil.macro(MacroUtil.macroAsString(BinExpression.binNull(this.expressionLocale))) : ExpressionUtil.getLiteral(nullLabel);
            expressions.add(ExpressionUtil.elseExp(nullLabel));
        }
        return ExpressionUtil.assembleCase(BinExpression.toArray(expressions));
    }

    private String getLabelCustomRanges(String binIdentifier) {
        ArrayList<String> expressions = new ArrayList<String>();
        expressions.add(this.whenThenBinLow(binIdentifier));
        for (int i = 2; i < this.numberOfBins; ++i) {
            expressions.add(this.whenThenBinMiddleCustomRanges(binIdentifier, i));
        }
        expressions.add(this.whenThenBinHigh(binIdentifier));
        expressions.add(this.whenThenBinEdge(binIdentifier));
        if (this.generateNullBin) {
            String nullLabel = this.customLabels != null && this.customLabels.get(0) != null ? this.customLabels.get(0) : null;
            nullLabel = nullLabel == null ? MacroUtil.macro(MacroUtil.macroAsString(BinExpression.binNull(this.expressionLocale))) : ExpressionUtil.getLiteral(nullLabel);
            expressions.add(ExpressionUtil.elseExp(nullLabel));
        }
        return ExpressionUtil.assembleCase(BinExpression.toArray(expressions));
    }

    private int countExtraCustomLabels() {
        if (this.customLabels == null) {
            return 0;
        }
        int count = 0;
        for (int i = 2; i < this.numberOfBins; ++i) {
            if (this.customLabels.get(i) == null) continue;
            ++count;
        }
        return count;
    }

    private void whenThenCustomBins(String binIdentifier, List<String> expressions) {
        for (int binNumber = 2; binNumber < this.numberOfBins; ++binNumber) {
            String customLabel = this.customLabels.get(binNumber);
            if (customLabel == null) continue;
            expressions.add(BinExpression.whenThenBinCustom(binIdentifier, binNumber, customLabel));
        }
    }

    private static String whenThenBinCustom(String binIdentifier, int binNumber, String customLabel) {
        StringBuilder condition = new StringBuilder(binIdentifier);
        condition.append(" = ");
        condition.append(binNumber);
        return ExpressionUtil.whenThen(condition.toString(), ExpressionUtil.getLiteral(customLabel));
    }

    private String whenThenBinMiddle(String binIdentifier) {
        StringBuilder condition = new StringBuilder(binIdentifier);
        condition.append(" > 1 and ");
        condition.append(binIdentifier);
        condition.append(" < ");
        condition.append(this.numberOfBins);
        String binLow = MacroUtil.injectMacro(this.binMiddleLowCalc(binIdentifier));
        String binHigh = MacroUtil.injectMacro(this.binMiddleHighCalc(binIdentifier));
        return ExpressionUtil.whenThen(condition.toString(), this.thenBinMiddle(binLow, binHigh));
    }

    private String whenThenBinMiddleCustomRanges(String binIdentifier, int binNumber) {
        String thenValue;
        StringBuilder condition = new StringBuilder(binIdentifier);
        condition.append(" = ");
        condition.append(binNumber);
        if (this.customLabels != null && this.customLabels.get(binNumber) != null) {
            thenValue = ExpressionUtil.getLiteral(this.customLabels.get(binNumber));
        } else {
            String binLow = this.customRanges.get(binNumber - 1);
            String binHigh = this.customRanges.get(binNumber);
            thenValue = this.thenBinMiddle(binLow, binHigh);
        }
        return ExpressionUtil.whenThen(condition.toString(), thenValue);
    }

    private String thenBinMiddle(String binLow, String binHigh) {
        if (binLow == null) {
            String thenValue = MacroUtil.substitute(ExpressionUtil.getLiteral("%1"), ExpressionUtil.getLiteral(binHigh), BinExpression.binLow(this.expressionLocale), this.expressionLocale);
            thenValue = MacroUtil.macroAsString(thenValue);
            return MacroUtil.macro(thenValue);
        }
        if (binHigh == null) {
            String thenValue = MacroUtil.substitute(ExpressionUtil.getLiteral("%1"), ExpressionUtil.getLiteral(binLow), BinExpression.binHigh(this.expressionLocale), this.expressionLocale);
            thenValue = MacroUtil.macroAsString(thenValue);
            return MacroUtil.macro(thenValue);
        }
        String thenValue = MacroUtil.substitute(ExpressionUtil.getLiteral("%1"), ExpressionUtil.getLiteral(binLow), BinExpression.binMiddle(this.expressionLocale), this.expressionLocale);
        thenValue = MacroUtil.substitute(ExpressionUtil.getLiteral("%2"), ExpressionUtil.getLiteral(binHigh), thenValue, this.expressionLocale);
        thenValue = MacroUtil.macroAsString(thenValue);
        return MacroUtil.macro(thenValue);
    }

    private String binMiddleLowCalc(String binIdentifier) {
        if (HighLevelDataType.INTEGER.equals((Object)this.queryItem.getHighlevelDatatype())) {
            return this.binMiddleLowCalcInteger(binIdentifier);
        }
        StringBuilder bucketStart = new StringBuilder(this.minForReport);
        bucketStart.append(" + ( ");
        bucketStart.append(binIdentifier);
        bucketStart.append(" - 1 ) * ");
        bucketStart.append(this.binWidth);
        return this.castToDecimalThenVarchar(bucketStart.toString());
    }

    private String binMiddleLowCalcInteger(String binIdentifier) {
        StringBuilder bucketStartInteger = new StringBuilder(binIdentifier);
        bucketStartInteger.append(" + ");
        bucketStartInteger.append(this.virtualMinValue);
        bucketStartInteger.append(" - 1");
        StringBuilder bucketStart = new StringBuilder(this.minForReport);
        bucketStart.append(" + ( ");
        bucketStart.append(binIdentifier);
        bucketStart.append(" - 1 ) * ");
        bucketStart.append(this.binWidth);
        return this.castToDecimalThenVarchar(ExpressionUtil.inlineIfThenElse(this.integerCheck, bucketStartInteger.toString(), bucketStart.toString()));
    }

    private String binMiddleHighCalc(String binIdentifier) {
        if (HighLevelDataType.INTEGER.equals((Object)this.queryItem.getHighlevelDatatype())) {
            return this.binMiddleHighCalcInteger(binIdentifier);
        }
        StringBuilder bucketEnd = new StringBuilder(this.minForReport);
        bucketEnd.append(" + ");
        bucketEnd.append(binIdentifier);
        bucketEnd.append(" * ");
        bucketEnd.append(this.binWidth);
        return this.castToDecimalThenVarchar(bucketEnd.toString());
    }

    private String binMiddleHighCalcInteger(String binIdentifier) {
        StringBuilder bucketEndInteger = new StringBuilder(binIdentifier);
        bucketEndInteger.append(" + ");
        bucketEndInteger.append(this.virtualMinValue);
        StringBuilder bucketEnd = new StringBuilder(this.minForReport);
        bucketEnd.append(" + ");
        bucketEnd.append(binIdentifier);
        bucketEnd.append(" * ");
        bucketEnd.append(this.binWidth);
        return this.castToDecimalThenVarchar(ExpressionUtil.inlineIfThenElse(this.integerCheck, bucketEndInteger.toString(), bucketEnd.toString()));
    }

    private String whenThenBinLow(String binIdentifier) {
        String thenValue;
        StringBuilder condition = new StringBuilder(binIdentifier);
        condition.append(" = 1");
        if (this.customLabels != null && this.customLabels.get(1) != null) {
            thenValue = ExpressionUtil.getLiteral(this.customLabels.get(1));
        } else if (this.isCustomRanges()) {
            thenValue = this.thenBinMiddle(this.customRanges.get(0), this.customRanges.get(1));
        } else {
            String binLow = MacroUtil.injectMacro(this.binLowCalc());
            thenValue = MacroUtil.substitute(ExpressionUtil.getLiteral("%1"), ExpressionUtil.getLiteral(binLow), BinExpression.binLow(this.expressionLocale), this.expressionLocale);
            thenValue = MacroUtil.macroAsString(thenValue);
            thenValue = MacroUtil.macro(thenValue);
        }
        return ExpressionUtil.whenThen(condition.toString(), thenValue);
    }

    private String binLowCalc() {
        if (HighLevelDataType.INTEGER.equals((Object)this.queryItem.getHighlevelDatatype())) {
            return this.binLowCalcInteger();
        }
        StringBuilder binLow = new StringBuilder(this.minForReport);
        binLow.append(" + ");
        binLow.append(this.binWidth);
        return this.castToDecimalThenVarchar(binLow.toString());
    }

    private String binLowCalcInteger() {
        StringBuilder binLowInteger = new StringBuilder(this.virtualMinValue);
        binLowInteger.append(" + 1");
        StringBuilder binLow = new StringBuilder(this.minForReport);
        binLow.append(" + ");
        binLow.append(this.binWidth);
        return this.castToDecimalThenVarchar(ExpressionUtil.inlineIfThenElse(this.integerCheck, binLowInteger.toString(), binLow.toString()));
    }

    private String whenThenBinHigh(String binIdentifier) {
        String thenValue;
        StringBuilder condition = new StringBuilder(binIdentifier);
        condition.append(" = ");
        condition.append(this.numberOfBins);
        if (this.customLabels != null && this.customLabels.get(this.numberOfBins) != null) {
            thenValue = ExpressionUtil.getLiteral(this.customLabels.get(this.numberOfBins));
        } else if (this.isCustomRanges()) {
            thenValue = this.thenBinMiddle(this.customRanges.get(this.numberOfBins - 1), this.customRanges.get(this.numberOfBins));
        } else {
            String binHigh = MacroUtil.injectMacro(this.binHighCalc());
            thenValue = MacroUtil.substitute(ExpressionUtil.getLiteral("%1"), ExpressionUtil.getLiteral(binHigh), BinExpression.binHigh(this.expressionLocale), this.expressionLocale);
            thenValue = MacroUtil.macroAsString(thenValue);
            thenValue = MacroUtil.macro(thenValue);
        }
        return ExpressionUtil.whenThen(condition.toString(), thenValue);
    }

    private String binHighCalc() {
        if (HighLevelDataType.INTEGER.equals((Object)this.queryItem.getHighlevelDatatype())) {
            return this.binHighCalcInteger();
        }
        StringBuilder binHigh = new StringBuilder(this.minForReport);
        binHigh.append(" + ");
        binHigh.append(this.numberOfBins - 1);
        binHigh.append(" * ");
        binHigh.append(this.binWidth);
        return this.castToDecimalThenVarchar(binHigh.toString());
    }

    private String binHighCalcInteger() {
        StringBuilder binHighInteger = new StringBuilder(this.virtualMaxValue);
        binHighInteger.append(" - 1");
        StringBuilder binHigh = new StringBuilder(this.minForReport);
        binHigh.append(" + ");
        binHigh.append(this.numberOfBins - 1);
        binHigh.append(" * ");
        binHigh.append(this.binWidth);
        return this.castToDecimalThenVarchar(ExpressionUtil.inlineIfThenElse(this.integerCheck, binHighInteger.toString(), binHigh.toString()));
    }

    private String whenThenBinEdge(String binIdentifier) {
        StringBuilder condition = new StringBuilder(binIdentifier);
        condition.append(" = -1");
        return ExpressionUtil.whenThen(condition.toString(), this.castToDecimalThenVarchar(this.identifier, false));
    }

    private String castToDecimalThenVarchar(String expr) {
        return this.castToDecimalThenVarchar(expr, true);
    }

    private String castToDecimalThenVarchar(String expr, boolean ceil) {
        String result = expr;
        if (ceil && HighLevelDataType.INTEGER.equals((Object)this.queryItem.getHighlevelDatatype())) {
            result = ExpressionUtil.ceil(result);
        }
        int decimalPlaces = HighLevelDataType.INTEGER.equals((Object)this.queryItem.getHighlevelDatatype()) ? 0 : this.maxDecimalPlaces;
        String decimal = "decimal(18" + FormatSymbols.getListSeparator(this.expressionLocale) + " " + decimalPlaces + ")";
        return ExpressionUtil.cast(ExpressionUtil.cast(result, decimal, this.expressionLocale), "varchar(20)", this.expressionLocale);
    }

    public List<String> getRanges() {
        boolean isInteger = HighLevelDataType.INTEGER.equals((Object)this.queryItem.getHighlevelDatatype());
        if (this.isCustomRanges()) {
            return this.getCustomRanges(isInteger);
        }
        ArrayList<String> ranges = new ArrayList<String>();
        for (Double value : isInteger ? this.rawIntegerBinLimits() : this.rawBinLimits()) {
            ranges.add(BinExpressionUtil.formatDouble(value, isInteger ? 0 : this.maxDecimalPlaces));
        }
        return ranges;
    }

    private List<String> getCustomRanges(boolean isInteger) {
        ArrayList<String> ranges = new ArrayList<String>();
        ranges.addAll(this.customRanges);
        if (ranges.get(0) == null) {
            ranges.set(0, this.getCustomLowRange(isInteger));
        }
        if (ranges.get(this.numberOfBins) == null) {
            ranges.set(this.numberOfBins, this.getCustomHighRange(isInteger));
        }
        return ranges;
    }

    private String getCustomLowRange(boolean isInteger) {
        String highValue = this.customRanges.get(2);
        double low = Double.parseDouble(this.customRanges.get(1));
        double high = highValue == null ? this.maxValue : Double.parseDouble(highValue);
        double newMin = low > this.minValue ? this.minValue : low - high + low;
        return BinExpressionUtil.formatDouble(newMin, isInteger ? 0 : this.maxDecimalPlaces);
    }

    private String getCustomHighRange(boolean isInteger) {
        String lowValue = this.customRanges.get(this.numberOfBins - 2);
        double low = lowValue == null ? this.minValue : Double.parseDouble(lowValue);
        double high = Double.parseDouble(this.customRanges.get(this.numberOfBins - 1));
        double newHigh = high < this.maxValue ? this.maxValue : high + high - low;
        return BinExpressionUtil.formatDouble(newHigh, isInteger ? 0 : this.maxDecimalPlaces);
    }

    public List<String> getLabels() {
        boolean isInteger = HighLevelDataType.INTEGER.equals((Object)this.queryItem.getHighlevelDatatype());
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(this.createBinNullLabel());
        if (!this.isCustomRanges() && this.minValue == this.maxValue) {
            String label = BinExpressionUtil.formatDouble(this.minValue, isInteger ? 0 : this.maxDecimalPlaces);
            for (int i = 1; i <= this.numberOfBins; ++i) {
                labels.add(this.customLabels != null && this.customLabels.get(i) != null ? this.customLabels.get(i) : label);
            }
        } else {
            List<String> ranges = this.getRanges();
            for (int i = 1; i <= this.numberOfBins; ++i) {
                if (i == 1) {
                    labels.add(this.createBinLowLabel(ranges));
                    continue;
                }
                if (i == this.numberOfBins) {
                    labels.add(this.createBinHighLabel(ranges));
                    continue;
                }
                labels.add(this.createBinMiddleLabel(ranges, i));
            }
        }
        return labels;
    }

    private String createBinNullLabel() {
        return this.customLabels != null && this.customLabels.get(0) != null ? this.customLabels.get(0) : this.defaultLabels.get(0);
    }

    private String createBinLowLabel(List<String> ranges) {
        if (this.customLabels != null && this.customLabels.get(1) != null) {
            return this.customLabels.get(1);
        }
        if (this.customRanges != null && this.customRanges.get(0) != null) {
            return this.createBinMiddleLabel(ranges, 1);
        }
        String label = this.defaultLabels.get(1);
        return label.replace("%1", ranges.get(1));
    }

    private String createBinHighLabel(List<String> ranges) {
        if (this.customLabels != null && this.customLabels.get(this.numberOfBins) != null) {
            return this.customLabels.get(this.numberOfBins);
        }
        if (this.customRanges != null && this.customRanges.get(this.numberOfBins) != null) {
            return this.createBinMiddleLabel(ranges, this.numberOfBins);
        }
        String label = this.defaultLabels.get(3);
        return label.replace("%1", ranges.get(this.numberOfBins - 1));
    }

    private String createBinMiddleLabel(List<String> ranges, int binNumber) {
        if (this.customLabels != null && this.customLabels.get(binNumber) != null) {
            return this.customLabels.get(binNumber);
        }
        String label = this.defaultLabels.get(2);
        label = label.replace("%1", ranges.get(binNumber - 1));
        return label.replace("%2", ranges.get(binNumber));
    }

    public static List<String> getResources() {
        ArrayList<String> resources = new ArrayList<String>();
        resources.add(BinExpression.resourceBinNull());
        resources.add(BinExpression.resourceBinLow());
        resources.add(BinExpression.resourceBinMiddle());
        resources.add(BinExpression.resourceBinHigh());
        return resources;
    }

    private String getBinNumberExpressionInteger() {
        String[] expressions = new String[]{this.whenNull(), this.whenMinEqualMax(), this.whenIntegerRangeTooSmall(), this.whenValueEqualMax(), this.elseWidthBucket()};
        return ExpressionUtil.assembleCase(expressions);
    }

    private String whenNull() {
        return ExpressionUtil.whenThen(ExpressionUtil.isNull(this.identifier), "null");
    }

    private String whenIntegerRangeTooSmall() {
        return ExpressionUtil.whenThen(this.integerCheck, this.binNumberThen());
    }

    private String binNumberThen() {
        String[] expressions = new String[2];
        StringBuilder condition = new StringBuilder(this.identifier);
        condition.append(" >= ");
        condition.append(this.virtualMaxValue);
        expressions[0] = ExpressionUtil.whenThen(condition.toString(), ExpressionUtil.getLiteral(this.numberOfBins));
        expressions[1] = ExpressionUtil.elseExp(BinExpressionUtil.widthBucket(this.identifier, this.virtualMinValue, this.virtualMaxValue, this.numberOfBins, this.expressionLocale));
        return ExpressionUtil.nest(ExpressionUtil.assembleCase(expressions));
    }

    private String getBinNumberExpressionDecimal() {
        String[] expressions = new String[]{this.whenNull(), this.whenMinEqualMax(), this.whenValueEqualMax(), this.elseWidthBucket()};
        return ExpressionUtil.assembleCase(expressions);
    }

    private String whenMinEqualMax() {
        StringBuilder condition = new StringBuilder(this.minForReport);
        condition.append(" = ");
        condition.append(this.maxForReport);
        return ExpressionUtil.whenThen(condition.toString(), ExpressionUtil.getLiteral(-1));
    }

    private String whenValueEqualMax() {
        StringBuilder condition = new StringBuilder(this.identifier);
        condition.append(" >= ");
        condition.append(this.maxForReport);
        return ExpressionUtil.whenThen(condition.toString(), ExpressionUtil.getLiteral(this.numberOfBins));
    }

    private String elseWidthBucket() {
        return ExpressionUtil.elseExp(BinExpressionUtil.widthBucket(this.identifier, this.minForReport, this.maxForReport, this.numberOfBins, this.expressionLocale));
    }

    private String getBinNumberExpressionCustomRanges() {
        boolean highBound = this.customRanges.get(this.numberOfBins) != null;
        ArrayList<String> expressions = new ArrayList<String>();
        expressions.add(this.whenNull());
        for (int i = 0; i < this.numberOfBins + 1; ++i) {
            String to = this.customRanges.get(i);
            if (to == null) continue;
            int binNumber = i == 0 ? -1 : i;
            expressions.add(BinExpression.rangeNumberExpression(this.identifier, to, binNumber));
        }
        if (highBound) {
            expressions.add(ExpressionUtil.elseExp("-1"));
        } else {
            expressions.add(ExpressionUtil.elseExp(ExpressionUtil.getLiteral(this.numberOfBins)));
        }
        return ExpressionUtil.assembleCase(BinExpression.toArray(expressions));
    }

    private static String[] toArray(List<String> value) {
        int size = value.size();
        String[] result = new String[value.size()];
        for (int i = 0; i < size; ++i) {
            result[i] = value.get(i);
        }
        return result;
    }

    private static String rangeNumberExpression(String identifier, String to, int binNumber) {
        StringBuilder condition = new StringBuilder(identifier);
        condition.append(" < ");
        condition.append(to);
        return ExpressionUtil.whenThen(condition.toString(), ExpressionUtil.getLiteral(binNumber));
    }

    private List<Double> rawIntegerBinLimits() {
        long min = Math.round(this.minValue);
        long max = Math.round(this.maxValue);
        if (max - min < (long)this.numberOfBins) {
            min -= (long)Math.floor(((double)this.numberOfBins - this.maxValue + this.minValue) / 2.0);
            max += (long)Math.ceil(((double)this.numberOfBins - this.maxValue + this.minValue) / 2.0);
        }
        double increment = (double)(max - min) / (double)this.numberOfBins;
        ArrayList<Double> limits = new ArrayList<Double>();
        limits.add(Double.valueOf(min));
        for (int i = 1; i < this.numberOfBins; ++i) {
            limits.add(Math.ceil((double)min + (double)i * increment));
        }
        limits.add(Double.valueOf(max));
        return limits;
    }

    private List<Double> rawBinLimits() {
        double increment = (this.maxValue - this.minValue) / (double)this.numberOfBins;
        ArrayList<Double> limits = new ArrayList<Double>();
        limits.add(this.minValue);
        for (int i = 1; i < this.numberOfBins; ++i) {
            limits.add(this.minValue + increment * (double)i);
        }
        limits.add(this.maxValue);
        return limits;
    }

    private static String binNull(String expressionLocale) {
        String binNull = MacroUtil.getResourceString(MacroUtil.getLiteral(BinExpression.resourceBinNull()));
        return MacroUtil.substr(binNull, 13, expressionLocale);
    }

    private static String binLow(String expressionLocale) {
        String binLow = MacroUtil.getResourceString(MacroUtil.getLiteral(BinExpression.resourceBinLow()));
        return MacroUtil.substr(binLow, 13, expressionLocale);
    }

    private static String binMiddle(String expressionLocale) {
        String binMiddle = MacroUtil.getResourceString(MacroUtil.getLiteral(BinExpression.resourceBinMiddle()));
        return MacroUtil.substr(binMiddle, 13, expressionLocale);
    }

    private static String binHigh(String expressionLocale) {
        String binHigh = MacroUtil.getResourceString(MacroUtil.getLiteral(BinExpression.resourceBinHigh()));
        return MacroUtil.substr(binHigh, 13, expressionLocale);
    }

    private static String resourceBinNull() {
        return "XQE_BIN_binNull";
    }

    private static String resourceBinLow() {
        return "XQE_BIN_binLow";
    }

    private static String resourceBinMiddle() {
        return "XQE_BIN_binMiddle";
    }

    private static String resourceBinHigh() {
        return "XQE_BIN_binHigh";
    }
}

