/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.expressions.v5.util;

import com.ibm.bi.platform.moser.expressions.v5.util.ExpressionUtil;
import com.ibm.bi.platform.moser.expressions.v5.util.FormatSymbols;

public class BinExpressionUtil {
    private BinExpressionUtil() {
    }

    public static String binLabel(String[][] bins, String binIdentifier) {
        String[] expressions = new String[bins.length];
        for (int i = 0; i < bins.length; ++i) {
            expressions[i] = BinExpressionUtil.binLabelExpression(binIdentifier, i + 1, bins[i][0]);
        }
        return ExpressionUtil.assembleCase(expressions);
    }

    public static String binLabelExpression(String binIdentifier, int binNumber, String thenValue) {
        StringBuilder condition = new StringBuilder(binIdentifier);
        condition.append(" = ");
        condition.append(ExpressionUtil.getLiteral(binNumber));
        return ExpressionUtil.whenThen(condition.toString(), ExpressionUtil.getLiteral(ExpressionUtil.escapeStringLiteral(thenValue)));
    }

    public static String formatDouble(Double x, int maxDecimalPlaces) {
        if (maxDecimalPlaces <= 0) {
            long intPart = Math.round(x);
            StringBuilder value = new StringBuilder();
            value.append(intPart);
            return value.toString();
        }
        long intPart = (long)Math.floor(x);
        StringBuilder value = new StringBuilder();
        value.append(intPart);
        value.append(".");
        long decimalPart = Math.round((x - (double)intPart) * Math.pow(10.0, maxDecimalPlaces));
        int decimalPartSize = BinExpressionUtil.longToString(decimalPart).length();
        int padding = maxDecimalPlaces - decimalPartSize;
        for (int i = 0; i < padding; ++i) {
            value.append("0");
        }
        value.append(decimalPart);
        return value.toString();
    }

    private static String longToString(long v) {
        StringBuilder value = new StringBuilder();
        value.append(v);
        return value.toString();
    }

    public static String widthBucket(String identifier, String minimum, String maximum, int numberOfBins, String locale) {
        String listSeparator = FormatSymbols.getListSeparator(locale);
        StringBuilder expression = new StringBuilder("width-bucket ( ");
        expression.append(identifier);
        expression.append(listSeparator);
        expression.append(" ");
        expression.append(minimum);
        expression.append(listSeparator);
        expression.append(" ");
        expression.append(maximum);
        expression.append(listSeparator);
        expression.append(" ");
        expression.append(numberOfBins);
        expression.append(" )");
        return expression.toString();
    }
}

