/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.expressions.v5.util;

import com.ibm.bi.platform.moser.expressions.v5.util.FormatSymbols;
import java.util.List;

public abstract class ExpressionUtil {
    public static final String INDENT = "    ";
    public static final String NEWLINE = "\r\n";
    public static final String NEWLINE_INDENT = "\r\n    ";

    private ExpressionUtil() {
    }

    public static String coalesce(String value, String defaultValue, String expressionLocale) {
        StringBuilder result = new StringBuilder("coalesce ( ");
        result.append(value);
        result.append(FormatSymbols.getListSeparator(expressionLocale));
        result.append(" ");
        result.append(defaultValue);
        result.append(" )");
        return result.toString();
    }

    public static String negate(String value) {
        StringBuilder result = new StringBuilder("- ");
        result.append(value);
        return result.toString();
    }

    public static String not(String value) {
        StringBuilder result = new StringBuilder("not ");
        result.append(value);
        return result.toString();
    }

    public static String isNull(String identifier) {
        StringBuilder result = new StringBuilder(identifier);
        result.append(" is null");
        return result.toString();
    }

    public static String isNotNull(String identifier) {
        StringBuilder result = new StringBuilder(identifier);
        result.append(" is not null");
        return result.toString();
    }

    public static String whenThen(String condition, String thenValue) {
        StringBuilder result = new StringBuilder(ExpressionUtil.whenExp(condition));
        result.append(" ");
        result.append(ExpressionUtil.thenExp(thenValue));
        return result.toString();
    }

    public static String caseWhenThen(String[] conditions, String[] thenValues) {
        String[] expressions = new String[conditions.length];
        for (int i = 0; i < conditions.length; ++i) {
            expressions[i] = ExpressionUtil.whenThen(conditions[i], thenValues[i]);
        }
        return ExpressionUtil.assembleCase(expressions);
    }

    public static String searchCase(String identifier, String[] conditions, String[] thenValues) {
        StringBuilder result = new StringBuilder("case");
        result.append(" ( ");
        result.append(identifier);
        result.append(" ) ");
        result.append(NEWLINE);
        for (int i = 0; i < conditions.length; ++i) {
            result.append(INDENT);
            result.append(ExpressionUtil.whenThen(conditions[i], thenValues[i]));
            result.append(NEWLINE);
        }
        result.append("end");
        return result.toString();
    }

    public static String cast(String value, String dataType, String expressionLocale) {
        StringBuilder result = new StringBuilder("cast ( ");
        result.append(value);
        result.append(FormatSymbols.getListSeparator(expressionLocale));
        result.append(" ");
        result.append(dataType);
        result.append(" )");
        return result.toString();
    }

    public static String ceil(String value) {
        StringBuilder result = new StringBuilder("ceil ( ");
        result.append(value);
        result.append(" )");
        return result.toString();
    }

    public static String floor(String value) {
        StringBuilder result = new StringBuilder("floor ( ");
        result.append(value);
        result.append(" )");
        return result.toString();
    }

    public static String ifThenElse(String condition, String thenValue, String elseValue) {
        StringBuilder result = new StringBuilder(ExpressionUtil.ifExp(condition));
        result.append(NEWLINE);
        result.append(ExpressionUtil.thenExp(thenValue));
        result.append(NEWLINE);
        result.append(ExpressionUtil.elseExp(elseValue));
        return result.toString();
    }

    public static String inlineIfThenElse(String condition, String thenValue, String elseValue) {
        StringBuilder result = new StringBuilder(ExpressionUtil.ifExp(condition));
        result.append(" ");
        result.append(ExpressionUtil.thenExp(thenValue));
        result.append(" ");
        result.append(ExpressionUtil.elseExp(elseValue));
        return result.toString();
    }

    public static String elseExp(String value) {
        StringBuilder result = new StringBuilder("else ( ");
        result.append(value);
        result.append(" )");
        return result.toString();
    }

    public static String in(String identifier, String[] inValues, String expressionLocale) {
        return ExpressionUtil.assembleSelection(FormatSymbols.getListSeparator(expressionLocale), identifier, inValues, "in", "or", ExpressionUtil.isNull(identifier));
    }

    private static String assembleSelection(String listSeparator, String identifier, String[] values, String condition, String booleanCondition, String nullIdentifier) {
        boolean first = true;
        boolean hasNullLiteral = false;
        StringBuilder result = new StringBuilder();
        for (String inValue : values) {
            if (ExpressionUtil.isNullLiteral(inValue)) {
                hasNullLiteral = true;
                continue;
            }
            if (first) {
                result.append(identifier);
                result.append(" ");
                result.append(condition);
                result.append(" ( ");
                first = false;
            } else {
                result.append(listSeparator);
                result.append(" ");
            }
            result.append((Object)inValue);
        }
        if (!first) {
            result.append(" )");
        }
        if (hasNullLiteral) {
            if (!first) {
                result.append(" ");
                result.append(booleanCondition);
                result.append(" ");
            }
            result.append(nullIdentifier);
        }
        return result.toString();
    }

    public static String notIn(String identifier, String[] notInValues, String expressionLocale) {
        return ExpressionUtil.assembleSelection(FormatSymbols.getListSeparator(expressionLocale), identifier, notInValues, "not in", "and", ExpressionUtil.isNotNull(identifier));
    }

    public static String whenRangeThen(String identifier, String from, String to, String thenValue, boolean inclusive) {
        return ExpressionUtil.whenThen(ExpressionUtil.range(identifier, from, to, inclusive), thenValue);
    }

    public static String range(String identifier, String from, String to, boolean inclusive) {
        StringBuilder result = new StringBuilder(identifier);
        if (from != null) {
            result.append(" >= ");
            result.append(from);
            if (to != null) {
                result.append(" and ");
                result.append(identifier);
            }
        }
        if (to != null) {
            if (inclusive) {
                result.append(" <= ");
            } else {
                result.append(" < ");
            }
            result.append(to);
        }
        return result.toString();
    }

    public static String assembleCase(String[] expressions) {
        StringBuilder result = new StringBuilder("case");
        result.append(NEWLINE);
        for (String expression : expressions) {
            result.append(INDENT);
            result.append(expression);
            result.append(NEWLINE);
        }
        result.append("end");
        return result.toString();
    }

    public static String minimumForReport(String value) {
        StringBuilder result = new StringBuilder("minimum ( ");
        result.append(value);
        result.append(" for report )");
        return result.toString();
    }

    public static String maximumForReport(String value) {
        StringBuilder result = new StringBuilder("maximum ( ");
        result.append(value);
        result.append(" for report )");
        return result.toString();
    }

    public static String minimumForScope(String value, List<String> scope, String aggregate, String locale) {
        String listSeparator = FormatSymbols.getListSeparator(locale);
        StringBuilder result = new StringBuilder("minimum ( ");
        result.append(aggregate);
        result.append(" ( ");
        result.append(value);
        result.append(" for ");
        for (int i = 0; i < scope.size(); ++i) {
            if (i > 0) {
                result.append(listSeparator);
                result.append(" ");
            }
            result.append(scope.get(i));
        }
        result.append(" )");
        result.append(" )");
        return result.toString();
    }

    public static String maximumForScope(String value, List<String> scope, String aggregate, String locale) {
        String listSeparator = FormatSymbols.getListSeparator(locale);
        StringBuilder result = new StringBuilder("maximum ( ");
        result.append(aggregate);
        result.append(" ( ");
        result.append(value);
        result.append(" for ");
        for (int i = 0; i < scope.size(); ++i) {
            if (i > 0) {
                result.append(listSeparator);
                result.append(" ");
            }
            result.append(scope.get(i));
        }
        result.append(" )");
        result.append(" )");
        return result.toString();
    }

    public static String escapeStringLiteral(Object value) {
        return value.toString().replaceAll("\\'", "''");
    }

    public static String getLiteral(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            StringBuilder result = new StringBuilder("'");
            result.append(value);
            result.append("'");
            return result.toString();
        }
        return value.toString();
    }

    public static String nest(String exp) {
        StringBuilder result = new StringBuilder(NEWLINE_INDENT);
        result.append(exp.replaceAll(NEWLINE, NEWLINE_INDENT));
        result.append(NEWLINE);
        return result.toString();
    }

    private static boolean isNullLiteral(Object obj) {
        return obj == null || "__NULL_NAME__".equals(obj);
    }

    private static String ifExp(String condition) {
        StringBuilder result = new StringBuilder("if ( ");
        result.append(condition);
        result.append(" )");
        return result.toString();
    }

    private static String whenExp(String condition) {
        StringBuilder result = new StringBuilder("when ( ");
        result.append(condition);
        result.append(" )");
        return result.toString();
    }

    private static String thenExp(String value) {
        StringBuilder result = new StringBuilder("then ( ");
        result.append(value);
        result.append(" )");
        return result.toString();
    }

    public static String whenInThen(String identifier, String[] inValues, String thenValue, String locale) {
        return ExpressionUtil.whenThen(ExpressionUtil.in(identifier, inValues, locale), thenValue);
    }
}

