/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cdms.ds.sforce.introspect.objects;

import com.ibm.cognos.jdbc.sfdc.util.DataType;
import com.sforce.soap.partner.FieldType;

public class SForceTableColumn {
    private static final String EMPTY_STR = "";
    private String theColumnName;
    private String theTable;
    private FieldType theNativeType;
    private DataType theType;
    private boolean isNillable;
    private boolean isIdLookup;
    private String[] referencesTo;
    private String relationShipName;
    private int length;
    private int digits;
    private int thePrecision;
    private int theScale;
    private boolean theGroupable;

    public SForceTableColumn(String columnName, String table, FieldType nativeType, DataType dataType, boolean nillable, boolean idLookup, String[] references, String relationShip, int lengthValue, int digitsValue, int precisionValue, int scaleValue, boolean groupable) {
        this.theColumnName = columnName;
        this.theTable = table;
        this.theNativeType = nativeType;
        this.theType = dataType;
        this.isNillable = nillable;
        this.isIdLookup = idLookup;
        this.referencesTo = references;
        this.relationShipName = relationShip;
        this.length = lengthValue;
        this.digits = digitsValue;
        this.thePrecision = precisionValue > 0 ? precisionValue : 0;
        this.theScale = scaleValue > 0 ? scaleValue : 0;
        this.theGroupable = groupable;
    }

    public String getName() {
        return this.theColumnName;
    }

    public FieldType getNativeType() {
        return this.theNativeType;
    }

    public DataType getDataType() {
        return this.theType;
    }

    public boolean isNillable() {
        return this.isNillable;
    }

    public boolean isIdLookup() {
        return this.isIdLookup;
    }

    public String[] getReferencesTo() {
        return this.referencesTo;
    }

    public String getRelationshipName() {
        return this.relationShipName;
    }

    public int getLength() {
        return this.length;
    }

    public int getScale() {
        return this.theScale;
    }

    public int getPrecision() {
        return this.thePrecision;
    }

    public int getDigits() {
        return this.digits;
    }

    public String getTable() {
        return this.theTable;
    }

    public void setTable(String table) {
        this.theTable = table;
    }

    public boolean isGroupable() {
        return this.theGroupable;
    }

    public void setExcludeNonGroupable(boolean groupable) {
        this.theGroupable = groupable;
    }

    public static class Builder {
        String theColumnName = "";
        String theCatalog = "";
        String theSchema = "";
        String theTable = "";
        DataType theType;
        boolean isNillable;
        boolean isIdLookup;
        String[] referencesTo = null;
        String relationShipName = null;
        int length = 255;
        int digits = 0;
        int thePrecision = 0;
        int theScale = 0;
        boolean theSearchable = true;
        boolean theGroupbale = true;

        public Builder setColumnName(String columnName) {
            this.theColumnName = columnName;
            return this;
        }

        public Builder setCatalog(String catalog) {
            this.theCatalog = catalog;
            return this;
        }

        public Builder setSchema(String schema) {
            this.theSchema = schema;
            return this;
        }

        public Builder setTable(String table) {
            this.theTable = table;
            return this;
        }

        public Builder setDataType(DataType type) {
            this.theType = type;
            return this;
        }

        public Builder setIsNillable(boolean nillable) {
            this.isNillable = nillable;
            return this;
        }

        public Builder setIsIdLookup(boolean idLookUp) {
            this.isIdLookup = idLookUp;
            return this;
        }

        public Builder setReferenceTo(String[] references) {
            this.referencesTo = references;
            return this;
        }

        public Builder setRelationShipName(String relationshipName) {
            this.relationShipName = relationshipName;
            return this;
        }

        public Builder setLength(int lengthValue) {
            this.length = lengthValue;
            return this;
        }

        public Builder setDigits(int digitsValue) {
            this.digits = digitsValue;
            return this;
        }

        public Builder setPrecision(int precision) {
            this.thePrecision = precision;
            return this;
        }

        public Builder setScale(int scale) {
            this.theScale = scale;
            return this;
        }

        public Builder setSearchable(boolean isSearchable) {
            this.theSearchable = isSearchable;
            return this;
        }

        public Builder setExcNonGroupable(boolean groupable) {
            this.theGroupbale = groupable;
            return this;
        }

        public SForceTableColumn build() {
            return new SForceTableColumn(this.theColumnName, this.theTable, null, this.theType, this.isNillable, this.isIdLookup, this.referencesTo, this.relationShipName, this.length, this.digits, this.thePrecision, this.theScale, this.theGroupbale);
        }
    }
}

