/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cdms.ds.sforce.request;

import com.ibm.cognos.cdms.ds.sforce.request.SForceUtil;

public class SForceConnectionParams
implements Cloneable {
    private static String NEWLINE = "\n";
    private String userName;
    private String password;
    private String url;
    private int userConcurrentCallsLimit = 10;
    private int concurrentCallsLimit = 25;
    private int queryBatchSize = 500;
    private int maximumRetries = 1;
    private int waitBetweenRetries = 0;
    private boolean proxyEnabled;
    private String proxyHost;
    private int proxyPort = 80;
    private String proxyUserName;
    private String proxyPassword;
    private boolean batchDeletesEnabled;
    private boolean batchUpdatesEnabled;
    private int connectionTimeOut = 60;
    private String dataSourceUniqueID;
    private boolean restEnabled;
    private String clientId = "";
    private String clientSecret = "";
    private boolean bindDatetimeWithTimestamp = false;

    public int getConnectionTimeOut() {
        return this.connectionTimeOut;
    }

    public void setConnectionTimeOut(int connectionTimeOut) {
        this.connectionTimeOut = connectionTimeOut;
    }

    public int getUserConcurrentCallsLimit() {
        return this.userConcurrentCallsLimit;
    }

    public void setUserConcurrentCallsLimit(int userConcurrentCallsLimit) {
        this.userConcurrentCallsLimit = userConcurrentCallsLimit;
    }

    public int getConcurrentCallsLimit() {
        return this.concurrentCallsLimit;
    }

    public void setConcurrentCallsLimit(int concurrentCallsLimit) {
        this.concurrentCallsLimit = concurrentCallsLimit;
    }

    public int getQueryBatchSize() {
        return this.queryBatchSize;
    }

    public void setQueryBatchSize(int queryBatchSize) {
        this.queryBatchSize = queryBatchSize;
    }

    public int getMaximumRetries() {
        return this.maximumRetries;
    }

    public void setMaximumRetries(int maximumRetries) {
        this.maximumRetries = maximumRetries;
    }

    public int getWaitBetweenRetries() {
        return this.waitBetweenRetries;
    }

    public void setWaitBetweenRetries(int waitBetweenRetries) {
        this.waitBetweenRetries = waitBetweenRetries;
    }

    public boolean isProxyEnabled() {
        return this.proxyEnabled;
    }

    public void setProxyEnabled(boolean proxyEnabled) {
        this.proxyEnabled = proxyEnabled;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public void setProxyUserName(String proxyUserName) {
        this.proxyUserName = proxyUserName;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    @Deprecated
    public boolean isBatchDeletesEnabled() {
        return this.batchDeletesEnabled;
    }

    @Deprecated
    public void setBatchDeletesEnabled(boolean batchDeletes) {
        this.batchDeletesEnabled = batchDeletes;
    }

    @Deprecated
    public boolean isBatchUpdatesEnabled() {
        return this.batchUpdatesEnabled;
    }

    @Deprecated
    public void setBatchUpdatesEnabled(boolean batchUpdates) {
        this.batchUpdatesEnabled = batchUpdates;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = SForceUtil.rewriteServerSessionURL(url);
    }

    public void setDataSourceId(String dataSourceName) {
        this.dataSourceUniqueID = dataSourceName;
    }

    public String getDataSourceId() {
        return this.dataSourceUniqueID;
    }

    public boolean isRestEnabled() {
        return this.restEnabled;
    }

    public void setRestEnabled(boolean isRestEnabled) {
        this.restEnabled = isRestEnabled;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String id) {
        this.clientId = id;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String secret) {
        this.clientSecret = secret;
    }

    public boolean bindDatetimeWithTimestamp() {
        return this.bindDatetimeWithTimestamp;
    }

    public void setBindDatetimeWithTimestamp(boolean bind) {
        this.bindDatetimeWithTimestamp = bind;
    }

    public String toString() {
        StringBuilder connectionParams = new StringBuilder();
        connectionParams.append(" DataSourceName = " + this.getDataSourceId());
        connectionParams.append(NEWLINE);
        connectionParams.append(" User Name = " + this.getUserName());
        connectionParams.append(NEWLINE);
        connectionParams.append(" Password = ");
        connectionParams.append(NEWLINE);
        connectionParams.append(" URL = " + this.getUrl());
        connectionParams.append(NEWLINE);
        connectionParams.append(" Connection time out = " + this.getConnectionTimeOut());
        connectionParams.append(NEWLINE);
        connectionParams.append(" User concurrent calls limit = " + this.getUserConcurrentCallsLimit());
        connectionParams.append(NEWLINE);
        connectionParams.append(" Concurrent calls limit = " + this.getConcurrentCallsLimit());
        connectionParams.append(NEWLINE);
        connectionParams.append(" Query batch size = " + this.getQueryBatchSize());
        connectionParams.append(NEWLINE);
        connectionParams.append(" Maximum retries = " + this.getMaximumRetries());
        connectionParams.append(NEWLINE);
        connectionParams.append(" Wait between retries = " + this.getWaitBetweenRetries());
        connectionParams.append(NEWLINE);
        connectionParams.append(" Proxy Enabled = " + this.isProxyEnabled());
        connectionParams.append(NEWLINE);
        connectionParams.append(" Proxy host = " + this.getProxyHost());
        connectionParams.append(NEWLINE);
        connectionParams.append(" Proxy port = " + this.getProxyPort());
        connectionParams.append(NEWLINE);
        connectionParams.append(" Proxy username = " + this.getProxyUserName());
        connectionParams.append(NEWLINE);
        connectionParams.append(" Proxy password = ");
        connectionParams.append(NEWLINE);
        connectionParams.append(" Batch deletes = " + this.isBatchDeletesEnabled());
        connectionParams.append(NEWLINE);
        connectionParams.append(" Batch updated = " + this.isBatchUpdatesEnabled());
        connectionParams.append(NEWLINE);
        connectionParams.append(" Rest Enabled = " + this.isRestEnabled());
        connectionParams.append(NEWLINE);
        connectionParams.append(" Client ID = " + this.getClientId());
        connectionParams.append(NEWLINE);
        connectionParams.append(" Client secret = ");
        return connectionParams.toString();
    }

    public String getKey() {
        StringBuilder key = new StringBuilder();
        key.append("DataSourceName = " + this.getDataSourceId());
        key.append("User Name = " + this.getUserName());
        key.append("Password = " + this.getPassword());
        key.append("URL = " + this.getUrl());
        if (this.isProxyEnabled()) {
            key.append("Proxy Host = " + this.getProxyHost());
            key.append("Proxy Port = " + this.getProxyPort());
            key.append("Proxy Username = " + this.getProxyUserName());
            key.append("Proxy Password = " + this.getProxyPassword());
        }
        return key.toString();
    }

    public SForceConnectionParams getCopy() {
        try {
            return (SForceConnectionParams)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getConnectionKey() {
        StringBuilder key = new StringBuilder();
        key.append(this.userName);
        key.append(" ");
        key.append(this.password);
        key.append(" ");
        key.append(this.url);
        return key.toString();
    }
}

