/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cdms.ds.sforce.request.provider.rest;

import com.ibm.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.ibm.cognos.cdms.ds.sforce.request.SForceConnectorConfig;
import com.ibm.cognos.cdms.ds.sforce.request.provider.SForceAPIProvider;
import com.ibm.cognos.cdms.ds.sforce.request.rest.transport.SForceRestAPIStubFactory;
import com.ibm.cognos.cdms.ds.sforce.request.session.ISForceSession;
import com.ibm.cognos.cdms.ds.sforce.request.session.SForceAPIException;
import com.ibm.cognos.cdms.ds.sforce.request.session.SForceSessionKey;
import com.ibm.cognos.cdms.ds.sforce.request.session.rest.SForceRestAPISession;
import com.ibm.cognos.cdms.ds.sforce.soql.cursors.SForceSOQLCursor;
import com.ibm.cognos.cdms.ds.sforce.soql.cursors.rest.SForceRESTSOQLCursor;
import com.ibm.cognos.cdms.ds.sforce.soql.parsers.ISForceSOQLQuery;
import com.sforce.soap.partner.Connector;
import com.sforce.soap.partner.LoginResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SForceRestAPIProvider
extends SForceAPIProvider {
    private static final Logger logger = LoggerFactory.getLogger(SForceRestAPIProvider.class);

    @Override
    public SForceSessionKey login(SForceConnectionParams connectionParams) throws SForceAPIException {
        if (logger.isDebugEnabled()) {
            logger.debug(" try login SOAP in REST CALL " + connectionParams.toString());
        }
        SForceSessionKey sessionKey = null;
        try {
            SForceConnectorConfig config = new SForceConnectorConfig(connectionParams);
            PartnerConnection connection = Connector.newConnection((ConnectorConfig)config.getConfig());
            LoginResult loginResult = connection.login(connectionParams.getUserName(), connectionParams.getPassword());
            String sessionId = loginResult.getSessionId();
            String serverUrl = loginResult.getServerUrl();
            String organizationId = loginResult.getUserInfo().getOrganizationId();
            sessionKey = new SForceSessionKey(sessionId, serverUrl, organizationId, connectionParams.getConnectionKey());
        }
        catch (ConnectionException e) {
            throw new SForceAPIException(e);
        }
        return sessionKey;
    }

    @Override
    public ISForceSession createSession(SForceConnectionParams connectionParams, SForceSessionKey sessionKey) throws SForceAPIException {
        return new SForceRestAPISession(SForceRestAPIStubFactory.getInstance().getHttpClient(connectionParams), connectionParams, sessionKey);
    }

    @Override
    public SForceSOQLCursor createSOQLCursor(SForceConnectionParams connectionParams, ISForceSOQLQuery query) {
        return new SForceRESTSOQLCursor(connectionParams, query);
    }

    @Override
    protected String getLoginURLPath() {
        return "/services/oauth2/token";
    }
}

