/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cdms.ds.sforce.request.session;

import com.ibm.cognos.cdms.ds.sforce.introspect.objects.SForceTable;
import com.ibm.cognos.cdms.ds.sforce.introspect.objects.SForceTableInfo;
import com.ibm.cognos.cdms.ds.sforce.request.SForceAPIRequestTracker;
import com.ibm.cognos.cdms.ds.sforce.request.SForceResultSet;
import com.ibm.cognos.cdms.ds.sforce.request.resultset.ISForceQueryResult;
import com.ibm.cognos.cdms.ds.sforce.request.session.ISForceSession;
import com.ibm.cognos.cdms.ds.sforce.request.session.SForceAPIException;
import com.ibm.cognos.cdms.ds.sforce.request.session.SForceSessionKey;
import com.sforce.ws.ConnectionException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SForceTrackingSession
implements ISForceSession {
    private static final Logger logger = LoggerFactory.getLogger(SForceTrackingSession.class);
    ISForceSession session;

    public SForceTrackingSession(ISForceSession session) {
        this.session = session;
    }

    @Override
    public SForceSessionKey getSessionkey() {
        return this.session.getSessionkey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SForceTableInfo getTableMetadata(String objectName) throws SForceAPIException, ConnectionException {
        long requestId = -1L;
        try {
            requestId = this.startRequest(false);
            if (logger.isDebugEnabled()) {
                logger.debug("Call get tables requestId " + requestId);
            }
            SForceTableInfo sForceTableInfo = this.session.getTableMetadata(objectName);
            return sForceTableInfo;
        }
        finally {
            if (requestId != -1L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Call get tables completed successfully " + requestId);
                }
                this.closeRequest(requestId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SForceTable[] getTables() throws SForceAPIException, ConnectionException {
        long requestId = -1L;
        try {
            requestId = this.startRequest(false);
            if (logger.isDebugEnabled()) {
                logger.debug("Call get tables requestId " + requestId);
            }
            SForceTable[] sForceTableArray = this.session.getTables();
            return sForceTableArray;
        }
        finally {
            if (requestId != -1L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Call get tables completed successfully " + requestId);
                }
                this.closeRequest(requestId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, SForceTableInfo> getTablesMetadata(String[] objectNames) throws SForceAPIException, ConnectionException {
        long requestId = -1L;
        try {
            requestId = this.startRequest(false);
            if (logger.isDebugEnabled()) {
                logger.debug("Call get tables metdata requestId " + requestId);
            }
            HashMap<String, SForceTableInfo> hashMap = this.session.getTablesMetadata(objectNames);
            return hashMap;
        }
        finally {
            if (requestId != -1L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Call get tables metdata completed successfully " + requestId);
                }
                this.closeRequest(requestId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SForceResultSet query(String sql, boolean retrieveAllBatches) throws SForceAPIException {
        long requestId = -1L;
        try {
            requestId = this.startRequest(false);
            if (logger.isDebugEnabled()) {
                logger.debug("Call query requestId " + requestId);
            }
            SForceResultSet sForceResultSet = this.session.query(sql, retrieveAllBatches);
            return sForceResultSet;
        }
        finally {
            if (requestId != -1L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Call query completed successfully " + requestId);
                }
                this.closeRequest(requestId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISForceQueryResult queryMore(String queryLocator) throws SForceAPIException {
        long requestId = -1L;
        try {
            requestId = this.startRequest(false);
            if (logger.isDebugEnabled()) {
                logger.debug("Call querymore requestId " + requestId);
            }
            ISForceQueryResult iSForceQueryResult = this.session.queryMore(queryLocator);
            return iSForceQueryResult;
        }
        finally {
            if (requestId != -1L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Call query more completed successfully " + requestId);
                }
                this.closeRequest(requestId);
            }
        }
    }

    private long startRequest(boolean getUserLevelLock) {
        long requestId = SForceAPIRequestTracker.startRequest(this.getOrganizationKey(), this.getConnectionKey(), getUserLevelLock, this.getConcurrentCallsLimit(), this.getUserConcurrentCallsLimit());
        return requestId;
    }

    @Override
    public int getConcurrentCallsLimit() {
        return this.session.getConcurrentCallsLimit();
    }

    @Override
    public int getUserConcurrentCallsLimit() {
        return this.session.getUserConcurrentCallsLimit();
    }

    @Override
    public String getConnectionKey() {
        return this.session.getConnectionKey();
    }

    @Override
    public String getOrganizationKey() {
        return this.session.getOrganizationKey();
    }

    private void closeRequest(long requestId) {
        SForceAPIRequestTracker.closeRequest(this.getOrganizationKey(), this.getConnectionKey(), requestId);
    }
}

