/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cdms.ds.sforce.soql.cursors.rest;

import com.ibm.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.ibm.cognos.cdms.ds.sforce.request.resultset.ISForceQueryResultRecord;
import com.ibm.cognos.cdms.ds.sforce.request.resultset.rest.SForceRESTQueryResultRecord;
import com.ibm.cognos.cdms.ds.sforce.soql.cursors.ISForceRecord;
import com.ibm.cognos.cdms.ds.sforce.soql.cursors.SForceRecordType;
import com.ibm.cognos.cdms.ds.sforce.soql.cursors.SForceSOQLCursor;
import com.ibm.cognos.cdms.ds.sforce.soql.cursors.SForceTableColumn;
import com.ibm.cognos.cdms.ds.sforce.soql.cursors.rest.SForceRESTColumnValue;
import com.ibm.cognos.cdms.ds.sforce.soql.parsers.ISForceSOQLQuery;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.OrderedJSONObject;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SForceRESTSOQLCursor
extends SForceSOQLCursor {
    private static final Logger logger = LoggerFactory.getLogger(SForceRESTSOQLCursor.class);

    public SForceRESTSOQLCursor(SForceConnectionParams connectionParams, ISForceSOQLQuery query) {
        super(connectionParams, query);
    }

    @Override
    protected void processRecord(ISForceQueryResultRecord record, ISForceSOQLQuery query, String parentPath, ISForceRecord bufferRecord) {
        if (logger.isDebugEnabled()) {
            logger.debug("Processing sobject " + parentPath);
        }
        int currentIndex = -1;
        String key = null;
        String type = null;
        OrderedJSONObject sobject = (OrderedJSONObject)record.getObject();
        OrderedJSONObject attributes = (OrderedJSONObject)sobject.get((Object)"attributes");
        type = (String)attributes.get((Object)"type");
        Iterator itr = sobject.getOrder();
        while (itr.hasNext()) {
            Object obj;
            key = (String)itr.next();
            if (key.equals("attributes")) continue;
            boolean useFullName = false;
            String eleFullName = null;
            String objectType = key;
            String eleName = null;
            if (parentPath != null && parentPath.length() > 0) {
                eleName = parentPath + "." + objectType;
                eleFullName = parentPath + "." + type + "." + objectType;
            } else {
                eleName = objectType;
                eleFullName = type + "." + objectType;
            }
            if (query.isSObject(eleName) || query.isSObject(eleFullName)) {
                obj = sobject.get((Object)key);
                useFullName = query.isSObject(eleFullName);
                if (obj == null) continue;
                OrderedJSONObject childObj = (OrderedJSONObject)obj;
                SForceRESTQueryResultRecord sforceRecord = new SForceRESTQueryResultRecord(childObj);
                if (useFullName) {
                    this.processRecord(sforceRecord, query, eleFullName, bufferRecord);
                    continue;
                }
                this.processRecord(sforceRecord, query, eleName, bufferRecord);
                continue;
            }
            if (query.isQueryResult(eleName) || query.isQueryResult(eleFullName)) {
                obj = sobject.get((Object)key);
                useFullName = query.isSObject(eleFullName);
                if (obj == null) continue;
                OrderedJSONObject qr = (OrderedJSONObject)obj;
                if (useFullName) {
                    this.processQueryResult(qr, eleFullName, bufferRecord);
                    continue;
                }
                this.processQueryResult(qr, eleName, bufferRecord);
                continue;
            }
            Object value = sobject.get((Object)key);
            SForceTableColumn columnValue = (SForceTableColumn)bufferRecord.getChildRecord(SForceRecordType.COLUMN, eleName.toLowerCase());
            if (columnValue == null) {
                columnValue = (SForceTableColumn)bufferRecord.getChildRecord(SForceRecordType.COLUMN, eleFullName.toLowerCase());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("setting column value " + eleFullName);
            }
            columnValue.addValue(new SForceRESTColumnValue(value));
        }
    }

    private void processQueryResult(OrderedJSONObject obj, String parentPath, ISForceRecord bufferRecord) {
        if (logger.isDebugEnabled()) {
            logger.debug("Processing internal query result " + parentPath);
        }
        JSONArray objArray = (JSONArray)obj.get((Object)"records");
        int resultSetSize = objArray.size();
        ISForceRecord innerTableRecord = bufferRecord.getChildRecord(SForceRecordType.TABLE, parentPath.toLowerCase());
        innerTableRecord.initialize(resultSetSize);
        for (int index = 0; index < resultSetSize; ++index) {
            OrderedJSONObject object = (OrderedJSONObject)objArray.get(index);
            SForceRESTQueryResultRecord sforceRecord = new SForceRESTQueryResultRecord(object);
            this.processRecord(sforceRecord, this.query, parentPath, innerTableRecord);
        }
    }
}

