/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.sfdc;

import com.ibm.cognos.jdbc.sfdc.QueryResult;
import com.ibm.cognos.jdbc.sfdc.SFDCConnection;
import com.ibm.cognos.jdbc.sfdc.SFDCEmptyResultSetFactory;
import com.ibm.cognos.jdbc.sfdc.SFDCResultSet;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCMessageUtil;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCSQLErrorCode;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCSQLState;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;

public class SFDCStatement
implements Statement {
    private static final String EXECUTE_GENERATED_KEYS = "executeGeneratedKeys";
    private static final String EXECUTE_UPDATE = "executeUpdate";
    private final AtomicReference<SFDCConnection> conn;
    private final AtomicReference<SFDCResultSet> currentResult = new AtomicReference();
    private final AtomicReference<Throwable> error = new AtomicReference();
    private final AtomicReference<String> queryUUID = new AtomicReference();

    SFDCStatement(SFDCConnection connection) {
        Objects.requireNonNull(connection, SFDCMessageUtil.getMessage("0007", "connection"));
        this.conn = new AtomicReference<SFDCConnection>(connection);
    }

    private void checkOpen() throws SQLException {
        this.connection();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return arg0.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        if (this.isWrapperFor(arg0)) {
            return (T)this;
        }
        throw new SQLException(SFDCMessageUtil.getMessage("0009", arg0), SFDCSQLState.JAVA_FUNCTION.getState(), SFDCSQLErrorCode.INVALID_UNWRAP.getErrorCode());
    }

    @Override
    public void addBatch(String arg0) throws SQLException {
        throw SFDCStatement.notSupported("add batch");
    }

    @Override
    public void cancel() throws SQLException {
        this.checkOpen();
    }

    @Override
    public void clearBatch() throws SQLException {
        throw SFDCStatement.notSupported("clear batch");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public void close() throws SQLException {
        this.conn.set(null);
        this.closeResultSet();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkOpen();
    }

    @Override
    public boolean execute(String arg0) throws SQLException {
        if (!this.internalExecute(arg0)) {
            if (null != this.error.get()) {
                throw new SQLException(SFDCMessageUtil.getMessage("0014", arg0, this.error.get()), SFDCSQLState.TRANSACTION_STATE.getState(), SFDCSQLErrorCode.QUERY_ERROR.getErrorCode(), this.error.get());
            }
            throw new SQLException(SFDCMessageUtil.getMessage("0013", arg0), SFDCSQLState.TRANSACTION_STATE.getState(), SFDCSQLErrorCode.QUERY_ERROR.getErrorCode());
        }
        return true;
    }

    @Override
    public boolean execute(String arg0, int arg1) throws SQLException {
        this.checkOpen();
        if (1 == arg1) {
            throw SFDCStatement.notSupported(EXECUTE_GENERATED_KEYS);
        }
        return this.execute(arg0);
    }

    @Override
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        this.checkOpen();
        if (arg1.length > 0) {
            throw SFDCStatement.notSupported(EXECUTE_GENERATED_KEYS);
        }
        return this.execute(arg0);
    }

    @Override
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        this.checkOpen();
        if (arg1.length > 0) {
            throw SFDCStatement.notSupported(EXECUTE_GENERATED_KEYS);
        }
        return this.execute(arg0);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw SFDCStatement.notSupported("execute batch");
    }

    @Override
    public ResultSet executeQuery(String arg0) throws SQLException {
        if (!this.internalExecute(arg0)) {
            if (null != this.error.get()) {
                throw new SQLException(SFDCMessageUtil.getMessage("0014", arg0, this.error.get()), SFDCSQLState.TRANSACTION_STATE.getState(), SFDCSQLErrorCode.QUERY_ERROR.getErrorCode(), this.error.get());
            }
            throw new SQLException(SFDCMessageUtil.getMessage("0013", arg0), SFDCSQLState.TRANSACTION_STATE.getState(), SFDCSQLErrorCode.QUERY_ERROR.getErrorCode());
        }
        return this.currentResult.get();
    }

    @Override
    public int executeUpdate(String arg0) throws SQLException {
        throw SFDCStatement.notSupported(EXECUTE_UPDATE);
    }

    @Override
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        throw SFDCStatement.notSupported(EXECUTE_UPDATE);
    }

    @Override
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        throw SFDCStatement.notSupported(EXECUTE_UPDATE);
    }

    @Override
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        throw SFDCStatement.notSupported(EXECUTE_UPDATE);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return 1000;
    }

    private int getValueAsZero() throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.getValueAsZero();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.getValueAsZero();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.getValueAsZero();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public boolean getMoreResults(int arg0) throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.getValueAsZero();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return this.currentResult.get();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        return 2;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkOpen();
        return true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return null == this.conn.get();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void setCursorName(String arg0) throws SQLException {
        this.checkOpen();
    }

    @Override
    public void setEscapeProcessing(boolean arg0) throws SQLException {
        this.checkOpen();
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
        this.checkOpen();
        if (1000 != arg0) {
            throw new SQLException(SFDCMessageUtil.getMessage("0012", 1000, arg0), SFDCSQLState.INCONSISTENT_CURSOR.getState(), SFDCSQLErrorCode.NOT_FORWARD_ONLY.getErrorCode());
        }
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
        this.checkOpen();
        this.checkPositive(arg0);
    }

    private void checkPositive(int arg0) throws SQLException {
        if (arg0 < 0) {
            throw new SQLException(SFDCMessageUtil.getMessage("0011", arg0), SFDCSQLState.JAVA_FUNCTION.getState(), SFDCSQLErrorCode.NEGATIVE_VALUE_NOT_ALLOWED.getErrorCode());
        }
    }

    private void setAndCheckSize(int arg0) throws SQLException {
        this.checkOpen();
        this.checkPositive(arg0);
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
        this.setAndCheckSize(arg0);
    }

    @Override
    public void setMaxRows(int arg0) throws SQLException {
        this.setAndCheckSize(arg0);
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
        this.checkOpen();
    }

    @Override
    public void setQueryTimeout(int arg0) throws SQLException {
        this.setAndCheckSize(arg0);
    }

    protected final SFDCConnection connection() throws SQLException {
        SFDCConnection connection = this.conn.get();
        if (null == connection) {
            throw new SQLException(SFDCMessageUtil.getMessage("0010"), SFDCSQLState.JAVA_FUNCTION.getState(), SFDCSQLErrorCode.STATEMENT_CLOSED.getErrorCode());
        }
        if (connection.isClosed()) {
            throw new SQLException(SFDCMessageUtil.getMessage("0001"), SFDCSQLState.CONNECTION_CLOSED.getState(), SFDCSQLErrorCode.CONNECTION_CLOSED.getErrorCode());
        }
        return connection;
    }

    private void closeResultSet() throws SQLException {
        this.error.set(null);
        this.queryUUID.set(null);
        ResultSet resultSet = this.currentResult.getAndSet(null);
        if (null != resultSet) {
            resultSet.close();
        }
    }

    protected static SQLFeatureNotSupportedException notSupported(String s) {
        return new SQLFeatureNotSupportedException(SFDCMessageUtil.getMessage("0025", s), SFDCSQLState.FEATURE_NOT_SUPPORTED.getState(), SFDCSQLErrorCode.JDBC_FEATURE_NOT_SUPPORTED.getErrorCode());
    }

    final boolean internalExecute(String sql) throws SQLException {
        this.currentResult.set(null);
        this.queryUUID.set(UUID.randomUUID().toString());
        this.checkOpen();
        QueryResult result = this.connection().executeQuery(this.queryUUID.get(), sql, this);
        if (result.getQueryStatus().hasFailed()) {
            this.error.set(result.getQueryStatus().getError());
        }
        if (null == result.getResultSet()) {
            this.currentResult.set(SFDCEmptyResultSetFactory.constructEmptyResultSet(this.queryUUID.get(), this.connection().getConnectionUUID(), this));
        }
        this.currentResult.set(result.getResultSet());
        return result.getQueryStatus().isSuccessful();
    }
}

