/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.sfdc.util;

import com.ibm.cognos.cdms.ds.sforce.introspect.objects.SForceTableColumn;
import com.ibm.cognos.jdbc.sfdc.SFDCResultSet;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCMessageUtil;
import com.ibm.cognos.jdbc.sfdc.util.DataType;
import com.sforce.soap.partner.FieldType;
import java.util.Objects;

public abstract class MetadataUtils {
    public static final int DEFAULT_LENGTH = 255;
    public static final int DEFAULT_DIGITS = 0;
    public static final int DEFAULT_PRECISION = 0;
    public static final int DEFAULT_SCALE = 0;

    public static String inferDataTypeName(FieldType fieldType, boolean bindDatetimeWithTimestamp) {
        Objects.requireNonNull(fieldType, SFDCMessageUtil.getMessage("0007", "dataType"));
        switch (fieldType) {
            case string: 
            case picklist: 
            case combobox: 
            case reference: 
            case base64: 
            case phone: 
            case id: 
            case url: 
            case email: 
            case encryptedstring: 
            case datacategorygroupreference: 
            case location: 
            case address: 
            case complexvalue: 
            case textarea: 
            case anyType: {
                return DataType.VARCHAR.value();
            }
            case multipicklist: {
                return DataType.NVARCHAR.value();
            }
            case _boolean: {
                return DataType.BOOLEAN.value();
            }
            case _long: 
            case _int: {
                return DataType.BIGINT.value();
            }
            case _double: {
                return DataType.DOUBLE.value();
            }
            case currency: 
            case percent: {
                return DataType.DECIMAL.value();
            }
            case date: {
                return DataType.DATE.value();
            }
            case datetime: {
                if (bindDatetimeWithTimestamp) {
                    return DataType.TIMESTAMP.value();
                }
                return DataType.TIMESTAMP_WITH_TIMEZONE.value();
            }
            case time: {
                return DataType.TIME.value();
            }
        }
        throw new IllegalArgumentException(SFDCMessageUtil.getMessage("0015", fieldType.toString()));
    }

    public static FieldType inferFieldType(String type) {
        Objects.requireNonNull(type, SFDCMessageUtil.getMessage("0007", "dataType"));
        switch (type) {
            case "string": {
                return FieldType.string;
            }
            case "picklist": {
                return FieldType.picklist;
            }
            case "multipicklist": {
                return FieldType.multipicklist;
            }
            case "combobox": {
                return FieldType.combobox;
            }
            case "reference": {
                return FieldType.reference;
            }
            case "base64": {
                return FieldType.base64;
            }
            case "textarea": {
                return FieldType.textarea;
            }
            case "phone": {
                return FieldType.phone;
            }
            case "id": {
                return FieldType.id;
            }
            case "url": {
                return FieldType.url;
            }
            case "email": {
                return FieldType.email;
            }
            case "encryptedstring": {
                return FieldType.encryptedstring;
            }
            case "datacategorygroupreference": {
                return FieldType.datacategorygroupreference;
            }
            case "location": {
                return FieldType.location;
            }
            case "address": {
                return FieldType.address;
            }
            case "complexvalue": {
                return FieldType.complexvalue;
            }
            case "anyType": {
                return FieldType.anyType;
            }
            case "_boolean": {
                return FieldType._boolean;
            }
            case "_int": {
                return FieldType._int;
            }
            case "_double": {
                return FieldType._double;
            }
            case "currency": {
                return FieldType.currency;
            }
            case "percent": {
                return FieldType.percent;
            }
            case "date": {
                return FieldType.date;
            }
            case "datetime": {
                return FieldType.datetime;
            }
            case "time": {
                return FieldType.time;
            }
        }
        throw new IllegalArgumentException(SFDCMessageUtil.getMessage("0015", type));
    }

    public static int inferDataTypeAsJDBC(DataType type) {
        Objects.requireNonNull(type, SFDCMessageUtil.getMessage("0007", "dataType"));
        switch (type) {
            case VARCHAR: {
                return 12;
            }
            case NVARCHAR: {
                return -9;
            }
            case BOOLEAN: {
                return 16;
            }
            case INTEGER: {
                return 4;
            }
            case DOUBLE: {
                return 8;
            }
            case DECIMAL: {
                return 3;
            }
            case NUMERIC: {
                return 2;
            }
            case DATE: {
                return 91;
            }
            case TIMESTAMP: {
                return 93;
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                return 2014;
            }
            case TIME: {
                return 92;
            }
            case BIGINT: {
                return -5;
            }
        }
        throw new IllegalArgumentException(SFDCMessageUtil.getMessage("0015", type.toString()));
    }

    public static int getColumnSize(SForceTableColumn field) {
        if (null == field.getNativeType()) {
            return field.getLength();
        }
        switch (MetadataUtils.inferDataTypeAsJDBC(field.getDataType())) {
            case -5: {
                return field.getDigits();
            }
            case 3: 
            case 8: {
                return field.getPrecision();
            }
            case 1: {
                if (field.getNativeType().toString().equals(SFDCResultSet.SFORCE_DATATYPE_BOOLEAN)) {
                    return 5;
                }
            }
            case 93: 
            case 2014: {
                return 22;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 11;
            }
        }
        return field.getLength();
    }

    public static int getDecimalDigits(SForceTableColumn field) {
        if (MetadataUtils.inferDataTypeAsJDBC(field.getDataType()) == 3 || MetadataUtils.inferDataTypeAsJDBC(field.getDataType()) == 8) {
            return field.getScale();
        }
        if (MetadataUtils.inferDataTypeAsJDBC(field.getDataType()) == 93 || MetadataUtils.inferDataTypeAsJDBC(field.getDataType()) == 2014) {
            return 1;
        }
        if (MetadataUtils.inferDataTypeAsJDBC(field.getDataType()) == 92) {
            return 3;
        }
        return 0;
    }
}

