/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.collections;

import com.spss.ac.acbase.collections.ArrayUtils;
import com.spss.datarecord.DataVal;
import com.spss.datarecord.IntVal;
import com.spss.datarecord.RealVal;
import com.spss.datarecord.StringVal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ACUtils {
    private ACUtils() {
    }

    public static int[] newArray(int size, int initialVal) {
        return ArrayUtils.newArray(initialVal, size);
    }

    public static <T> List<T> newList(int size) {
        ArrayList result = new ArrayList(size);
        ACUtils.resize(result, size);
        return result;
    }

    public static <T> List<T> newList(int size, Class<T> clazz) {
        ArrayList result = new ArrayList(size);
        ACUtils.resize(result, size, clazz);
        return result;
    }

    public static <T> void resize(List<T> list, int newSize, T initialVal) {
        block2: {
            int size;
            block3: {
                if (list == null) break block2;
                size = list.size();
                if (size >= newSize) break block3;
                for (int i = size; i < newSize; ++i) {
                    list.add(initialVal);
                }
                break block2;
            }
            if (size <= newSize) break block2;
            for (int i = size - 1; i >= newSize; --i) {
                list.remove(i);
            }
        }
    }

    public static <T> void resize(List<T> list, int newSize) {
        block2: {
            int size;
            block3: {
                if (list == null) break block2;
                size = list.size();
                if (size >= newSize) break block3;
                for (int i = size; i < newSize; ++i) {
                    list.add(null);
                }
                break block2;
            }
            if (size <= newSize) break block2;
            for (int i = size - 1; i >= newSize; --i) {
                list.remove(i);
            }
        }
    }

    public static <T> void resize(List<T> list, int newSize, Class<T> clazz) {
        block5: {
            int size;
            block6: {
                if (list == null) break block5;
                size = list.size();
                if (size >= newSize) break block6;
                for (int i = size; i < newSize; ++i) {
                    Object obj = null;
                    try {
                        obj = clazz.newInstance();
                    }
                    catch (IllegalAccessException e) {
                        obj = null;
                    }
                    catch (InstantiationException e) {
                        obj = null;
                    }
                    list.add(obj);
                }
                break block5;
            }
            if (size <= newSize) break block5;
            for (int i = size - 1; i >= newSize; --i) {
                list.remove(i);
            }
        }
    }

    public static int[] toArray(List<Integer> list) {
        if (list == null || list.isEmpty()) {
            return ArrayUtils.ZERO_INT_ARRAY;
        }
        int[] result = new int[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static String[] toStringArray(List<String> list) {
        if (list == null || list.isEmpty()) {
            return ArrayUtils.ZERO_STRING_ARRAY;
        }
        String[] result = new String[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static int[][] toArrayArray(List<ArrayList<Integer>> list) {
        if (list == null || list.isEmpty()) {
            return new int[0][];
        }
        int[][] result = new int[list.size()][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ACUtils.toArray((List<Integer>)list.get(i));
        }
        return result;
    }

    public static double[] toDArray(List<Double> list) {
        if (list == null || list.isEmpty()) {
            return ArrayUtils.ZERO_DOUBLE_ARRAY;
        }
        double[] result = new double[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static boolean[] toBooleanArray(List<Boolean> list) {
        if (list == null || list.isEmpty()) {
            return ArrayUtils.ZERO_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static List<Double> toList(double[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<Double> result = new ArrayList<Double>(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.add(array[i]);
        }
        return result;
    }

    public static List<Integer> toList(int[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.add(array[i]);
        }
        return result;
    }

    public static <T> List<T> toList(T[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.add(array[i]);
        }
        return result;
    }

    public static <T> int size(List<T> list) {
        return list != null ? list.size() : 0;
    }

    public static int deepSize(List<byte[]> list) {
        int result = 0;
        if (list != null) {
            for (byte[] byteBuf : list) {
                result += byteBuf.length;
            }
        }
        return result;
    }

    public static <T> boolean isEmpty(List<T> list) {
        return list != null ? list.isEmpty() : true;
    }

    public static String displayDArray(double[] arr, String name) {
        String result = name + " = ";
        if (arr == null || arr.length == 0) {
            result = result + "<Empty>\n";
        } else {
            int nInRow = 10;
            int length = arr.length;
            int nRows = length / nInRow;
            int lastRow = length - nRows * nInRow;
            int index = 0;
            for (int i = 0; i < nRows; ++i) {
                for (int j = 0; j < nInRow; ++j) {
                    result = result + arr[index++] + " ";
                }
                result = result + "\n";
            }
            for (int j = 0; j < lastRow; ++j) {
                result = result + arr[index++] + " ";
            }
            result = result + "\n";
        }
        return result;
    }

    public static String displayIArray(int[] arr, String name) {
        String result = name + " = ";
        if (arr == null || arr.length == 0) {
            result = result + "<Empty>\n";
        } else {
            int nInRow = 20;
            int length = arr.length;
            int nRows = length / nInRow;
            int lastRow = length - nRows * nInRow;
            int index = 0;
            for (int i = 0; i < nRows; ++i) {
                for (int j = 0; j < nInRow; ++j) {
                    result = result + arr[index++] + " ";
                }
                result = result + "\n";
            }
            for (int j = 0; j < lastRow; ++j) {
                result = result + arr[index++] + " ";
            }
            result = result + "\n";
        }
        return result;
    }

    public static void addAll(Collection<Integer> collection, int[] array) {
        for (int i : array) {
            collection.add(i);
        }
    }

    public static double[][] clone(double[][] array) {
        double[][] result = (double[][])array.clone();
        for (int i = 0; i < array.length; ++i) {
            result[i] = (double[])array[i].clone();
        }
        return result;
    }

    public static int[][] clone(int[][] array) {
        int[][] result = (int[][])array.clone();
        for (int i = 0; i < array.length; ++i) {
            result[i] = (int[])array[i].clone();
        }
        return result;
    }

    public static double doubleValue(DataVal val) {
        double result = Double.NaN;
        DataVal.DataType dataType = val.getDataType();
        if (ACUtils.isRealType(dataType)) {
            result = ((RealVal)val).getVal();
        } else if (dataType == DataVal.DataType.INT) {
            result = ((IntVal)val).getVal();
        }
        return result;
    }

    public static boolean isRealVal(DataVal val) {
        return ACUtils.isRealType(val.getDataType());
    }

    public static boolean isRealType(DataVal.DataType dataType) {
        return dataType == DataVal.DataType.REAL || dataType == DataVal.DataType.DATE || dataType == DataVal.DataType.TIME || dataType == DataVal.DataType.TIMESTAMP;
    }

    public static boolean containsCtrlChar(String text) {
        int length = text.length();
        for (int ix = 0; ix < length; ++ix) {
            char c = text.charAt(ix);
            if (c >= ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return true;
        }
        return false;
    }

    public static boolean containsCtrlChar(DataVal val) {
        if (val.getDataType() == DataVal.DataType.STRING) {
            return ACUtils.containsCtrlChar(((StringVal)val).getVal());
        }
        return false;
    }

    public static <T> List<T> assign(List<T> lhs, List<T> rhs) {
        if (lhs != null) {
            if (rhs != null) {
                lhs.clear();
                lhs.addAll(rhs);
            } else {
                lhs = null;
            }
        } else if (rhs != null) {
            lhs = new ArrayList<T>(rhs);
        }
        return lhs;
    }
}

