/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.collections;

import com.spss.ac.acbase.serialization.ACSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public class DoubleArray
implements RandomAccess,
Cloneable,
ACSerializable {
    private transient int firstIndex;
    private transient int lastIndex;
    private double[] array;

    public DoubleArray() {
        this(10);
    }

    public DoubleArray(int capacity) {
        this.lastIndex = 0;
        this.firstIndex = 0;
        try {
            this.array = this.newElementArray(capacity);
        }
        catch (NegativeArraySizeException e) {
            throw new IllegalArgumentException();
        }
    }

    public DoubleArray(int n, double value) {
        this.firstIndex = 0;
        try {
            this.array = this.newElementArray(n + n / 10);
            this.lastIndex = n;
            Arrays.fill(this.array, this.firstIndex, this.lastIndex, value);
        }
        catch (NegativeArraySizeException e) {
            throw new IllegalArgumentException();
        }
    }

    public DoubleArray(Collection<Double> collection) {
        int size = collection.size();
        this.firstIndex = 0;
        this.lastIndex = 0;
        this.array = this.newElementArray(size + size / 10);
        for (Double i : collection) {
            this.array[this.lastIndex++] = i;
        }
    }

    public DoubleArray(double[] arr) {
        int size = arr.length;
        this.firstIndex = 0;
        this.array = this.newElementArray(size + size / 10);
        System.arraycopy(arr, 0, this.array, 0, size);
        this.lastIndex = size;
    }

    public boolean add(double object) {
        int localLastIndex = this.lastIndex;
        if (localLastIndex == this.array.length) {
            localLastIndex = this.growAtEnd(1, localLastIndex);
        }
        this.array[localLastIndex++] = object;
        this.lastIndex = localLastIndex;
        return true;
    }

    public void add(int location, double object) {
        int localLastIndex = this.lastIndex;
        int size = localLastIndex - this.firstIndex;
        if (0 < location && location < size) {
            if (this.firstIndex == 0 && localLastIndex == this.array.length) {
                localLastIndex = this.growForInsert(location, 1, localLastIndex);
            } else if (location < size / 2 && this.firstIndex > 0 || localLastIndex == this.array.length) {
                System.arraycopy(this.array, this.firstIndex, this.array, --this.firstIndex, location);
            } else {
                int index = location + this.firstIndex;
                System.arraycopy(this.array, index, this.array, index + 1, size - location);
                ++localLastIndex;
            }
            this.array[location + this.firstIndex] = object;
        } else if (location == 0) {
            if (this.firstIndex == 0) {
                localLastIndex = this.growAtFront(1, localLastIndex);
            }
            this.array[--this.firstIndex] = object;
        } else if (location == size) {
            if (localLastIndex == this.array.length) {
                localLastIndex = this.growAtEnd(1, localLastIndex);
            }
            this.array[localLastIndex++] = object;
        } else {
            throw new IndexOutOfBoundsException("" + location + " is out of bounds for " + (localLastIndex - this.firstIndex));
        }
        this.lastIndex = localLastIndex;
    }

    public boolean addAll(Collection<Double> collection) {
        int localLastIndex = this.lastIndex;
        Double[] dumpArray = collection.toArray(new Double[collection.size()]);
        if (dumpArray.length == 0) {
            return false;
        }
        if (dumpArray.length > this.array.length - localLastIndex) {
            localLastIndex = this.growAtEnd(dumpArray.length, localLastIndex);
        }
        for (Double i : dumpArray) {
            this.array[localLastIndex++] = i;
        }
        this.lastIndex = localLastIndex;
        return true;
    }

    public boolean addAll(int location, Collection<Double> collection) {
        int index;
        int localLastIndex = this.lastIndex;
        int size = localLastIndex - this.firstIndex;
        if (location < 0 || location > size) {
            throw new IndexOutOfBoundsException("" + location + " is out of bounds for " + (localLastIndex - this.firstIndex));
        }
        int growSize = collection.size();
        if (0 < location && location < size) {
            if (this.array.length - size < growSize) {
                localLastIndex = this.growForInsert(location, growSize, localLastIndex);
            } else if (location < size / 2 && this.firstIndex > 0 || localLastIndex > this.array.length - growSize) {
                int newFirst = this.firstIndex - growSize;
                if (newFirst < 0) {
                    index = location + this.firstIndex;
                    System.arraycopy(this.array, index, this.array, index - newFirst, size - location);
                    localLastIndex -= newFirst;
                    newFirst = 0;
                }
                System.arraycopy(this.array, this.firstIndex, this.array, newFirst, location);
                this.firstIndex = newFirst;
            } else {
                int index2 = location + this.firstIndex;
                System.arraycopy(this.array, index2, this.array, index2 + growSize, size - location);
                localLastIndex += growSize;
            }
        } else if (location == 0) {
            localLastIndex = this.growAtFront(growSize, localLastIndex);
            this.firstIndex -= growSize;
        } else if (location == size) {
            if (localLastIndex > this.array.length - growSize) {
                localLastIndex = this.growAtEnd(growSize, localLastIndex);
            }
            localLastIndex += growSize;
        }
        if (growSize > 0) {
            Double[] dumparray = new Double[growSize];
            collection.toArray(dumparray);
            index = location + this.firstIndex;
            for (Double i : dumparray) {
                this.array[index++] = i;
            }
            this.lastIndex = localLastIndex;
            return true;
        }
        this.lastIndex = localLastIndex;
        return false;
    }

    public void clear() {
        if (this.firstIndex != this.lastIndex) {
            Arrays.fill(this.array, this.firstIndex, this.lastIndex, 0.0);
            this.lastIndex = 0;
            this.firstIndex = 0;
        }
    }

    public boolean contains(double object) {
        for (int i = this.firstIndex; i < this.lastIndex; ++i) {
            if (object != this.array[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection<Double> collection) {
        Iterator<Double> it = collection.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (this.array.length < minimumCapacity) {
            this.lastIndex = this.firstIndex > 0 ? this.growAtFront(minimumCapacity - this.array.length, this.lastIndex) : this.growAtEnd(minimumCapacity - this.array.length, this.lastIndex);
        }
    }

    public void reserve(int minimumCapacity) {
        this.ensureCapacity(minimumCapacity);
    }

    public int capacity() {
        return this.array.length;
    }

    public double get(int location) {
        if (0 <= location && location < this.lastIndex - this.firstIndex) {
            return this.array[this.firstIndex + location];
        }
        throw new IndexOutOfBoundsException("" + location + " is out of bounds for " + (this.lastIndex - this.firstIndex));
    }

    public int indexOf(double object) {
        for (int i = this.firstIndex; i < this.lastIndex; ++i) {
            if (object != this.array[i]) continue;
            return i - this.firstIndex;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.lastIndex == this.firstIndex;
    }

    public int lastIndexOf(double object) {
        for (int i = this.lastIndex - 1; i >= this.firstIndex; --i) {
            if (object != this.array[i]) continue;
            return i - this.firstIndex;
        }
        return -1;
    }

    public double remove(int location) {
        double result;
        int localLastIndex = this.lastIndex;
        int size = localLastIndex - this.firstIndex;
        if (0 <= location && location < size) {
            if (location == size - 1) {
                result = this.array[--localLastIndex];
                this.array[localLastIndex] = 0.0;
            } else if (location == 0) {
                result = this.array[this.firstIndex];
                this.array[this.firstIndex++] = 0.0;
            } else {
                int elementIndex = this.firstIndex + location;
                result = this.array[elementIndex];
                if (location < size / 2) {
                    System.arraycopy(this.array, this.firstIndex, this.array, this.firstIndex + 1, location);
                    this.array[this.firstIndex++] = 0.0;
                } else {
                    System.arraycopy(this.array, elementIndex + 1, this.array, elementIndex, size - location - 1);
                    this.array[--localLastIndex] = 0.0;
                }
            }
            if (this.firstIndex == localLastIndex) {
                localLastIndex = 0;
                this.firstIndex = 0;
            }
        } else {
            throw new IndexOutOfBoundsException("" + location + " is out of bounds for " + (localLastIndex - this.firstIndex));
        }
        this.lastIndex = localLastIndex;
        return result;
    }

    public boolean removeValue(double object) {
        int location = this.indexOf(object);
        if (location >= 0) {
            this.remove(location);
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection<Double> collection) {
        boolean result = false;
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            if (!collection.contains(this.get(i))) continue;
            this.remove(i);
            result = true;
        }
        return result;
    }

    public boolean retainAll(Collection<Double> collection) {
        boolean result = false;
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            if (collection.contains(this.get(i))) continue;
            this.remove(i);
            result = true;
        }
        return result;
    }

    public double set(int location, double object) {
        if (0 <= location && location < this.lastIndex - this.firstIndex) {
            double result = this.array[this.firstIndex + location];
            this.array[this.firstIndex + location] = object;
            return result;
        }
        throw new IndexOutOfBoundsException("" + location + " is out of bounds for " + (this.lastIndex - this.firstIndex));
    }

    public void assign(Collection<Double> collection) {
        this.lastIndex = 0;
        this.firstIndex = 0;
        Double[] dumpArray = collection.toArray(new Double[collection.size()]);
        int size = dumpArray.length;
        if (this.array.length < size) {
            this.array = this.newElementArray(size + size / 10);
        }
        for (Double i : dumpArray) {
            this.array[this.lastIndex++] = i;
        }
    }

    public void assign(double[] arr) {
        this.firstIndex = 0;
        int size = arr.length;
        if (this.array.length < size) {
            this.array = this.newElementArray(size + size / 10);
        }
        System.arraycopy(arr, 0, this.array, 0, size);
        this.lastIndex = size;
    }

    public void assign(int n, double value) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.firstIndex = 0;
        if (this.array.length < n) {
            this.array = this.newElementArray(n + n / 10);
        }
        this.lastIndex = n;
        Arrays.fill(this.array, this.firstIndex, this.lastIndex, value);
    }

    public int size() {
        return this.lastIndex - this.firstIndex;
    }

    public double[] subArray(int start, int end) {
        if (0 <= start && end <= this.size()) {
            if (start <= end) {
                int size = end - start;
                double[] result = this.newElementArray(size);
                System.arraycopy(this.array, this.firstIndex, result, 0, size);
                return result;
            }
            throw new IllegalArgumentException();
        }
        throw new IndexOutOfBoundsException();
    }

    public double[] toArray() {
        int size = this.lastIndex - this.firstIndex;
        double[] result = this.newElementArray(size);
        System.arraycopy(this.array, this.firstIndex, result, 0, size);
        return result;
    }

    public double[] toArray(double[] contents) {
        int size = this.lastIndex - this.firstIndex;
        if (size > contents.length) {
            contents = this.newElementArray(size);
        }
        System.arraycopy(this.array, this.firstIndex, contents, 0, size);
        if (size < contents.length) {
            contents[size] = 0.0;
        }
        return contents;
    }

    public List<Double> toList() {
        ArrayList<Double> result = new ArrayList<Double>(this.size());
        for (int i = this.firstIndex; i < this.lastIndex; ++i) {
            result.add(this.array[i]);
        }
        return result;
    }

    public void trimToSize() {
        int size = this.lastIndex - this.firstIndex;
        double[] newArray = this.newElementArray(size);
        System.arraycopy(this.array, this.firstIndex, newArray, 0, size);
        this.array = newArray;
        this.firstIndex = 0;
        this.lastIndex = this.array.length;
    }

    public double front() {
        return this.size() == 0 ? Double.NaN : this.get(0);
    }

    public double back() {
        int size = this.size();
        return size == 0 ? Double.NaN : this.get(size - 1);
    }

    public void resize(int n) {
        this.resize(n, Double.NaN);
    }

    public void resize(int n, double value) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int size = this.size();
        if (n < size) {
            this.lastIndex -= size - n;
        } else if (n > size) {
            int required = n - size;
            int localLastIndex = this.lastIndex;
            if (required > this.array.length - localLastIndex) {
                localLastIndex = this.growAtEnd(required, localLastIndex);
            }
            for (int i = 0; i < required; ++i) {
                this.array[localLastIndex++] = value;
            }
            this.lastIndex = localLastIndex;
        }
    }

    public void update(int location, double value) {
        if (0 <= location && location < this.lastIndex - this.firstIndex) {
            int n = this.firstIndex + location;
            this.array[n] = this.array[n] + value;
        }
        throw new IndexOutOfBoundsException("" + location + " is out of bounds for " + (this.lastIndex - this.firstIndex));
    }

    public DoubleArray clone() {
        try {
            DoubleArray result = (DoubleArray)super.clone();
            result.array = (double[])this.array.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public Object readObject(DataInput dataInput) throws IOException {
        int size = dataInput.readInt();
        this.array = this.newElementArray(size);
        for (int i = 0; i < size; ++i) {
            this.array[i] = dataInput.readDouble();
        }
        this.firstIndex = 0;
        this.lastIndex = size;
        return this;
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        int size = this.size();
        dataOutput.writeInt(size);
        for (int i = this.firstIndex; i < this.lastIndex; ++i) {
            dataOutput.writeDouble(this.array[i]);
        }
    }

    private double[] newElementArray(int size) {
        return new double[size];
    }

    private int growAtEnd(int required, int localLastIndex) {
        int size = localLastIndex - this.firstIndex;
        if (this.firstIndex >= required - (this.array.length - localLastIndex)) {
            int newLast = localLastIndex - this.firstIndex;
            if (size > 0) {
                System.arraycopy(this.array, this.firstIndex, this.array, 0, size);
            }
            this.firstIndex = 0;
            localLastIndex = newLast;
        } else {
            int increment = size / 2;
            if (required > increment) {
                increment = required;
            }
            if (increment < 12) {
                increment = 12;
            }
            double[] newArray = this.newElementArray(size + increment);
            if (size > 0) {
                System.arraycopy(this.array, this.firstIndex, newArray, 0, size);
                this.firstIndex = 0;
                localLastIndex = size;
            }
            this.array = newArray;
        }
        return localLastIndex;
    }

    private int growAtFront(int required, int localLastIndex) {
        int size = localLastIndex - this.firstIndex;
        if (this.array.length - localLastIndex + this.firstIndex >= required) {
            int newFirst = this.array.length - size;
            if (size > 0) {
                System.arraycopy(this.array, this.firstIndex, this.array, newFirst, size);
            }
            this.firstIndex = newFirst;
            localLastIndex = this.array.length;
        } else {
            int increment = size / 2;
            if (required > increment) {
                increment = required;
            }
            if (increment < 12) {
                increment = 12;
            }
            double[] newArray = this.newElementArray(size + increment);
            if (size > 0) {
                System.arraycopy(this.array, this.firstIndex, newArray, newArray.length - size, size);
            }
            this.firstIndex = newArray.length - size;
            localLastIndex = newArray.length;
            this.array = newArray;
        }
        return localLastIndex;
    }

    private int growForInsert(int location, int required, int localLastIndex) {
        int size = localLastIndex - this.firstIndex;
        int increment = size / 2;
        if (required > increment) {
            increment = required;
        }
        if (increment < 12) {
            increment = 12;
        }
        double[] newArray = this.newElementArray(size + increment);
        if (location < size / 2) {
            int newFirst = newArray.length - (size + required);
            System.arraycopy(this.array, location + this.firstIndex, newArray, location + increment, size - location);
            System.arraycopy(this.array, this.firstIndex, newArray, newFirst, location);
            this.firstIndex = newFirst;
            localLastIndex = newArray.length;
        } else {
            System.arraycopy(this.array, this.firstIndex, newArray, 0, location);
            System.arraycopy(this.array, location + this.firstIndex, newArray, location + required, size - location);
            this.firstIndex = 0;
            localLastIndex = size + required;
        }
        this.array = newArray;
        return localLastIndex;
    }
}

